package eworks.eRQL.model;

import eworks.RDF.model.*;
import eworks.RQL.engine.RqlEngine;
import eworks.eRQL.engine.RqlExecutingException;

/**
 * <p>Abstract base class for evaluable components of eRQL queries.</p>
 * 
 * @author Fabian Wleklinski (<a href="mailto:fabian@wleklinski.de">fabian@wleklinski.de</a>)
 * @version 1.00 (2003-11-03)
 */
public abstract class Value extends ModelComponent {

	/**
	 * Compacts this value and returns the compacted value.
	 * 
	 * @return compacted value.
	 */
	public Value compact() {
		return this;
	}

	/**
	 * Evaluates this part of the query.
	 * 
	 * @param rqlEngine The RqlEngine to execute.
	 * @return The subquery's result.
	 * @throws RqlExecutingException if something goes wrong.
	 */
	public abstract Tuples query(RqlEngine rqlEngine) throws RqlExecutingException;
}