package eworks.eRQL.model;

import eworks.RDF.model.SingleGroupedTuples;
import eworks.RDF.model.Tuples;
import eworks.RQL.engine.RqlEngine;
import eworks.eRQL.engine.RqlExecutingException;

/**
 * <p>A specialized query class for socalled "statement queries".</p>
 * 
 * @author Fabian Wleklinski (<a href="mailto:fabian@wleklinski.de">fabian@wleklinski.de</a>)
 * @version 1.00 (2003-11-03)
 */
public class StatementQuery extends Query {

	/**
	 * Creates an empty statement query.
	 */
	public StatementQuery() {
		super();
	}

	/**
	 * Creates an statement query and encapsulated the given <code>value</code>.
	 */
	public StatementQuery(Value value) {
		super(value);
	}

	/**
	 * Returns this query's string representation.
	 * 
	 * @return this query's string representation.
	 */
	public String toString() {
		return "StatementQuery[ " + this.value.toString() + " ]";
	}

	/**
	 * Compacts this query and returns the result.
	 * 
	 * @return the compacted query.
	 */
	public Value compact() {
		Value result = super.compact();
		
		if (result instanceof StatementQuery)
			if (((StatementQuery) result).value instanceof StatementQuery)
				result = ((StatementQuery) result).value;
	
		return result;
	}

	/**
	 * Evaluates this query and returns the result using the given <code>rqlEngine</code>.
	 * 
	 * @return the query's result.
	 * @throws RqlExecutingException if something goes wrong.
	 */
	public Tuples query(RqlEngine rqlEngine) throws RqlExecutingException {
		
		Tuples innerResult = this.value.query(rqlEngine);
		
		if (innerResult instanceof SingleGroupedTuples)
			return innerResult;
		
		return new SingleGroupedTuples(innerResult);
	}
}