package eworks.eRQL.model;

import eworks.RDF.model.Tuples;
import eworks.RQL.engine.RqlEngine;
import eworks.eRQL.engine.RqlExecutingException;

/**
 * <p>Abstract base class for subqueries.</p>
 * 
 * @author Fabian Wleklinski (<a href="mailto:fabian@wleklinski.de">fabian@wleklinski.de</a>)
 * @version 1.00 (2003-11-03)
 */
public class Query extends Value {

	protected Value value;

	/**
	 * Creates an empty statement query.
	 */
	public Query() {
		super();
	}

	/**
	 * Creates an query and encapsulated the given <code>value</code>.
	 */
	public Query(Value value) {
		this.value=value;
	}
	
	/**
	 * Returns this query's string representation.
	 * 
	 * @return this query's string representation.
	 */
	public String toString() {
		return "Query[ " + this.value.toString() + " ]";
	}
	
	/**
	 * Compacts this query and returns the result.
	 * 
	 * @return the compacted query.
	 */
	public Value compact() {
		this.value = this.value.compact();
		return this;
	}
	
	/**
	 * Evaluates this query and returns the result using the given <code>rqlEngine</code>.
	 * 
	 * @return the query's result.
	 * @throws RqlExecutingException if something goes wrong.
	 */
	public Tuples query(RqlEngine rqlEngine) throws RqlExecutingException {
		return this.value.query(rqlEngine);	
	}
}