package eworks.eRQL.model;

import eworks.RDF.model.*;
import eworks.RQL.engine.RqlEngine;
import eworks.eRQL.engine.RqlExecutingException;

/**
 * <p>Represents a disjunction of subqueries.</p>
 * 
 * @author Fabian Wleklinski (<a href="mailto:fabian@wleklinski.de">fabian@wleklinski.de</a>)
 * @version 1.00 (2003-11-03)
 */
public class Disjunction extends Junction {

	/**
	 * Creates a new and empty disjunction.
	 */
	public Disjunction() {
		super();
	}

	/**
	 * Creates a new disjunction and initializes it with a single <code>value</code>.
	 * 
	 * @param value The value for the initialization of the disjunction.
	 */
	public Disjunction( Value value ) {
		super(value);
	}

	/**
	 * Creates a new dicjunction and initializes it with two values.
	 * 
	 * @param v1 The first value for the initialization of the disjunction.
	 * @param v2 The second value for the initialization of the disjunction.
	 */
	public Disjunction( Value v1, Value v2 ) {
		super(v1,v2);
	}

	/**
	 * Evaluates this disjunction and returns the result.
	 */
	public Tuples query(RqlEngine rqlEngine) throws RqlExecutingException {
		Tuples result = new GroupedTuples();

		for (int i=0; i<this.values.length; i++)
			result.addAll(this.values[i].query(rqlEngine), true);

		return result;
	}
}