package eworks.eRQL.gui;

import java.io.*;

/**
 * <p>A class providing some static methods for supporting other modules.</p>
 * 
 * @author Fabian Wleklinski (<a href="mailto:fabian@wleklinski.de">fabian@wleklinski.de</a>)
 * @version 1.00 (2003-11-03)
 */
public class Utils {
	
	private Utils() {
	}
	
	/**
	 * Gets the extension of a file <code>f</code>.
	 * 
	 * @param f The file.
	 * @return The file's extension.
	 */  
	public static String getExtension(File f) {
		String ext = null;
		String s = f.getName();
		int i = s.lastIndexOf('.');

		if (i > 0 &&  i < s.length() - 1) {
			ext = s.substring(i+1).toLowerCase();
		}
		return ext;
	}
}