package eworks.eRQL.engine;

/**
 * <p>Exception that indicates an error while a RQL query was executed.</p>
 * 
 * @author Fabian Wleklinski (<a href="mailto:fabian@wleklinski.de">fabian@wleklinski.de</a>)
 * @version 1.00 (2003-11-03)
 */
public class RqlExecutingException extends Exception {

	/**
	 * Creates a new instance.
	 */
	public RqlExecutingException() {
		super();
	}

	/**
	 * Creates a new instance with the given description.
	 * 
	 * @param message The exception's description.
	 */
	public RqlExecutingException(String message) {
		super(message);
	}

	/**
	 * Creates a new instance and encapsulated the given exception as the
	 * exception's cause.
	 * 
	 * @param cause The exception which has caused the exception.
	 */
	public RqlExecutingException(Throwable cause) {
		super(cause);
	}

	/**
	 * Creates a new instance and encapsulated the given exception and message
	 * as the exception's cause and description.
	 * 
	 * @param message The exception's description.
	 * @param cause The exception which has caused the exception.
	 */
	public RqlExecutingException(String message, Throwable cause) {
		super(message, cause);
	}
}