package eworks.eRQL.parser;
import java_cup.runtime.*;

%%

%class scanner
%cup
%ignorecase
%8bit
%public

%{
  String name;

  StringBuffer string = new StringBuffer();

  private Symbol symbol(int type) {
    return new Symbol(type, yyline, yycolumn);
  }
  private Symbol symbol(int type, Object value) {
    return new Symbol(type, yyline, yycolumn, value);
  }
%}

LineTerminator = \r|\n|\r\n
WhiteSpace     = {LineTerminator} | [ \t\f]

%state STRING

%%

<YYINITIAL> {
	\"				{ string.setLength(0); yybegin(STRING); }
	{WhiteSpace}			{ }
	"AND"				{ return symbol(sym.ANDOPERATOR); }
	"OR"				{ return symbol(sym.OROPERATOR); }
	&?[a-zA-Z]{3,10}"://"[^ ]+	{ return symbol(sym.URI,yytext()); }
	[^ ()\[\]{}<>~\"\t\n]+		{ return symbol(sym.STRING,yytext()); }
	"("				{ return symbol(sym.LBRACKET); }
	")"				{ return symbol(sym.RBRACKET); }
	"["				{ return symbol(sym.LSQUAREBRACKET); }
	"]"				{ return symbol(sym.RSQUAREBRACKET); }
	"{"				{ return symbol(sym.LCURLYBRACKET); }
	"}"				{ return symbol(sym.RCURLYBRACKET); }
	"<"				{ return symbol(sym.LANGLEBRACKET); }
	">"				{ return symbol(sym.RANGLEBRACKET); }
	"~"				{ return symbol(sym.TILDE); }
}

<STRING> {
	\"				{ yybegin(YYINITIAL); 
					  return symbol(sym.STRING, 
					  string.toString()); }
	[^\n\r\"\\]+			{ string.append( yytext() ); }
	\\t				{ string.append('\t'); }
	\\n				{ string.append('\n'); }

	\\r				{ string.append('\r'); }
	\\\"				{ string.append('\"'); }
	\\				{ string.append('\\'); }
}

/* error fallback */
.|\n					{ throw new Error("Illegal character <" + yytext() + ">"); }