/* This software was developed within the context of the project Metaphor for Science
   Museums (Mesmuses) in the framework of the Information Society Technology
   Programme, part of the Fifth Research And Technological Development
   Framework Programme of the European Community, under the Consortium
   Agreement dated <June 30, 2001>, between INRIA, Finsiel Spa, IMSS,
   Valoris , CSI, ICS-FORTH, ENSTB, EDW International.
*/

package gr.forth.ics.vrp.vrpgui;
import javax.swing.*;
import java.awt.*;
import java.awt.event.*;


/**
 * Displays the statistics dialog layout
 * @author Karsten Tolle & Sofia Alexaki
 * @version 2.5  (30 Januar 2003)
 */

abstract public class StatisticsDialogLayout extends JDialog {
  public JCheckBox model = new JCheckBox("Model",false);
	public JCheckBox timememory = new JCheckBox("Time",false);
	public JLabel stat_label = new JLabel("Statistics about");
  public JCheckBox general = new JCheckBox("Number of schema and data resources ", false);
	public JCheckBox subclass = new JCheckBox("SubClass Hierarchy",false);
  //true when anallytically statistics for class hierarchies will be
  public JCheckBox detailedsubclass = new JCheckBox("Detailed",false);
	public JCheckBox subproperty = new JCheckBox("SubProperty Hierarchy",false);
  public JCheckBox detailedsubproperty = new JCheckBox("Detailed", false);
	public JCheckBox instances = new JCheckBox("Instances Distribution",false);


	protected Container cont;
	protected	JButton ok = new JButton("        Ok        ");

   public StatisticsDialogLayout(JFrame par)  {
      super(par, "Statistics", true);
		cont = getContentPane();
		cont.setLayout(new BoxLayout(cont, BoxLayout.Y_AXIS));

		stat_label.setAlignmentX(JComponent.LEFT_ALIGNMENT);
		model.setAlignmentX(JComponent.LEFT_ALIGNMENT);
		timememory.setAlignmentX(JComponent.LEFT_ALIGNMENT);

		/*JPanel detailPane = new JPanel();
		detailPane.setLayout(new BoxLayout(detailPane, BoxLayout.X_AXIS));
		detailPane.add(Box.createRigidArea(new Dimension(15,0)));
		detailPane.add(detailedsubclass);

		JPanel detail2Pane = new JPanel();
		detail2Pane.setLayout(new BoxLayout(detail2Pane, BoxLayout.X_AXIS));
		detail2Pane.add(Box.createRigidArea(new Dimension(15,0)));
		detail2Pane.add(detailedsubproperty);*/


		JPanel modelPane  = new JPanel(new GridLayout(6,1));
		modelPane.add(general);
		modelPane.add(subclass);
	  // modelPane.add(detailPane);
		modelPane.add(subproperty);
		//modelPane.add(detail2Pane);
      modelPane.add(instances);


	   JPanel modelPane2 = new JPanel();
      modelPane2.setAlignmentX(JComponent.LEFT_ALIGNMENT);
      modelPane2.add(Box.createRigidArea(new Dimension(-50,0)));
	   modelPane2.add(modelPane);

	   JPanel tmpPane = new JPanel();
      tmpPane.setAlignmentX(JComponent.LEFT_ALIGNMENT);
	   ok.setAlignmentX(JComponent.CENTER_ALIGNMENT);
	   ok.setBorder(BorderFactory.createBevelBorder(0));
	   tmpPane.add(ok);

       //Dialog Components
      cont.add(stat_label);
  	   cont.add(model);
      cont.add(modelPane2);
      cont.add(timememory);
      cont.add(tmpPane);

      general.setToolTipText("Prints the number of triples, schema and data resources!");
      subclass.setToolTipText("Prints total statistics for subclass hierarchies!");
      detailedsubclass.setToolTipText("Prints statistics for every subclass hierarchy !");
      subproperty.setToolTipText("Prints total statistics for subproperty hierarchies !");
      detailedsubproperty.setToolTipText("Prints statistics for every subproperty hierarchy !");
      instances.setToolTipText("Prints the instances distribution!");
      timememory.setToolTipText("Prints the time required for parsing & validation!");

	    ok.addActionListener(new  ActionListener() {
			public void actionPerformed(ActionEvent e) {
			   dispose();
			 }});

/*	 setSize(330, 280);
	 show();*/
   }
}
