/* This software was developed within the context of the project Metaphor for Science
   Museums (Mesmuses) in the framework of the Information Society Technology
   Programme, part of the Fifth Research And Technological Development
   Framework Programme of the European Community, under the Consortium
   Agreement dated <June 30, 2001>, between INRIA, Finsiel Spa, IMSS,
   Valoris , CSI, ICS-FORTH, ENSTB, EDW International.
*/

package gr.forth.ics.vrp.vrpgui;

import javax.swing.*;
import java.awt.event.*;

/**
 * StatisticsFrame.java - A helper class for the GUI of VRP.
 * Shows the statistics
 * @author Karsten Tolle & Sofia Alexaki
 * @version 2.5  (30 Januar 2003)
 */
class StatisticsDialog extends StatisticsDialogLayout {

   public StatisticsDialog(JFrame par, boolean validation)  {
      super(par);
   	  CheckBoxListener myListener = new CheckBoxListener();
	    general.addActionListener(myListener);
   	  subclass.addActionListener(myListener);
	    subproperty.addActionListener(myListener);
   	  instances.addActionListener(myListener);
	    model.addActionListener(myListener);
 	    detailedsubclass.addActionListener(myListener);
 	    detailedsubproperty.addActionListener(myListener);
   	  timememory.addActionListener(myListener);

      if (!validation)   {
         model.setEnabled(false);
         subclass.setEnabled(false);
         subproperty.setEnabled(false);
         general.setEnabled(false);
         instances.setEnabled(false);
      }
	    setSize(350, 300);
	    show();
   }

   class CheckBoxListener implements ActionListener {
		public void actionPerformed(ActionEvent e) {
       boolean d = false;
			 Object source = e.getSource();
		   if (((JCheckBox)source).isSelected())
				  d = true;
       if (source == subclass) {
		      if (!d) {
             VRPPanel.main.enableModelStatistics(1, false);
             if (detailedsubclass.isSelected())
			  	      detailedsubclass.doClick();
          }else
             VRPPanel.main.enableModelStatistics(1, true);
       } else if (source == subproperty) {
		       if (!d) {
              VRPPanel.main.enableModelStatistics(2, false);
              if (detailedsubproperty.isSelected())
			  	      detailedsubproperty.doClick();
           } else  VRPPanel.main.enableModelStatistics(2, true);
       } else if (source == instances) {
		        if (!d)  VRPPanel.main.enableModelStatistics(3, false);
            else  VRPPanel.main.enableModelStatistics(3, true);
			 } else if (source == general) {
			    if (!d)  VRPPanel.main.enableModelStatistics(0, false); else  VRPPanel.main.enableModelStatistics(0, true);
			 } else if (source == detailedsubclass) {
			    if (!d)  VRPPanel.main.enableModelStatistics(4, false);
          else {
            VRPPanel.main.enableModelStatistics(4, true);
            if (!subclass.isSelected())
			  	      subclass.doClick();
          }
			 } else if (source == detailedsubproperty) {
			    if (!d)  VRPPanel.main.enableModelStatistics(5, false);
          else {
            VRPPanel.main.enableModelStatistics(5, true);
             if (!subproperty.isSelected())
			  	      subproperty.doClick();
          }
			} else if (source == model) {
				if (!d) {
			  	if (general.isSelected())
					general.doClick();
				if (subclass.isSelected())
			  	   subclass.doClick();
			  	if (subproperty.isSelected())
					subproperty.doClick();
			  	if (instances.isSelected())
					instances.doClick();
				} else  {
				   if (!general.isSelected())
					  general.doClick();
				   if (!subclass.isSelected())
			  	      subclass.doClick();
			  	   if (!subproperty.isSelected())
				 	  subproperty.doClick();
			  	   if (!instances.isSelected())
					  instances.doClick();
				}
		    } else if (source == timememory) {
			    if (!d)  VRPPanel.main.settimeStatistics(false);
             else  VRPPanel.main.settimeStatistics(true);
			}

		 }
	}
  }
