/* This software was developed within the context of the project Metaphor for Science
   Museums (Mesmuses) in the framework of the Information Society Technology
   Programme, part of the Fifth Research And Technological Development
   Framework Programme of the European Community, under the Consortium
   Agreement dated <June 30, 2001>, between INRIA, Finsiel Spa, IMSS,
   Valoris , CSI, ICS-FORTH, ENSTB, EDW International.
*/

package gr.forth.ics.vrp.vrpgui;
import javax.swing.*;
import javax.swing.filechooser.FileFilter;
import java.awt.*;
import java.awt.event.*;
import java.io.File;


/**
 * Displays the SVG output option dialog
 *
 * @author Ta Tuan Anh
 * @version 2.5  (30 Januar 2003)
 */
public class SVGOutputDialog extends JDialog {

	private JTextField output = new JTextField("output.svg",20);
	private JButton select_output = new JButton("Browse");

	private JComboBox width = new JComboBox();
	private JComboBox height = new JComboBox();

	protected Container cont;
	protected	JButton ok = new JButton("        Ok        ");

	public SVGOutputDialog(JFrame par)  {
    	super(par, "SVG output option", true);
    	JPanel filePane = new JPanel();
    	select_output.setBorder(BorderFactory.createBevelBorder(0));
    	filePane.add(output);
		filePane.add(select_output);
		filePane.setBorder(BorderFactory.createTitledBorder("File name"));

		width.addItem("800");
		width.addItem("1024");
		width.addItem("1280");
		width.setEditable(true);
		width.setSelectedItem("800");
		height.addItem("600");
		height.addItem("768");
		height.addItem("1024");
		height.setEditable(true);
		height.setSelectedItem("600");

		JPanel sizePane1 = new JPanel();
		sizePane1.add(new JLabel("Width"));
		sizePane1.add(width);

		JPanel sizePane2 = new JPanel();
		sizePane2.add(new JLabel("Height"));
		sizePane2.add(height);

		JPanel sizePane = new JPanel();
		sizePane.setLayout(new BoxLayout(sizePane, BoxLayout.X_AXIS));
		sizePane.add(sizePane1);
		sizePane.add(Box.createRigidArea(new Dimension(15,0)));
		sizePane.add(Box.createHorizontalGlue());
		sizePane.add(sizePane2);
		sizePane.setBorder(BorderFactory.createTitledBorder("SVG size"));

	  cont = getContentPane();
	  cont.setLayout(new BoxLayout(cont, BoxLayout.Y_AXIS));

	  JPanel tmpPane = new JPanel();
     tmpPane.setAlignmentX(JComponent.LEFT_ALIGNMENT);
	  ok.setAlignmentX(JComponent.CENTER_ALIGNMENT);
	  ok.setBorder(BorderFactory.createBevelBorder(0));
	  tmpPane.add(ok);

       //Dialog Components
      cont.add(filePane);
  	  cont.add(sizePane);
		cont.add(tmpPane);

	  ok.addActionListener(new  ActionListener() {
			public void actionPerformed(ActionEvent e) {
			   dispose();
			 }});

	  select_output.addActionListener(new  ActionListener() {
			public void actionPerformed(ActionEvent e) {
			   select_file();
			 }});
	  pack();
   }

   private void select_file()
   {
	   JFileChooser fc = new JFileChooser();
	   fc.setDialogTitle("Select file");
	   fc.setFileFilter(new FileFilter() {
	   	    public boolean accept(File f) {
	   		if(f != null) {
	   			if(f.isDirectory()) {
	   				return true;
	   			}
	   			String extension = getExtension(f);
	   			if(extension != null && (extension.equals("svg"))) {
	   				return true;
	   			};
	   		}
	   		return false;
	   		}
        	public String getExtension(File f) {
   			if(f != null) {
   				String filename = f.getName();
   				int i = filename.lastIndexOf('.');
   				if(i>0 && i<filename.length()-1) {
   					return filename.substring(i+1).toLowerCase();
   				}
   			}
   				return null;
   			}
   			public String getDescription() {
   				return "SVG files (*.svg)";
   			}
   		});

	   int rVal = fc.showDialog(this, "Ok");
	   if (rVal == JFileChooser.APPROVE_OPTION) {
	       StringBuffer sb = new StringBuffer();
	       sb.append(fc.getCurrentDirectory().toString());
	   	   sb.append(File.separator);
	       sb.append(fc.getSelectedFile().getName());
	       output.setText(sb.toString());
	   }
   }

   public void dispose()
   {
   		if (output.getText().equals("")) output.setText("output.svg");
		VRPPanel.main.setsvgoutput(output.getText());
		int w, h;
		try
		{
			w = Integer.parseInt(width.getSelectedItem().toString());
		}catch (Exception e) { w = 800;	}
		if (w < 600) w = 600;
		try
		{
			h = Integer.parseInt(height.getSelectedItem().toString());
		}catch (Exception e) { h = 800;	}
		if (h < 480) h = 480;
		width.setSelectedItem(String.valueOf(w));
		height.setSelectedItem(String.valueOf(h));
		VRPPanel.main.setsvgsize(w,h);
		super.dispose();
   }
}
