/* This software was developed within the context of the project Metaphor for Science
   Museums (Mesmuses) in the framework of the Information Society Technology
   Programme, part of the Fifth Research And Technological Development
   Framework Programme of the European Community, under the Consortium
   Agreement dated <June 30, 2001>, between INRIA, Finsiel Spa, IMSS,
   Valoris , CSI, ICS-FORTH, ENSTB, EDW International.
*/

package gr.forth.ics.vrp.vrpgui;

import javax.swing.*;

/**
 * A helper class for the GUI of VRP .
 * Displays the Results & Messages output areas
 *
 * @author Karsten Tolle & Sofia Alexaki
 * @version 2.5  (30 Januar 2003)
 */
public class MyPanel extends JPanel {

   public MyPanel() {
   }

   public JTextArea Results = new JTextArea(11, 6);
	 public JTextArea Messages = new JTextArea(11, 6);
   private int ColumnCounter = 0;

   public void out(String s, boolean isRes) {
		ColumnCounter = ColumnCounter + s.length();
		if (ColumnCounter >= 60) {
			outln(s, isRes);
			ColumnCounter = 0;
		} else if (isRes)
			Results.append(s);
		else
			Messages.append(s);
	}

  /**
   * Reports the message s.
   * @param s the message which will reported
   * @param s  Indicates whether the output will be reported in the Results
   * or Messages text areas.
   */
	public void outln(String s, boolean isRes) {
		if (isRes) {
		    Results.append(s+"\n");
      } else {
			Messages.append(s + "\n");
      }
	}

}
