package gr.forth.ics.vrp.vrpgui;

import javax.swing.*;
import java.awt.*;
import java.awt.event.*;

import java.util.*;

/**
 * @author Karsten Tolle & Sofia Alexaki
 * @version 2.5  (30 Januar 2003)
 */

public class ChooseOutNamespaceDialog extends JDialog {

	/**
	 * Contains the checkbox and the URI of the namespace that represents the check box
	 */
	private HashMap nsCBMap = new HashMap();

	private JButton ok = new JButton("        OK        ");

	public ChooseOutNamespaceDialog(JFrame par, Collection ns) {
		super(par, "Choose Namespaces", true);
		JPanel outNSPane = new JPanel();
		Container cont = getContentPane();
		BoxLayout bl = new BoxLayout(cont, BoxLayout.Y_AXIS);
		cont.setLayout(bl);

		JLabel label = new JLabel("Choose the external namespaces you wish to include in the output model:");
		label.setAlignmentX(JComponent.CENTER_ALIGNMENT);
		cont.add(label);

		JPanel nsPane  = new JPanel(new GridLayout(ns.size(),1));
		nsPane.setAlignmentX(JComponent.CENTER_ALIGNMENT);
		for (Iterator it = ns.iterator(); it.hasNext(); ){
			String nsURI = (String)it.next();
			boolean checked = false;
			JCheckBox nsCB = new JCheckBox(nsURI, checked);
			nsCBMap.put(nsCB, nsURI);
			nsPane.add(nsCB);
		}
			cont.add(nsPane);

		JPanel okPane = new JPanel();
		okPane.setAlignmentX(JComponent.CENTER_ALIGNMENT);
		ok.setAlignmentX(JComponent.CENTER_ALIGNMENT);
		ok.setBorder(BorderFactory.createBevelBorder(0));
		okPane.add(ok);

		cont.add(ok);
		ok.addActionListener(new  ActionListener() {
			public void actionPerformed(ActionEvent e) {
				dispose();
			 }});

		//Dimension dim = bl.preferredLayoutSize(cont);

		int width = ns.size()*30 + 100;
		setSize(600, width);
		show();

	}

	public HashSet getSelectedNS() {
		HashSet nsAL = new HashSet();
		Set cbs = nsCBMap.keySet();
		for (Iterator it = cbs.iterator(); it.hasNext(); ){
			JCheckBox cb = (JCheckBox)it.next();
			if (cb.isSelected()) {
				nsAL.add(nsCBMap.get(cb));
			}
		}
		return nsAL;
		//return the string that corressponds to the list of the selected namespaces
	}
}
