																								/* This software was developed within the context of the project Metaphor for Science
   Museums (Mesmuses) in the framework of the Information Society Technology
   Programme, part of the Fifth Research And Technological Development
   Framework Programme of the European Community, under the Consortium
   Agreement dated <June 30, 2001>, between INRIA, Finsiel Spa, IMSS,
   Valoris , CSI, ICS-FORTH, ENSTB, EDW International.
*/

package gr.forth.ics.vrp.visualization;

import java.io.*;
import gr.forth.ics.vrp.corevrp.broker.*;

/**
 *
 * @author Ta Tuan Anh
 * @version 2.5  (30 Januar 2003)
 */

public abstract class RDF_Visualization {

	protected RDF_SemanticBroker broker;
	FileWriter out;

	public RDF_Visualization(RDF_SemanticBroker broker)
	{
		this.broker = broker;
	}

	protected void println(String str) throws IOException
	{
		out.write(str+"\n");
	}

	public void writeToFile(String filename) throws IOException
	{
		out = new FileWriter(filename);
		generate();
		out.close();
	}

	protected abstract void generate() throws IOException;
}





















