/* This software was developed within the context of the project Metaphor for Science
   Museums (Mesmuses) in the framework of the Information Society Technology
   Programme, part of the Fifth Research And Technological Development
   Framework Programme of the European Community, under the Consortium
   Agreement dated <June 30, 2001>, between INRIA, Finsiel Spa, IMSS,
   Valoris , CSI, ICS-FORTH, ENSTB, EDW International.
*/

// rdfschema.java
/*
 *  CHANGE LOG:
 *  Each entry starts with a date, who did the changed and what has been done.
 *  Separated by ':'.
 *
 *  13.06.2002 : Karsten Tolle : Added rdfs:member to the vocabulary.
 *
 *  14.11.2002 : Karsten Tolle : Added the XMLRep to the vocabulary.
 *
 *  05.12.2002 : Karsten Tolle : Added rdfs:Datatype and rdfs:XMLLiteral to the
 *                               vocabulary and the latest XMLRep.
 *
 *  29.01.2003 : Karsten Tolle : The class XMLLiteral has been moved to the rdf
 *                               namespace. See RDF/XML Syntax Specification (Revised)
 *                               of the 23. of Januar 2003.
 */

package gr.forth.ics.vrp.corevrp.vocabulary;

import java.util.*;

/**
 *  rdfschema.java - Containing the parameters for the RDF Schema namespaces.
 *
 * @author Karsten Tolle & Sofia Alexaki
 * @version 2.5  (30 Januar 2003)
 */
public class rdfschema {


	 // the address for the RDF and RDF-Schema namespaces
	//  OLD NS The RDF Schema namespace URL: "http://www.w3.org/TR/1999/PR-rdf-schema-19990303#"*/
    	//  OLD NS final static public String NS = "http://www.w3.org/TR/1999/PR-rdf-schema-19990303#";
	/** The RDF Schema namespace URL: "http://www.w3.org/2000/01/rdf-schema#"*/
    	final static public String NS = "http://www.w3.org/2000/01/rdf-schema#";


	// The elements of the NS: ""+<element name>
	/** Element from the RDF Schema namespace: NS+"Resource"*/
	final static public String Resource = NS+"Resource";
	/** Element from the RDF Schema namespace: NS+"comment"*/
	final static public String comment = NS+"comment";
	/** Element from the RDF Schema namespace: NS+"label"*/
	final static public String label = NS+"label";
	/** Element from the RDF Schema namespace: NS+"Class"*/
	final static public String Class = NS+"Class";
	/** Element from the RDF Schema namespace: NS+"subClassOf"*/
	final static public String subClassOf = NS+"subClassOf";
	/** Element from the RDF Schema namespace: NS+"subPropertyOf"*/
	final static public String subPropertyOf = NS+"subPropertyOf";
	/** Element from the RDF Schema namespace: NS+"seeAlso"*/
	final static public String seeAlso = NS+"seeAlso";
	/** Element from the RDF Schema namespace: NS+"isDefinedBy"*/
	final static public String isDefinedBy = NS+"isDefinedBy";
	/** Element from the RDF Schema namespace: NS+"ConstraintResource"*/
	final static public String ConstraintResource = NS+"ConstraintResource";
	/** Element from the RDF Schema namespace: NS+"ConstraintProperty"*/
	final static public String ConstraintProperty = NS+"ConstraintProperty";
	/** Element from the RDF Schema namespace: NS+"domain"*/
	final static public String domain = NS+"domain";
	/** Element from the RDF Schema namespace: NS+"range"*/
	final static public String range = NS+"range";
	/** Element from the RDF Schema namespace: NS+"Literal"*/
	final static public String Literal = NS+"Literal";
	/** Element from the RDF Schema namespace: NS+"Container"*/
	final static public String Container = NS+"Container";
	/** Element from the RDF Schema namespace: NS+"ContainerMembershipProperty"*/
	final static public String ContainerMembershipProperty = NS+"ContainerMembershipProperty";
        /** Element from the RDF Schema namespace: NS+"member"*/
	final static public String member = NS+"member";


        final static public String Datatype = NS+"Datatype";
        // moved to the rdf namespace
        //final static public String XMLLiteral = NS+"XMLLiteral";

	/** Since the w3c appended a description to the schema ns a genID:1 will be generated. */
	final static public String genID1 = NS+"genID:1";


	/** The set of Classes from the RDF Schema namespace. */
	static public ArrayList Classes = init_Classes();
	/** The set of Properties from the RDF Schema namespace. */
	static public ArrayList Properties = init_Properties();
	/** The set of all resources. */
	static public ArrayList all = init_all();


	/**
         * The classes of RDF-Schema namespace.
	 */
	private static ArrayList init_Classes() {
		ArrayList AL = new ArrayList();
		AL.add(Resource);
		AL.add(Class);
		AL.add(ConstraintResource);
		AL.add(ConstraintProperty);
		AL.add(Literal);
		AL.add(Container);
		AL.add(ContainerMembershipProperty);
                AL.add(Datatype);
		return AL;
	}

	/**
         * The properties of RDF-Schema namespace.
	 */
	private static ArrayList init_Properties() {
		ArrayList AL = new ArrayList();
		AL.add(comment);
		AL.add(label);
		AL.add(domain);
		AL.add(range);
		AL.add(isDefinedBy);
		AL.add(seeAlso);
		AL.add(subPropertyOf);
		AL.add(subClassOf);
                AL.add(member);
		return AL;
	}

	/**
	 * All resources of the RDF-Schema namespace.
	 */
	private static ArrayList init_all() {
		ArrayList AL = init_Classes();
		AL.addAll(init_Properties());
		AL.add(genID1);
		return AL;
	}

        final static public String XMLRep = "<?xml version=\"1.0\"?>" +
"<!DOCTYPE rdf:RDF [" +
"   <!ENTITY rdf \"http://www.w3.org/1999/02/22-rdf-syntax-ns#\">  " +
"   <!ENTITY rdfs \"http://www.w3.org/2000/01/rdf-schema#\">" +
"]>  " +
"" +
"<!-- Universal RDF Schema namespace written by Karsten Tolle, 29.01.2003. -->" +
"" +
"<rdf:RDF" +
"   xmlns:rdf=\"&rdf;\"" +
"   xmlns:rdfs=\"&rdfs;\">" +
"" +
"<rdfs:Class rdf:about=\"&rdfs;Resource\">" +
"  <rdfs:isDefinedBy rdf:resource=\"&rdfs;\"/>" +
"  <rdfs:label xml:lang=\"en\">Resource</rdfs:label>" +
"  <rdfs:comment>The class resource, everything.</rdfs:comment>" +
"</rdfs:Class>" +
"" +
"<rdf:Property rdf:about=\"&rdf;type\">" +
"  <rdfs:isDefinedBy rdf:resource=\"&rdf;\"/>" +
"  <rdfs:label xml:lang=\"en\">type</rdfs:label>" +
"  <rdfs:comment>Indicates membership of a class</rdfs:comment>" +
"  <rdfs:range rdf:resource=\"&rdfs;Class\"/>" +
"  <rdfs:domain rdf:resource=\"&rdfs;Resource\"/>" +
"</rdf:Property>" +
"" +
"<rdfs:Class rdf:about=\"&rdfs;Class\">" +
"  <rdfs:isDefinedBy rdf:resource=\"&rdfs;\"/>" +
"  <rdfs:label xml:lang=\"en\">Class</rdfs:label>" +
"  <rdfs:comment>The concept of Class</rdfs:comment>" +
"  <rdfs:subClassOf rdf:resource=\"&rdfs;Resource\"/>" +
"</rdfs:Class>" +
"" +
"<rdf:Property rdf:about=\"&rdfs;subClassOf\">" +
"  <rdfs:isDefinedBy rdf:resource=\"&rdfs;\"/>" +
"  <rdfs:label xml:lang=\"en\">subClassOf</rdfs:label>" +
"  <rdfs:comment>Indicates membership of a class</rdfs:comment>" +
"  <rdfs:range rdf:resource=\"&rdfs;Class\"/>" +
"  <rdfs:domain rdf:resource=\"&rdfs;Class\"/>" +
"</rdf:Property>" +
"" +
"<rdf:Property rdf:about=\"&rdfs;subPropertyOf\">" +
"  <rdfs:isDefinedBy rdf:resource=\"&rdfs;\"/>" +
"  <rdfs:label xml:lang=\"en\">subPropertyOf</rdfs:label>" +
"  <rdfs:comment>Indicates specialization of properties</rdfs:comment>" +
"  <rdfs:range rdf:resource=\"&rdf;Property\"/>" +
"  <rdfs:domain rdf:resource=\"&rdf;Property\"/>" +
"</rdf:Property>" +
"" +
"<rdfs:Class rdf:about=\"&rdf;Property\">" +
"  <rdfs:isDefinedBy rdf:resource=\"&rdf;\"/>" +
"  <rdfs:label xml:lang=\"en\">Property</rdfs:label>" +
"  <rdfs:comment>The concept of a property.</rdfs:comment>" +
"  <rdfs:subClassOf rdf:resource=\"&rdfs;Resource\"/>" +
"</rdfs:Class>" +
"" +
"<rdf:Property rdf:about=\"&rdfs;comment\">" +
"  <rdfs:isDefinedBy rdf:resource=\"&rdfs;\"/>" +
"  <rdfs:label xml:lang=\"en\">comment</rdfs:label>" +
"  <rdfs:comment>Use this for descriptions</rdfs:comment>" +
"  <rdfs:domain rdf:resource=\"&rdfs;Resource\"/>" +
"  <rdfs:range rdf:resource=\"&rdfs;Literal\"/>" +
"</rdf:Property>" +
"" +
"<rdf:Property rdf:about=\"&rdfs;label\">" +
"  <rdfs:isDefinedBy rdf:resource=\"&rdfs;\"/>" +
"  <rdfs:label xml:lang=\"en\">label</rdfs:label>" +
"  <rdfs:comment>Provides a human-readable version of a resource name.</rdfs:comment>" +
"  <rdfs:domain rdf:resource=\"&rdfs;Resource\"/>" +
"  <rdfs:range rdf:resource=\"&rdfs;Literal\"/>" +
"</rdf:Property>" +
"" +
"<rdf:Property rdf:about=\"&rdfs;domain\">" +
"  <rdfs:isDefinedBy rdf:resource=\"&rdfs;\"/>" +
"  <rdfs:label xml:lang=\"en\">domain</rdfs:label>" +
"  <rdfs:comment>A domain class for a property type</rdfs:comment>" +
" <rdfs:range rdf:resource=\"&rdfs;Class\"/>" +
"  <rdfs:domain rdf:resource=\"&rdf;Property\"/>" +
"</rdf:Property>" +
"" +
"<rdf:Property rdf:about=\"&rdfs;range\">" +
"  <rdfs:isDefinedBy rdf:resource=\"&rdfs;\"/>" +
"  <rdfs:label xml:lang=\"en\">range</rdfs:label>" +
"  <rdfs:comment>A range class for a property type</rdfs:comment>" +
"  <rdfs:range rdf:resource=\"&rdfs;Class\"/>" +
"  <rdfs:domain rdf:resource=\"&rdf;Property\"/>" +
"</rdf:Property>" +
"" +
"<rdf:Property rdf:about=\"&rdfs;seeAlso\">" +
"  <rdfs:isDefinedBy rdf:resource=\"&rdfs;\"/>" +
"  <rdfs:label xml:lang=\"en\">seeAlso</rdfs:label>" +
"  <rdfs:comment>A resource that provides information about the subject resource</rdfs:comment>" +
"  <rdfs:range rdf:resource=\"&rdfs;Resource\"/>" +
"  <rdfs:domain   rdf:resource=\"&rdfs;Resource\"/>" +
"</rdf:Property>" +
"" +
"<rdf:Property rdf:about=\"&rdfs;isDefinedBy\">" +
"  <rdfs:isDefinedBy rdf:resource=\"&rdfs;\"/>" +
"  <rdf:type resource=\"&rdf;Property\"/>" +
"  <rdfs:subPropertyOf rdf:resource=\"&rdfs;seeAlso\"/>" +
"  <rdfs:label xml:lang=\"en\">isDefinedBy</rdfs:label>" +
"  <rdfs:comment>Indicates the namespace of a resource</rdfs:comment>" +
"  <rdfs:range rdf:resource=\"&rdfs;Resource\"/>" +
"  <rdfs:domain rdf:resource=\"&rdfs;Resource\"/>" +
"</rdf:Property>" +
"" +
"<rdfs:Class rdf:about=\"&rdfs;Literal\">" +
"  <rdfs:isDefinedBy rdf:resource=\"&rdfs;\"/>" +
"  <rdfs:label xml:lang=\"en\">Literal</rdfs:label>" +
"  <rdfs:comment>This represents the set of atomic values, eg. textual strings.</rdfs:comment>" +
"</rdfs:Class>" +
"" +
"<rdfs:Class rdf:about=\"&rdf;Statement\">" +
"  <rdfs:isDefinedBy rdf:resource=\"&rdf;\"/>" +
"  <rdfs:label xml:lang=\"en\">Statement</rdfs:label>" +
"  <rdfs:subClassOf rdf:resource=\"&rdfs;Resource\"/>" +
"  <rdfs:comment>The class of RDF statements.</rdfs:comment>" +
"</rdfs:Class>" +
"" +
"<rdf:Property about=\"&rdf;subject\">" +
"  <rdfs:isDefinedBy rdf:resource=\"&rdf;\"/>" +
"  <rdfs:label xml:lang=\"en\">subject</rdfs:label>" +
"  <rdfs:comment>The subject of an RDF statement.</rdfs:comment>" +
"  <rdfs:domain rdf:resource=\"&rdf;Statement\"/>" +
"  <rdfs:range rdf:resource=\"&rdfs;Resource\"/>" +
"</rdf:Property>" +
"" +
"<rdf:Property about=\"&rdf;predicate\">" +
"  <rdfs:isDefinedBy rdf:resource=\"&rdf;\"/>" +
"  <rdfs:label xml:lang=\"en\">predicate</rdfs:label>" +
"  <rdfs:comment>the predicate of an RDF statement.</rdfs:comment>" +
"  <rdfs:domain rdf:resource=\"&rdf;Statement\"/>" +
"  <rdfs:range rdf:resource=\"&rdf;Property\"/>" +
"</rdf:Property>" +
"" +
"<rdf:Property about=\"&rdf;object\">" +
"  <rdfs:isDefinedBy rdf:resource=\"&rdf;\"/>" +
"  <rdfs:label xml:lang=\"en\">object</rdfs:label>" +
"  <rdfs:comment>The object of an RDF statement.</rdfs:comment>" +
"  <rdfs:domain rdf:resource=\"&rdf;Statement\"/>" +
"</rdf:Property>" +
"" +
"<rdfs:Class rdf:about=\"&rdfs;Container\">" +
"  <rdfs:isDefinedBy rdf:resource=\"&rdfs;\"/>" +
"  <rdfs:label xml:lang=\"en\">Container</rdfs:label>" +
"  <rdfs:subClassOf rdf:resource=\"&rdfs;Resource\"/>" +
"  <rdfs:comment>This represents the set Containers.</rdfs:comment>" +
"</rdfs:Class>" +
"" +
"<rdfs:Class rdf:about=\"&rdf;Bag\">" +
"  <rdfs:isDefinedBy rdf:resource=\"&rdf;\"/>" +
"  <rdfs:label xml:lang=\"en\">Bag</rdfs:label>" +
"  <rdfs:comment xml:lang=\"en\">An unordered collection.</rdfs:comment>" +
"  <rdfs:subClassOf rdf:resource=\"&rdfs;Container\"/>" +
"</rdfs:Class>" +
"" +
"<rdfs:Class rdf:about=\"&rdf;Seq\">" +
"  <rdfs:isDefinedBy rdf:resource=\"&rdf;\"/>" +
"  <rdfs:label xml:lang=\"en\">Seq</rdfs:label>" +
"  <rdfs:comment xml:lang=\"en\">An ordered collection.</rdfs:comment>" +
"  <rdfs:subClassOf rdf:resource=\"&rdfs;Container\"/>" +
"</rdfs:Class>" +
"" +
"<rdfs:Class rdf:about=\"&rdf;Alt\">" +
"  <rdfs:isDefinedBy rdf:resource=\"&rdf;\"/>" +
"  <rdfs:label xml:lang=\"en\">Alt</rdfs:label>" +
"  <rdfs:comment xml:lang=\"en\">A collection of alternatives.</rdfs:comment>" +
"  <rdfs:subClassOf rdf:resource=\"&rdfs;Container\"/>" +
"</rdfs:Class>" +
"" +
"<rdfs:Class rdf:about=\"&rdfs;ContainerMembershipProperty\">" +
"  <rdfs:isDefinedBy rdf:resource=\"&rdfs;\"/>" +
"  <rdfs:label xml:lang=\"en\">ContainerMembershipProperty</rdfs:label>" +
"  <rdfs:comment>The container membership properties, rdf:1, rdf:2, ..., all of which are sub-properties of 'member'.</rdfs:comment>" +
"  <rdfs:subClassOf rdf:resource=\"&rdf;Property\"/>" +
"</rdfs:Class>" +
"" +
"<rdf:Property rdf:about=\"&rdfs;member\">" +
"  <rdfs:isDefinedBy rdf:resource=\"&rdfs;\"/>" +
"  <rdfs:label xml:lang=\"en\">member</rdfs:label>" +
"  <rdfs:comment>a member of a container</rdfs:comment>" +
"  <rdfs:domain rdf:resource=\"&rdfs;Container\"/>" +
"</rdf:Property>" +
"" +
"<rdf:Property rdf:about=\"&rdf;value\">" +
"  <rdfs:isDefinedBy rdf:resource=\"&rdf;\"/>" +
"  <rdfs:label xml:lang=\"en\">value</rdfs:label>" +
"  <rdfs:comment>Identifies the principal value (usually a string) of a property when the property value is a structured resource</rdfs:comment>" +
"  <rdfs:domain rdf:resource=\"&rdfs;Resource\"/>" +
"</rdf:Property>" +
"" +
"<!-- the following are new additions, Nov 2002 -->" +
"" +
"<rdfs:Class rdf:about=\"&rdf;List\">" +
"  <rdfs:isDefinedBy rdf:resource=\"&rdf;\"/>" +
"  <rdfs:label xml:lang=\"en\">List</rdfs:label>" +
"  <rdfs:comment xml:lang=\"en\">The class of RDF Lists</rdfs:comment>" +
"</rdfs:Class>" +
"" +
"<rdf:List rdf:about=\"&rdf;nil\">" +
"  <rdfs:isDefinedBy rdf:resource=\"&rdf;\"/>" +
"  <rdfs:label xml:lang=\"en\">nil</rdfs:label>" +
"  <rdfs:comment xml:lang=\"en\">The empty list, with no items in it. If the rest of a list is nil then the list has no more items in it.</rdfs:comment>" +
"</rdf:List>" +
"" +
"<rdf:Property rdf:about=\"&rdf;first\">" +
"  <rdfs:isDefinedBy rdf:resource=\"&rdf;\"/>" +
"  <rdfs:label xml:lang=\"en\">first</rdfs:label>" +
"  <rdfs:comment xml:lang=\"en\">The first item in an RDF list. Also often called the head.</rdfs:comment>" +
"  <rdfs:domain rdf:resource=\"&rdf;List\"/>" +
"</rdf:Property>" +
"" +
"<rdf:Property rdf:about=\"&rdf;rest\">" +
"  <rdfs:isDefinedBy rdf:resource=\"&rdf;\"/>" +
"  <rdfs:label xml:lang=\"en\">rest</rdfs:label>" +
"  <rdfs:comment xml:lang=\"en\">The rest of an RDF list after the first item. Also often called the tail.</rdfs:comment>" +
"  <rdfs:domain rdf:resource=\"&rdf;List\"/>" +
"  <rdfs:range rdf:resource=\"&rdf;List\"/>" +
"</rdf:Property>" +
"" +
"<rdfs:Class rdf:about=\"&rdfs;Datatype\">" +
"  <rdfs:isDefinedBy rdf:resource=\"&rdfs;\"/>" +
"  <rdfs:label xml:lang=\"en\">Datatype</rdfs:label>" +
"  <rdfs:comment xml:lang=\"en\">The class of datatypes.</rdfs:comment>" +
"</rdfs:Class>" +
"	" +
"<rdfs:Datatype rdf:about=\"&rdf;XMLLiteral\">" +
"  <rdfs:isDefinedBy rdf:resource=\"&rdf;\"/>" +
"  <rdfs:label xml:lang=\"en\">XMLLiteral</rdfs:label>" +
"  <rdfs:comment>The class of XML literals.</rdfs:comment>" +
"</rdfs:Datatype>" +
"" +
"" +
"<rdf:Description rdf:about=\"&rdfs;\">" +
"  <rdfs:seeAlso rdf:resource=\"http://www.w3.org/2000/01/rdf-schema-more\"/>" +
"</rdf:Description>" +
"" +
"</rdf:RDF>";

}
