/* This software was developed within the context of the project Metaphor for Science
   Museums (Mesmuses) in the framework of the Information Society Technology
   Programme, part of the Fifth Research And Technological Development
   Framework Programme of the European Community, under the Consortium
   Agreement dated <June 30, 2001>, between INRIA, Finsiel Spa, IMSS,
   Valoris , CSI, ICS-FORTH, ENSTB, EDW International.
*/

// rdf.java
/*
 *  CHANGE LOG:
 *  Each entry starts with a date, who did the changed and what has been done.
 *  Separated by ':'.
 *
 *  14.11.2002 : Karsten Tolle : Added the XMLRep to the vocabulary.
 *
 *  05.12.2002 : Karsten Tolle : Added rdf:List, rdf:nil, rdf:rest and rdf:first
 *                               and a corresponding XMLRep.
 *
 *  29.01.2003 : Karsten Tolle : The class XMLLiteral has been moved from the rdfs
 *                               namespace to the rdf namespace. See RDF/XML Syntax
 *                               Specification (Revised) 23. Januar 2003 for more
 *                               information.
 */

package gr.forth.ics.vrp.corevrp.vocabulary;

import java.util.*;

/**
 *  rdf.java - Containing the parameters for the RDF namespaces.
 *
 * @author Karsten Tolle & Sofia Alexaki
 * @version 2.5  (30 Januar 2003)
 */
public class rdf  {




	/** The RDF namespace URL: "http://www.w3.org/1999/02/22-rdf-syntax-ns#"*/
    	final static public String NS = "http://www.w3.org/1999/02/22-rdf-syntax-ns#";
        final static public String NS0 = "http://www.w3.org/1999/02/22-rdf-syntax-ns";

 	// The old RDF namespace used in the 500 files for testing the parser.
 	//final static public String NS = new String("http://w3.org/TR/1999/PR-rdf-syntax-19990105#");



	/** Element from the RDF namespace: NS+"Statement"*/
	final static public String Statement = NS+"Statement";
	/** Element from the RDF namespace: NS+"Property"*/
	final static public String Property = NS+"Property";
	/** Element from the RDF namespace: NS+"Bag"*/
	final static public String Bag = NS+"Bag";
	/** Element from the RDF namespace: NS+"Seq"*/
	final static public String Seq = NS+"Seq";
	/** Element from the RDF namespace: NS+"Alt"*/
	final static public String Alt = NS+"Alt";
	/** Element from the RDF namespace: NS+"predicate"*/
	final static public String predicate = NS+"predicate";
	/** Element from the RDF namespace: NS+"subject"*/
	final static public String subject = NS+"subject";
	/** Element from the RDF namespace: NS+"object"*/
	final static public String object = NS+"object";
	/** Element from the RDF namespace: NS+"type"*/
	final static public String type = NS+"type";
	/** Element from the RDF namespace: NS+"value"*/
	final static public String value = NS+"value";
	// Attributes belonging to the NS
	/** Attribute from the RDF namespace: NS+"ID"*/
	final static public String ID = NS+"ID";
	/** Attribute from the RDF namespace: NS+"bagID"*/
	final static public String bagID = NS+"bagID";
	/** Attribute from the RDF namespace: NS+"about"*/
	final static public String about = NS+"about";
	/** Attribute from the RDF namespace: NS+"aboutEach"*/
        // removed by RDF WG
        // final static public String aboutEach = NS+"aboutEach";
	/** Attribute from the RDF namespace: NS+"aboutEachPrefix"*/
        // removed by RDF WG
	// final static public String aboutEachPrefix = NS+"aboutEachPrefix";
	/** Attribute from the RDF namespace: NS+"Description"*/
	final static public String Description = NS+"Description";
	/** Attribute from the RDF namespace: NS+"resource"*/
	final static public String resource = NS+"resource";

	/** Element from the RDF namespace: NS+"_" (will be used to test the start of rdf:_n | n integer) */
	final static public String msp = NS+"_"; // for membership properties _1, _2, _3, ...

	/** List property for containers, will be translated in rdf:_nnn properties by the parser. */
	final static public String li = NS+"li";

        final static public String List = NS+"List";
        final static public String first = NS+"first";
        final static public String rest = NS+"rest";
        final static public String nil = NS+"nil";
        final static public String datatype = NS+"datatype";
        final static public String nodeID = NS+"nodeID";
        final static public String XMLLiteral = NS+"XMLLiteral";


	/** The set of Classes from the RDF namespace. */
	static public ArrayList Classes = init_Classes();
	/** The set of Properties from the RDF namespace. */
	static public ArrayList Properties = init_Properties();


	/**
         * The classes of RDF namespace.
	 */
	private static ArrayList init_Classes() {
		ArrayList AL = new ArrayList();
		AL.add(Bag);
		AL.add(Seq);
		AL.add(Alt);
		AL.add(Statement);
		AL.add(Property);
                AL.add(List);
                AL.add(XMLLiteral);
		return AL;
	}

	/**
         * The properties of RDF namespace. msp (Mebership property is not entered her
	 * because we can not enter it for each integer.)
	 */
	private static ArrayList init_Properties() {
		ArrayList AL = new ArrayList();
		AL.add(object);
		AL.add(subject);
		AL.add(predicate);
		AL.add(value);
		AL.add(type);
		AL.add(li);
                AL.add(first);
                AL.add(rest);
		return AL;
	}

        final static public String XMLRep = "<?xml version=\"1.0\"?>" +
 "<!DOCTYPE rdf:RDF [" +
 "   <!ENTITY rdf \"http://www.w3.org/1999/02/22-rdf-syntax-ns#\">  " +
 "   <!ENTITY rdfs \"http://www.w3.org/2000/01/rdf-schema#\">" +
 "]>  " +
 "<rdf:RDF" +
  "   xml:base=\"http://139.91.183.30:9090/RDF/VRP/Examples/22-rdf-syntax-ns.rdf\"" +
 "  xmlns=\"&rdf;\"" +
 "  xmlns:rdf=\"&rdf;\"" +
 "  xmlns:rdfs=\"&rdfs;\">" +
 "<!--Universal RDF namespace written by Karsten Tolle, 29.01.2003.-->" +
 "<!--This is the RDF Schema for the RDF data model as described in the" +
 "  Resource Description Framework (RDF) Model and Syntax Specification" +
 "  http://www.w3.org/TR/REC-rdf-syntax-->" +
 "" +
 "<rdfs:Class rdf:about=\"&rdf;Statement\"" +
 "  rdfs:comment=\"A triple consisting of a predicate, a subject, and an object.\" />" +
 "" +
 "<rdfs:Class rdf:about=\"&rdf;Property\"" +
 "  rdfs:comment=\"A name of a property, defining specific meaning for the property\" />" +
 "" +
 "<rdfs:Class rdf:about=\"&rdf;Bag\"" +
 "  rdfs:comment=\"An unordered collection\" />" +
 "" +
 "<rdfs:Class rdf:about=\"&rdf;Seq\"" +
 "  rdfs:comment=\"An ordered collection\" />" +
 "" +
 "<rdfs:Class rdf:about=\"&rdf;Alt\"" +
 "  rdfs:comment=\"A collection of alternatives\" />" +
 "" +
 "<rdf:Property rdf:about=\"&rdf;predicate\"" +
 "  rdfs:comment=\"Identifies the property used in a statement when representing the statement in reified form\">" +
 "  <rdfs:domain rdf:resource=\"&rdf;Statement\" />" +
 "  <rdfs:range rdf:resource=\"&rdf;Property\" />" +
 "</rdf:Property>" +
 "" +
 "<rdf:Property rdf:about=\"&rdf;subject\"" +
 "  rdfs:comment=\"Identifies the resource that a statement is describing when representing the statement in reified form\">" +
 "  <rdfs:domain rdf:resource=\"&rdf;Statement\" />" +
 "</rdf:Property>" +
 "" +
 "<rdf:Property rdf:about=\"&rdf;object\"" +
 "  rdfs:comment=\"Identifies the object of a statement when representing the statement in reified form\" />" +
 "" +
 "<rdf:Property rdf:about=\"&rdf;type\"" +
 "  rdfs:comment=\"Identifies the Class of a resource\" />" +
 "" +
 "<rdf:Property rdf:about=\"&rdf;value\"" +
 "  rdfs:comment=\"Identifies the principal value (usually a string) of a property when the property value is a structured resource\" />" +
 "" +
 "<rdfs:Class rdf:about=\"&rdf;List\"" +
 "  rdfs:comment=\"The class of RDF Lists\" />" +
 "" +
 "<rdf:List rdf:about=\"&rdf;nil\"" +
 "  rdfs:comment=\"The empty list, with no items in it. If the rest of a list is nil then the list has no more items in it.\" />" +
 "" +
 "<rdf:Property rdf:about=\"&rdf;first\"" +
 "  rdfs:comment=\"The first item in an RDF list. Also often called the head.\" />" +
 "" +
 "<rdf:Property rdf:about=\"&rdf;rest\"" +
 "  rdfs:comment=\"The rest of an RDF list after the first item. Also often called the tail.\" />" +
 "" +
 "<rdfs:Class rdf:about=\"&rdf;XMLLiteral\">" +
"  <rdfs:comment>The class of XML literals.</rdfs:comment>" +
"</rdfs:Class>" +
"" +
 "</rdf:RDF>";



}
