/* This software was developed within the context of the project Metaphor for Science
	Museums (Mesmuses) in the framework of the Information Society Technology
	Programme, part of the Fifth Research And Technological Development
	Framework Programme of the European Community, under the Consortium
	Agreement dated <June 30, 2001>, between INRIA, Finsiel Spa, IMSS,
	Valoris , CSI, ICS-FORTH, ENSTB, EDW International.
*/
/**
 *  CHANGE LOG:
 *  Each entry starts with a date, who did the changed and what has been done.
 *  Separated by ':'.
 *
 *  28.01.2003 : Sofia Alexaki : The address of the namespace where XML Schema
 *  datatypes are defined is changed
 *
 */


package gr.forth.ics.vrp.corevrp.vocabulary;

import java.util.*;

/**
 *  XMLSchema_DT.java - Containing the parameters for the XML Datatypes.
 *
 * @author Karsten Tolle & Sofia Alexaki
 * @version 2.5  (30 Januar 2003)
 */
public class XMLSchema_DT {


  /** Address of the namespace where XML Schema datatypes are defined */
  final static public String NS = "http://www.w3.org/2001/XMLSchema#";
  /** string XML Schema datatype */
	final static public String stringDT =  NS +"string";
  /** integer XML Schema datatype */
	final static public String integerDT =  NS +"integer";
  /** float XML Schema datatype */
	final static public String floatDT =  NS +"float";
  /** boolean XML Schema datatype */
	final static public String booleanDT =  NS +"boolean";
  /** dateTime XML Schema datatype */
	final static public String dateTimeDT =  NS +"dateTime";

	/** dateTime XML Schema datatype */
	final static public String decimalDT =  NS +"decimal";
	/** dateTime XML Schema datatype */
	final static public String doubleDT =  NS +"double";
	/** dateTime XML Schema datatype */
	final static public String durationDT =  NS +"duration";
	/** dateTime XML Schema datatype */
	final static public String timeDT =  NS +"time";
	/** dateTime XML Schema datatype */
	final static public String dateDT =  NS +"date";
	/** dateTime XML Schema datatype */
	final static public String gYearMonthDT =  NS +"gYearMonth";
	/** gYear XML Schema datatype */
	final static public String gYearDT =  NS +"gYear";
	/** dateTime XML Schema datatype */
	final static public String gMonthDayDT =  NS +"gMonthDay";
	/** dateTime XML Schema datatype */
	final static public String gDayDT =  NS +"gDay";
	/** dateTime XML Schema datatype */
	final static public String gMonthDT =  NS +"gMonth";
	/** hexBinary XML Schema datatype */
	final static public String hexBinaryDT =  NS +"hexBinary";
	/** base64Binary XML Schema datatype */
	final static public String base64BinaryDT =  NS +"base64Binary";
	/** anyURI XML Schema datatype */
	final static public String anyURIDT =  NS +"anyURI";
	/** QName XML Schema datatype */
	final static public String QNameDT =  NS +"QName";
	/** NOTATION XML Schema datatype */
	final static public String NOTATIONDT =  NS +"NOTATION";
	/** normalizedString XML Schema datatype */
	final static public String normalizedStringDT =  NS +"normalizedString";
	/** token XML Schema datatype */
	final static public String tokenDT =  NS +"token";
	/** language XML Schema datatype */
	final static public String languageDT =  NS +"language";
	/** NMTOKEN XML Schema datatype */
	final static public String NMTOKENDT =  NS +"NMTOKEN";
	/** NMTOKENS XML Schema datatype */
	final static public String NMTOKENSDT =  NS + "NMTOKENS";
	/** Name XML Schema datatype */
	final static public String NameDT =  NS +"Name";
	/** NCName XML Schema datatype */
	final static public String NCNameDT =  NS +"NCName";
	/** ID XML Schema datatype */
	final static public String IDDT =  NS +"ID";
	/** IDREF XML Schema datatype */
	final static public String IDREFDT =  NS +"IDREF";
	/** IDREFS  XML Schema datatype */
	final static public String IDREFSDT =  NS +"IDREFS";
	/** ENTITY XML Schema datatype */
	final static public String ENTITYDT =  NS +"ENTITY";
	/** ENTITIES XML Schema datatype */
	final static public String ENTITIESDT =  NS +"ENTITIES";
	/** nonPositiveInteger XML Schema datatype */
	final static public String nonPositiveIntegerDT =  NS +"nonPositiveInteger";
	/** negativeInteger XML Schema datatype */
	final static public String negativeIntegerDT =  NS +"negativeInteger";
	/** long XML Schema datatype */
	final static public String longDT =  NS +"long";
	/** int XML Schema datatype */
	final static public String intDT =  NS +"int";
	/** short XML Schema datatype */
	final static public String shortDT =  NS +"short";
	/** byte XML Schema datatype */
	final static public String byteDT =  NS +"byte";
	/** nonNegativeInteger XML Schema datatype */
	final static public String nonNegativeIntegerDT =  NS +"nonNegativeInteger";
	/** unsignedLong XML Schema datatype */
	final static public String unsignedLongDT =  NS +"unsignedLong";
	/** unsignedInt XML Schema datatype */
	final static public String unsignedIntDT =  NS +"unsignedInt";
	/** unsignedShort XML Schema datatype */
	final static public String unsignedShortDT =  NS +"unsignedShort";
	/** unsignedByte XML Schema datatype */
	final static public String unsignedByteDT =  NS +"unsignedByte";
	/** positiveInteger XML Schema datatype */
	final static public String positiveIntegerDT =  NS +"positiveInteger";


	/** The subset of XML Schema Datatypes supported by VRP. */
	static public ArrayList XMLSchemaDatatypes = init_XMLS_Types();

	/**
	 * This arraylist contains the XML Schema datatypes.
	 */
	private static ArrayList init_XMLS_Types() {
		ArrayList AL = new ArrayList();
		AL.add(stringDT);
		AL.add(integerDT);
		AL.add(floatDT);
		AL.add(booleanDT);
		AL.add(dateTimeDT);

		AL.add(decimalDT);
		AL.add(doubleDT);
		AL.add(durationDT);
		AL.add(timeDT);
		AL.add(dateDT);
		AL.add(gYearMonthDT);
		AL.add(gYearDT);
		AL.add(gMonthDayDT);
		AL.add(gDayDT);
		AL.add(gMonthDT);
		AL.add(hexBinaryDT);
		AL.add(base64BinaryDT);
		AL.add(anyURIDT);
		AL.add(QNameDT);
		AL.add(NOTATIONDT);
		AL.add(normalizedStringDT);
		AL.add(tokenDT);
		AL.add(languageDT);
		AL.add(NMTOKENDT);
		AL.add(NMTOKENSDT);
		AL.add(NameDT);
		AL.add(NCNameDT);
		AL.add(IDDT);
		AL.add(IDREFDT);
		AL.add(IDREFSDT);
		AL.add(ENTITYDT);
		AL.add(ENTITIESDT);
		AL.add(nonPositiveIntegerDT);
		AL.add(negativeIntegerDT);
		AL.add(longDT);
		AL.add(intDT);
		AL.add(shortDT);
   	AL.add(byteDT);
		AL.add(nonNegativeIntegerDT);
		AL.add(unsignedLongDT);
		AL.add(unsignedIntDT);
		AL.add(unsignedShortDT);
		AL.add(unsignedByteDT);
		AL.add(positiveIntegerDT);

	  return AL;
	}

}
