/* This software was developed within the context of the project Metaphor for Science
   Museums (Mesmuses) in the framework of the Information Society Technology
   Programme, part of the Fifth Research And Technological Development
   Framework Programme of the European Community, under the Consortium
   Agreement dated <June 30, 2001>, between INRIA, Finsiel Spa, IMSS,
   Valoris , CSI, ICS-FORTH, ENSTB, EDW International.
*/

// UpCall.java

/*
 *  CHANGE LOG:
 *  Each entry starts with a date, who did the changed and what has been done.
 *  Separated by ':'.
 *
 *  28.05.2002 : Karsten Tolle : Changed to enable reification.
 *  28.01.2003 : Karsten Tolle : Fixed bug in getRes_Lit.
 */

package gr.forth.ics.vrp.corevrp.parser;

import gr.forth.ics.vrp.corevrp.model.*;

/**
 * UpCall.java - A class to transport the information to wrapped elements.
 *
 * @author Karsten Tolle
 * @version 07. Apr. 2000
 */
public class UpCall {
	/** Create a new UpCall (for the parser actions). During reducing
	 * Property_Ele we do not know the subject of the triples we want to
	 * create. Elements of this class save the information we have so fare.
	 */
	UpCall(Object pred, Object obj, boolean reify, String statement_id) {
		this.predicate = pred;
		this.object = obj;
                this.reification = reify;
                this.statement = statement_id;
	}

        UpCall(Object pred, Object obj) {
		this.predicate = pred;
		this.object = obj;
	}

	// Variables
	/** The predicate of the triple we want to create later.*/
	private Object predicate;
	/** The object of the triple we want to create later.*/
	private Object object;
        /** Boolean saying if the statement needs to be reifyed. */
        private boolean reification = false;
        /** The ID of the statement we want to reify. */
        private String statement = "";

	// Getting methodes

	/**
	 * Get the predicate of the UpCall.
	 */
	public String getPredicate() {
		// changed 07. Apr. 2000 by Karsten Tolle
		if (predicate == null) return null;
		return predicate.toString();
	}

	/**
	 * Get the object of the UpCall.
	 */
	public Object getObject() {
		return object;
	}

	/**
	 * In case the object is a Literal it returns false else true.
	 */
	public boolean getRes_Lit() {
		if (object instanceof Literal) return false;
                return true;
	}

        /**
	 * In case the statement needs to be reified return true else false.
	 */
	public boolean getReification() {
		return reification;
	}

        public String getStatement() {
                return statement;
        }

}
