/* The following code was generated by JFlex 1.3.5 on 6/25/02 6:15 PM */

/**
 * lexer_Simple.jflex - A lexical analyser for RDF.
 *
 *  (simple lexer version)
 *  In this version the RDF Description must not be included into HTML or XML.
 *  But the RDF Description must be wrapped in a RDF Tag !!!!!
 *
 * @author Karsten Tolle
 * @version 2.5  (30 Januar 2003)

 */

// Part one: user code

package gr.forth.ics.vrp.corevrp.parser;

import java_cup.runtime.*; // convenience, but not necessary
import java.util.*; // for the Stack
import gr.forth.ics.vrp.corevrp.*;
import gr.forth.ics.vrp.corevrp.vocabulary.*;


/**
 * This class is a scanner generated by
 * <a href="http://www.jflex.de/">JFlex</a> 1.3.5
 * on 6/25/02 6:15 PM from the specification file
 * <tt>file:/D:/tmp_local_users/alexaki/RDF_VRP/src/gr/forth/ics/vrp/corevrp/Cup_JFlex/lexer_simple.jflex</tt>
 */
public class Lexer_Simple implements java_cup.runtime.Scanner {

  /** This character denotes the end of file */
  final public static int YYEOF = -1;

  /** initial size of the lookahead buffer */
  final private static int YY_BUFFERSIZE = 16384;

  /** lexical states */
  final public static int QName_Begin = 1;
  final public static int RDF_QName_End = 5;
  final public static int RDF_Attribute = 6;
  final public static int RDF_QName_Begin = 4;
  final public static int YYINITIAL = 0;
  final public static int RDF_Attribute_IDSYMBOL = 7;
  final public static int RDF_End = 8;
  final public static int QName_End = 2;
  final public static int RDF_YYINITIAL = 3;

  /**
   * Translates characters to character classes
   */
  final private static String yycmap_packed =
    "\11\0\1\1\1\1\2\0\1\1\22\0\1\1\1\6\1\2\1\17"+
    "\2\0\1\3\1\4\5\0\1\7\1\24\1\52\12\20\1\30\1\21"+
    "\1\5\1\11\1\10\2\0\3\22\1\26\1\22\1\27\2\12\1\14"+
    "\2\12\1\42\5\12\1\25\1\12\1\50\3\12\1\16\2\12\4\0"+
    "\1\23\1\0\1\40\1\37\1\36\1\22\1\32\1\22\1\41\1\12"+
    "\1\13\2\12\1\44\1\45\1\46\1\34\1\47\1\12\1\31\1\33"+
    "\1\43\1\35\2\12\1\15\1\51\1\12\74\0\1\24\10\0\27\23"+
    "\1\0\37\23\1\0\72\23\2\0\13\23\2\0\10\23\1\0\65\23"+
    "\1\0\104\23\11\0\44\23\3\0\2\23\4\0\36\23\70\0\131\23"+
    "\22\0\7\23\16\0\2\24\56\0\106\24\32\0\2\24\44\0\1\23"+
    "\1\24\3\23\1\0\1\23\1\0\24\23\1\0\54\23\1\0\7\23"+
    "\3\0\1\23\1\0\1\23\1\0\1\23\1\0\1\23\1\0\22\23"+
    "\15\0\14\23\1\0\102\23\1\0\14\23\1\0\44\23\1\0\4\24"+
    "\11\0\65\23\2\0\2\23\2\0\2\23\3\0\34\23\2\0\10\23"+
    "\2\0\2\23\67\0\46\23\2\0\1\23\7\0\46\23\12\0\21\24"+
    "\1\0\27\24\1\0\3\24\1\0\1\24\1\0\2\24\1\0\1\24"+
    "\13\0\33\23\5\0\3\23\56\0\32\23\5\0\1\24\12\23\10\24"+
    "\15\0\12\24\6\0\1\24\107\23\2\0\5\23\1\0\17\23\1\0"+
    "\4\23\1\0\1\23\17\24\2\23\2\24\1\0\4\24\2\0\12\24"+
    "\u0207\0\3\24\1\0\65\23\2\0\1\24\1\23\20\24\3\0\4\24"+
    "\3\0\12\23\2\24\2\0\12\24\21\0\3\24\1\0\10\23\2\0"+
    "\2\23\2\0\26\23\1\0\7\23\1\0\1\23\3\0\4\23\2\0"+
    "\1\24\1\0\7\24\2\0\2\24\2\0\3\24\11\0\1\24\4\0"+
    "\2\23\1\0\3\23\2\24\2\0\12\24\2\23\20\0\1\24\2\0"+
    "\6\23\4\0\2\23\2\0\26\23\1\0\7\23\1\0\2\23\1\0"+
    "\2\23\1\0\2\23\2\0\1\24\1\0\5\24\4\0\2\24\2\0"+
    "\3\24\13\0\4\23\1\0\1\23\7\0\12\24\2\24\3\23\14\0"+
    "\3\24\1\0\7\23\1\0\1\23\1\0\3\23\1\0\26\23\1\0"+
    "\7\23\1\0\2\23\1\0\5\23\2\0\1\24\1\23\10\24\1\0"+
    "\3\24\1\0\3\24\22\0\1\23\5\0\12\24\21\0\3\24\1\0"+
    "\10\23\2\0\2\23\2\0\26\23\1\0\7\23\1\0\2\23\2\0"+
    "\4\23\2\0\1\24\1\23\6\24\3\0\2\24\2\0\3\24\10\0"+
    "\2\24\4\0\2\23\1\0\3\23\4\0\12\24\22\0\2\24\1\0"+
    "\6\23\3\0\3\23\1\0\4\23\3\0\2\23\1\0\1\23\1\0"+
    "\2\23\3\0\2\23\3\0\3\23\3\0\10\23\1\0\3\23\4\0"+
    "\5\24\3\0\3\24\1\0\4\24\11\0\1\24\17\0\11\24\21\0"+
    "\3\24\1\0\10\23\1\0\3\23\1\0\27\23\1\0\12\23\1\0"+
    "\5\23\4\0\7\24\1\0\3\24\1\0\4\24\7\0\2\24\11\0"+
    "\2\23\4\0\12\24\22\0\2\24\1\0\10\23\1\0\3\23\1\0"+
    "\27\23\1\0\12\23\1\0\5\23\4\0\7\24\1\0\3\24\1\0"+
    "\4\24\7\0\2\24\7\0\1\23\1\0\2\23\4\0\12\24\22\0"+
    "\2\24\1\0\10\23\1\0\3\23\1\0\27\23\1\0\20\23\4\0"+
    "\6\24\2\0\3\24\1\0\4\24\11\0\1\24\10\0\2\23\4\0"+
    "\12\24\221\0\56\23\1\0\1\23\1\24\2\23\7\24\5\0\6\23"+
    "\1\24\10\24\1\0\12\24\47\0\2\23\1\0\1\23\2\0\2\23"+
    "\1\0\1\23\2\0\1\23\6\0\4\23\1\0\7\23\1\0\3\23"+
    "\1\0\1\23\1\0\1\23\2\0\2\23\1\0\2\23\1\0\1\23"+
    "\1\24\2\23\6\24\1\0\2\24\1\23\2\0\5\23\1\0\1\24"+
    "\1\0\6\24\2\0\12\24\76\0\2\24\6\0\12\24\13\0\1\24"+
    "\1\0\1\24\1\0\1\24\4\0\2\24\10\23\1\0\41\23\7\0"+
    "\24\24\1\0\6\24\4\0\6\24\1\0\1\24\1\0\25\24\3\0"+
    "\7\24\1\0\1\24\346\0\46\23\12\0\47\23\11\0\1\23\1\0"+
    "\2\23\1\0\3\23\1\0\1\23\1\0\2\23\1\0\5\23\51\0"+
    "\1\23\1\0\1\23\1\0\1\23\13\0\1\23\1\0\1\23\1\0"+
    "\1\23\3\0\2\23\3\0\1\23\5\0\3\23\1\0\1\23\1\0"+
    "\1\23\1\0\1\23\1\0\1\23\3\0\2\23\3\0\2\23\1\0"+
    "\1\23\50\0\1\23\11\0\1\23\2\0\1\23\2\0\2\23\7\0"+
    "\2\23\1\0\1\23\1\0\7\23\50\0\1\23\4\0\1\23\10\0"+
    "\1\23\u0c06\0\234\23\4\0\132\23\6\0\26\23\2\0\6\23\2\0"+
    "\46\23\2\0\6\23\2\0\10\23\1\0\1\23\1\0\1\23\1\0"+
    "\1\23\1\0\37\23\2\0\65\23\1\0\7\23\1\0\1\23\3\0"+
    "\3\23\1\0\7\23\3\0\4\23\2\0\6\23\4\0\15\23\5\0"+
    "\3\23\1\0\7\23\323\0\15\24\4\0\1\24\104\0\1\23\3\0"+
    "\2\23\2\0\1\23\121\0\3\23\u0e82\0\1\24\1\0\1\23\31\0"+
    "\11\23\6\24\1\0\5\24\13\0\124\23\4\0\2\24\2\0\2\24"+
    "\2\0\132\23\1\0\3\24\6\0\50\23\u1cd3\0\u51a6\23\u0c5a\0\u2ba4\23"+
    "\u285c\0";

  /**
   * Translates characters to character classes
   */
  final private static char [] yycmap = yy_unpack_cmap(yycmap_packed);

  /**
   * Translates a state to a row index in the transition table
   */
  final private static int yy_rowMap [] = {
        0,    43,    86,   129,   172,   215,   258,   301,   344,   387,
      430,   473,   516,   559,   559,   602,   645,   688,   731,   774,
      817,   559,   860,   903,   946,   989,  1032,  1075,   559,  1118,
     1161,  1204,  1247,  1290,  1333,  1376,  1419,  1462,  1505,   559,
      473,  1548,  1591,  1634,  1677,  1720,  1763,  1806,  1849,   774,
     1892,  1935,   559,  1978,  2021,  2064,  1032,   559,  2107,  1075,
     2150,  2193,  2236,  2279,  2322,  2365,   559,  1419,  2408,  2451,
     2494,  2537,  2580,  2623,  2666,  2709,  2752,  2795,  2838,  2881,
     2924,  2967,  3010,   903,  3053,  3096,  3139,  3182,  3225,  3268,
     3311,  3354,  3397,  3440,  3483,  3526,   559,  3569,  3612,  3655,
     1677,  3698,  1763,  3741,  3784,  3827,  3870,  3913,  3956,  3999,
     4042,  4085,  4128,  4171,  4214,  4257,  4300,  4343,  4386,  2967,
     4429,  4472,  4515,  4558,  4601,  4644,  4687,  1161,  4730,  4773,
      559,   559,  4816,  4859,  4902,  4945,  4988,  5031,   559,  5074,
     3225,  5117,  5160,  5203,  5246,  5289,  5332,  5375,  1161,  5418,
     5461,  5504,  5547,  5590,  5633,  3225,  5676,  5719,  5762,  5805,
     5848,  5891,  5934,  5977,  6020,  6063,  6106,  6149,  6192,  6235,
     6278,  6321,  6364,  6407,  6450,   559,  6493,  6536,  6579,  6622,
     6665,  6708,  6751,  6794,  6837,  6880,  6923,  6966,  7009,  7052,
     7095,  7138,  7181,  7224,  7267,  7310,  7353,   559,  7396,   559
  };

  /**
   * The packed transition table of the DFA (part 0)
   */
  final private static String yy_packed0 =
    "\1\12\1\13\1\12\1\14\1\12\1\15\2\12\1\16"+
    "\42\12\5\17\1\20\57\17\5\21\3\17\2\21\1\17"+
    "\3\21\1\17\21\21\1\17\1\22\1\23\1\22\1\24"+
    "\1\22\1\25\2\22\1\26\42\22\12\17\5\27\3\17"+
    "\2\27\1\17\3\27\1\17\21\27\13\17\5\30\3\17"+
    "\2\30\1\17\1\31\2\30\1\17\21\30\2\17\1\32"+
    "\1\33\1\17\1\34\3\17\1\35\1\36\3\37\1\40"+
    "\1\37\3\17\2\37\1\17\3\37\1\17\1\41\5\37"+
    "\1\42\7\37\1\43\2\37\1\44\1\17\1\45\1\46"+
    "\1\17\1\47\4\17\1\36\51\17\1\50\42\17\3\12"+
    "\1\51\1\12\1\0\2\12\1\0\43\12\1\13\1\12"+
    "\1\51\1\12\1\0\2\12\1\0\42\12\12\0\5\52"+
    "\1\53\2\0\2\52\1\0\3\52\1\0\21\52\7\0"+
    "\1\54\3\0\5\55\3\0\2\55\1\0\1\56\2\55"+
    "\1\0\21\55\1\16\65\0\5\57\3\0\2\57\1\0"+
    "\1\60\2\57\1\0\21\57\10\0\1\21\2\0\5\21"+
    "\1\0\1\21\1\0\6\21\1\61\21\21\1\0\3\22"+
    "\1\62\1\22\1\0\2\22\1\0\43\22\1\23\1\22"+
    "\1\62\1\22\1\0\2\22\1\0\42\22\12\0\5\63"+
    "\1\64\2\0\2\63\1\0\3\63\1\0\21\63\7\0"+
    "\1\54\43\0\1\65\7\0\1\27\2\0\5\27\1\0"+
    "\1\27\1\0\6\27\1\66\21\27\10\0\1\30\2\0"+
    "\5\30\1\0\1\30\1\0\6\30\1\67\21\30\10\0"+
    "\1\30\2\0\5\30\1\0\1\30\1\0\4\30\1\70"+
    "\1\30\1\67\21\30\2\0\1\32\7\0\1\36\41\0"+
    "\2\71\1\72\1\73\1\71\1\0\45\71\3\74\1\75"+
    "\1\72\1\0\45\74\1\0\1\36\60\0\1\37\2\0"+
    "\5\37\1\0\1\37\1\0\6\37\1\76\21\37\10\0"+
    "\1\37\2\0\5\37\1\0\1\37\1\0\6\37\1\76"+
    "\14\37\1\77\4\37\10\0\1\37\2\0\5\37\1\0"+
    "\1\37\1\0\6\37\1\76\1\37\1\100\17\37\10\0"+
    "\1\37\2\0\5\37\1\0\1\37\1\0\6\37\1\76"+
    "\7\37\1\101\11\37\10\0\1\37\2\0\5\37\1\0"+
    "\1\37\1\0\6\37\1\76\7\37\1\102\11\37\11\0"+
    "\1\103\43\0\1\104\7\0\1\36\53\0\5\105\3\0"+
    "\2\105\1\0\3\105\1\0\21\105\13\0\5\106\3\0"+
    "\2\106\1\0\3\106\1\0\21\106\10\0\1\52\2\0"+
    "\5\52\1\0\1\52\1\12\6\52\1\0\21\52\16\0"+
    "\1\107\2\0\1\110\41\0\1\111\52\0\1\55\2\0"+
    "\5\55\1\0\1\55\1\0\6\55\1\112\21\55\10\0"+
    "\1\55\2\0\5\55\1\0\1\55\1\0\4\55\1\113"+
    "\1\55\1\112\21\55\10\0\1\57\2\0\5\57\1\0"+
    "\1\57\1\0\6\57\1\114\21\57\10\0\1\57\2\0"+
    "\5\57\1\0\1\57\1\0\4\57\1\115\1\57\1\114"+
    "\21\57\13\0\5\116\3\0\2\116\1\0\3\116\1\0"+
    "\21\116\10\0\1\63\2\0\5\63\1\0\1\63\1\22"+
    "\6\63\1\0\21\63\16\0\1\117\2\0\1\120\44\0"+
    "\5\121\3\0\2\121\1\0\3\121\1\0\21\121\13\0"+
    "\5\122\3\0\2\122\1\0\1\123\2\122\1\0\21\122"+
    "\10\0\1\30\2\0\5\30\1\0\1\30\1\0\5\30"+
    "\1\124\1\67\21\30\13\0\5\125\1\126\2\0\2\125"+
    "\1\0\3\125\1\0\21\125\13\0\5\127\1\130\2\0"+
    "\2\127\1\0\3\127\1\0\21\127\13\0\5\131\3\0"+
    "\2\131\1\0\3\131\1\0\1\132\5\131\1\133\7\131"+
    "\1\134\2\131\10\0\1\37\2\0\5\37\1\0\1\37"+
    "\1\0\6\37\1\76\13\37\1\135\5\37\10\0\1\37"+
    "\2\0\5\37\1\0\1\37\1\0\6\37\1\76\2\37"+
    "\1\136\16\37\10\0\1\37\2\0\5\37\1\0\1\37"+
    "\1\0\6\37\1\76\10\37\1\137\10\37\10\0\1\37"+
    "\2\0\5\37\1\0\1\37\1\0\6\37\1\76\1\140"+
    "\20\37\3\0\1\141\4\0\1\105\2\0\5\105\1\0"+
    "\1\105\1\0\6\105\1\0\21\105\5\0\1\141\2\0"+
    "\1\106\2\0\5\106\1\0\1\106\1\0\6\106\1\0"+
    "\21\106\21\0\1\142\1\0\1\142\3\0\2\142\2\0"+
    "\1\142\3\0\3\142\32\0\1\110\1\12\40\0\1\143"+
    "\70\0\1\144\34\0\1\55\2\0\5\55\1\0\1\55"+
    "\1\0\5\55\1\145\1\112\21\55\26\0\1\146\34\0"+
    "\1\57\2\0\5\57\1\0\1\57\1\0\5\57\1\147"+
    "\1\114\21\57\10\0\1\116\2\0\5\116\1\0\1\116"+
    "\1\0\6\116\1\0\21\116\21\0\1\150\1\0\1\150"+
    "\3\0\2\150\2\0\1\150\3\0\3\150\32\0\1\120"+
    "\1\22\40\0\1\121\2\0\5\121\1\0\1\121\1\0"+
    "\6\121\1\0\21\121\10\0\1\122\2\0\5\122\1\0"+
    "\1\122\1\0\6\122\1\0\21\122\10\0\1\122\2\0"+
    "\5\122\1\0\1\122\1\0\4\122\1\151\1\122\1\0"+
    "\21\122\10\0\1\125\2\0\5\125\1\0\1\125\1\71"+
    "\6\125\1\0\21\125\16\0\1\152\2\0\1\153\41\0"+
    "\1\127\2\0\5\127\1\0\1\127\1\74\6\127\1\0"+
    "\21\127\16\0\1\154\2\0\1\155\41\0\1\131\2\0"+
    "\5\131\1\0\1\131\1\0\6\131\1\0\21\131\10\0"+
    "\1\131\2\0\5\131\1\0\1\131\1\0\6\131\1\0"+
    "\1\131\1\156\17\131\10\0\1\131\2\0\5\131\1\0"+
    "\1\131\1\0\6\131\1\0\7\131\1\157\11\131\10\0"+
    "\1\131\2\0\5\131\1\0\1\131\1\0\6\131\1\0"+
    "\7\131\1\160\11\131\10\0\1\37\2\0\5\37\1\0"+
    "\1\37\1\0\6\37\1\161\21\37\10\0\1\37\2\0"+
    "\5\37\1\0\1\37\1\0\6\37\1\76\3\37\1\162"+
    "\15\37\10\0\1\37\2\0\2\37\1\163\2\37\1\0"+
    "\1\37\1\0\6\37\1\76\21\37\10\0\1\37\2\0"+
    "\5\37\1\0\1\37\1\0\6\37\1\76\2\37\1\164"+
    "\16\37\21\0\1\142\1\12\1\142\3\0\2\142\2\0"+
    "\1\142\3\0\3\142\12\0\7\143\1\165\43\143\26\0"+
    "\1\166\52\0\1\167\44\0\1\150\1\22\1\150\3\0"+
    "\2\150\2\0\1\150\3\0\3\150\21\0\1\122\2\0"+
    "\5\122\1\0\1\122\1\0\5\122\1\170\1\0\21\122"+
    "\21\0\1\171\1\0\1\171\3\0\2\171\2\0\1\171"+
    "\3\0\3\171\32\0\1\153\1\71\51\0\1\172\1\0"+
    "\1\172\3\0\2\172\2\0\1\172\3\0\3\172\32\0"+
    "\1\155\1\74\40\0\1\131\2\0\5\131\1\0\1\131"+
    "\1\0\6\131\1\0\2\131\1\173\16\131\10\0\1\131"+
    "\2\0\5\131\1\0\1\131\1\0\6\131\1\0\10\131"+
    "\1\174\10\131\10\0\1\131\2\0\5\131\1\0\1\131"+
    "\1\0\6\131\1\0\1\175\20\131\13\0\5\131\3\0"+
    "\2\131\1\0\3\131\1\0\1\132\5\131\1\133\4\131"+
    "\1\176\2\131\1\134\2\131\10\0\1\37\2\0\5\37"+
    "\1\0\1\37\1\0\6\37\1\76\4\37\1\177\14\37"+
    "\10\0\1\37\2\0\5\37\1\0\1\37\1\0\4\37"+
    "\1\200\1\37\1\76\21\37\10\0\1\37\2\0\5\37"+
    "\1\0\1\37\1\0\6\37\1\76\1\37\1\201\17\37"+
    "\1\0\7\143\1\202\43\143\27\0\1\203\52\0\1\204"+
    "\43\0\1\171\1\71\1\171\3\0\2\171\2\0\1\171"+
    "\3\0\3\171\32\0\1\172\1\74\1\172\3\0\2\172"+
    "\2\0\1\172\3\0\3\172\21\0\1\131\2\0\5\131"+
    "\1\0\1\131\1\0\6\131\1\0\3\131\1\205\15\131"+
    "\10\0\1\131\2\0\2\131\1\206\2\131\1\0\1\131"+
    "\1\0\6\131\1\0\21\131\10\0\1\131\2\0\5\131"+
    "\1\0\1\131\1\0\6\131\1\0\2\131\1\207\16\131"+
    "\10\0\1\131\2\0\5\131\1\0\1\131\1\0\6\131"+
    "\1\0\7\131\1\210\11\131\10\0\1\37\2\0\5\37"+
    "\1\0\1\37\1\0\6\37\1\76\1\211\20\37\10\0"+
    "\1\37\2\0\5\37\1\0\1\37\1\0\6\37\1\76"+
    "\17\37\1\212\1\37\11\0\1\213\51\0\1\131\2\0"+
    "\5\131\1\0\1\131\1\0\6\131\1\0\4\131\1\214"+
    "\14\131\10\0\1\131\2\0\5\131\1\0\1\131\1\0"+
    "\4\131\1\215\1\131\1\0\21\131\10\0\1\131\2\0"+
    "\5\131\1\0\1\131\1\0\6\131\1\0\1\131\1\216"+
    "\17\131\10\0\1\131\2\0\5\131\1\0\1\131\1\0"+
    "\6\131\1\0\15\131\1\217\3\131\10\0\1\37\2\0"+
    "\5\37\1\0\1\37\1\0\6\37\1\76\5\37\1\220"+
    "\13\37\10\0\1\37\2\0\5\37\1\0\1\37\1\0"+
    "\6\37\1\76\20\37\1\221\10\0\1\131\2\0\5\131"+
    "\1\0\1\131\1\0\6\131\1\0\1\222\20\131\10\0"+
    "\1\131\2\0\5\131\1\0\1\131\1\0\6\131\1\0"+
    "\17\131\1\223\1\131\10\0\1\131\2\0\5\131\1\0"+
    "\1\131\1\0\6\131\1\0\10\131\1\224\10\131\10\0"+
    "\1\37\2\0\5\37\1\0\1\37\1\0\6\37\1\76"+
    "\1\37\1\225\17\37\10\0\1\37\2\0\5\37\1\0"+
    "\1\37\1\0\6\37\1\76\16\37\1\226\2\37\10\0"+
    "\1\131\2\0\5\131\1\0\1\131\1\0\6\131\1\0"+
    "\5\131\1\227\13\131\10\0\1\131\2\0\5\131\1\0"+
    "\1\131\1\0\6\131\1\0\20\131\1\230\2\0\1\231"+
    "\5\0\1\131\1\0\1\232\5\131\1\0\1\131\1\0"+
    "\6\131\1\0\21\131\10\0\1\37\2\0\5\37\1\0"+
    "\1\37\1\0\6\37\1\76\1\37\1\233\17\37\10\0"+
    "\1\131\2\0\5\131\1\0\1\131\1\0\6\131\1\0"+
    "\1\131\1\234\17\131\10\0\1\131\2\0\5\131\1\0"+
    "\1\131\1\0\6\131\1\0\16\131\1\235\2\131\2\0"+
    "\1\231\7\0\1\232\42\0\1\232\1\236\1\0\1\237"+
    "\47\0\1\240\5\0\1\37\1\0\1\241\5\37\1\0"+
    "\1\37\1\0\6\37\1\76\21\37\10\0\1\131\2\0"+
    "\5\131\1\0\1\131\1\0\6\131\1\0\1\131\1\242"+
    "\17\131\13\0\1\243\4\244\3\0\1\243\2\0\3\243"+
    "\1\0\21\243\13\0\1\245\4\246\3\0\1\245\2\0"+
    "\3\245\1\0\21\245\2\0\1\240\7\0\1\241\42\0"+
    "\1\241\1\247\1\0\1\250\47\0\1\240\5\0\1\131"+
    "\1\0\1\241\5\131\1\0\1\131\1\0\6\131\1\0"+
    "\21\131\13\0\5\251\3\0\1\251\2\0\3\251\1\0"+
    "\21\251\10\0\1\252\2\0\5\251\3\0\1\251\2\0"+
    "\3\251\1\0\21\251\13\0\5\253\3\0\1\253\2\0"+
    "\3\253\1\0\21\253\10\0\1\254\2\0\5\253\3\0"+
    "\1\253\2\0\3\253\1\0\21\253\26\0\1\255\14\0"+
    "\1\256\35\0\1\257\14\0\1\256\12\0\1\260\4\0"+
    "\1\252\55\0\5\261\3\0\1\261\2\0\3\261\1\0"+
    "\21\261\5\0\1\260\2\0\1\254\55\0\5\262\3\0"+
    "\1\262\2\0\3\262\1\0\21\262\33\0\1\263\33\0"+
    "\1\264\71\0\1\265\22\0\1\260\4\0\1\252\2\0"+
    "\5\261\3\0\1\261\2\0\3\261\1\0\21\261\5\0"+
    "\1\260\2\0\1\254\2\0\5\262\3\0\1\262\2\0"+
    "\3\262\1\0\21\262\34\0\1\266\62\0\1\267\42\0"+
    "\1\270\53\0\1\271\50\0\1\272\54\0\1\273\53\0"+
    "\1\274\46\0\1\275\56\0\1\276\46\0\1\277\61\0"+
    "\1\300\43\0\1\301\57\0\1\302\60\0\1\303\44\0"+
    "\1\304\46\0\1\305\22\0\1\306\1\0\1\306\100\0"+
    "\1\307\22\0\1\310\54\0\1\310\46\0";

  /**
   * The transition table of the DFA
   */
  final private static int yytrans [] = yy_unpack();


  /* error codes */
  final private static int YY_UNKNOWN_ERROR = 0;
  final private static int YY_ILLEGAL_STATE = 1;
  final private static int YY_NO_MATCH = 2;
  final private static int YY_PUSHBACK_2BIG = 3;

  /* error messages for the codes above */
  final private static String YY_ERROR_MSG[] = {
    "Unkown internal scanner error",
    "Internal error: unknown state",
    "Error: could not match input",
    "Error: pushback value was too large"
  };

  /**
   * YY_ATTRIBUTE[aState] contains the attributes of state <code>aState</code>
   */
  private final static byte YY_ATTRIBUTE[] = {
     1,  0,  0,  1,  0,  0,  0,  0,  0,  1,  1,  1,  1,  9,  9,  1,
     1,  1,  1,  1,  1,  9,  1,  1,  1,  1,  1,  1,  9,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  9,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  9,  0,  0,  1,  0,  9,  0,  0,  0,  0,  1,  1,
     1,  1,  9,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  1,  0,  0,
     1,  1,  1,  1,  0,  0,  0,  0,  1,  1,  1,  1,  1,  1,  1,  1,
     9,  0,  0,  0,  1,  0,  1,  0,  1,  0,  0,  0,  0,  1,  1,  1,
     0,  1,  1,  1,  0,  0,  0,  1,  0,  0,  1,  1,  1,  1,  1,  1,
     1,  0,  9,  9,  1,  1,  1,  1,  1,  1,  9,  1,  1,  1,  1,  1,
     1,  1,  1,  1,  1,  1,  1,  1,  0,  0,  1,  1,  1,  0,  0,  0,
     0,  1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  9,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  9,  0,  9
  };

  /** the input device */
  private java.io.Reader yy_reader;

  /** the current state of the DFA */
  private int yy_state;

  /** the current lexical state */
  private int yy_lexical_state = YYINITIAL;

  /** this buffer contains the current text to be matched and is
      the source of the yytext() string */
  private char yy_buffer[] = new char[YY_BUFFERSIZE];

  /** the textposition at the last accepting state */
  private int yy_markedPos;

  /** the textposition at the last state to be included in yytext */
  private int yy_pushbackPos;

  /** the current text position in the buffer */
  private int yy_currentPos;

  /** startRead marks the beginning of the yytext() string in the buffer */
  private int yy_startRead;

  /** endRead marks the last character in the buffer, that has been read
      from input */
  private int yy_endRead;

  /** number of newlines encountered up to the start of the matched text */
  private int yyline;

  /** the number of characters up to the start of the matched text */
  private int yychar;

  /**
   * the number of characters from the last newline up to the start of the
   * matched text
   */
  private int yycolumn;

  /**
   * yy_atBOL == true <=> the scanner is currently at the beginning of a line
   */
  private boolean yy_atBOL = true;

  /** yy_atEOF == true <=> the scanner is at the EOF */
  private boolean yy_atEOF;

  /** denotes if the user-EOF-code has already been executed */
  private boolean yy_eof_done;

  /* user code: */
   /**
    * NS_Prefix is for saving the prefixes of the RDF namespace.
    */
   private String NS_Prefix;

   /**
    * RDF_prefix_set containing the prefixes for the RDF namespace.
    */
   private HashSet RDF_prefix_set = new HashSet();

   /**
    * Boolean set if we have a namespace declaration.
    */
    private boolean ns = false;

   /**
    * The nested_counter helps to know when we are allowed to leave a RDF description
    * in case we have a embedded RDF.
    */
   private int nested_counter = 0;


   /**
    * For debugging - lexer will print the generated tokens and the tokentypes to a Output. The default setting is 'false'.
    */
    private boolean debug = false; // for debugging, default setting is 'false'

    /**
     * For debugging - lexer will print the generated tokens and the tokentypes to a Output. The default setting is 'false'.
     */
    public void setdebug(boolean b) {
    	this.debug = b;
    }


   /**
    * Hash Map containing the entity reference names and values.
    */
    private HashMap entities = entities_init();

    private HashMap entities_init() {
    	HashMap map = new HashMap();
    	map.put("lt","<");
    	map.put("gt",">");
    	map.put("amp","&");
    	map.put("apos","\'");
    	map.put("quot","\"");

    	return map;
    }


   /**
   *  Creating the Symbol that will be send to the parser.
   *  The corresponding Tokenname to the Tokentype can be
   *  found in sym.java. sym.java will be created by the parser.
   */
   private Symbol symbol(int type, Object value) {
	if (debug) {
		Output out = new Output();
		out.out("Lexer-Text: " +yytext() +" \t Tokentype: " +type+" \t Line = " +yyline, false);
	}
	return new Symbol(type, yyline, yycolumn, value);
   }


   /**
   *  Testing if the current yytext() containing a prefix that belong to the RDF namespace.
   */
   private boolean RDF_ns() {
	String Prefix = yytext();
	int i = Prefix.indexOf(":");
	if (i<0) Prefix = "";
	else Prefix = Prefix.substring(0,i);
	if (RDF_prefix_set.contains(Prefix)) {
//		System.out.println("NS found: "+Prefix);
		return true;
	}
	System.out.println("no RDF namespace Prefix: "+Prefix);
	return false;
   }

   /**
   *  Recognize the attribute "ID" and "xml..." and the special prefix "xmlns".
   */
   private Symbol nsattributename() {
	int i = yytext().indexOf(":");
	String attribute = yytext().substring(++i);
	String prefix = yytext().substring(0,--i);
//	System.out.println("NS-Prefix: "+prefix);
	if (yytext().startsWith("xmlns"))  {
		ns = true;
		prefix = yytext().substring(++i);
		NS_Prefix = prefix;
		return symbol(sym.XMLNS, prefix);}
	if (yytext().startsWith("xml")) return symbol(sym.XMLATTR, yytext());
	if (attribute.equals("ID")) {
		yybegin(RDF_Attribute_IDSYMBOL);
		return symbol(sym.IDNAME, yytext());
	}
	return symbol(sym.ATTRIBUTENAME, yytext());
   }

   /**
   *  Recognize the attribute "ID" and "xml..." and the special prefix "xmlns".
   */
   private Symbol attributename() {
	if (yytext().equals("xmlns")) {
		ns = true;
		NS_Prefix = "";
		return symbol(sym.XMLNS, "");
	}
	if (yytext().startsWith("xml")) return symbol(sym.XMLATTR, yytext());
	if (yytext().equals("ID"))  {
		yybegin(RDF_Attribute_IDSYMBOL);
		return symbol(sym.IDNAME, yytext());
	}
	return symbol(sym.ATTRIBUTENAME, yytext());
   }


   /**
   *  Replace a reference with the corresponding string.
   */
   private String Ref_replace(String str) {
	int i = str.indexOf("&");
	if (i < 0) return str;
	String text = str.substring(0,i); // the text before the &
	String rest = str.substring(i); // the text starting with &
	// System.out.println("rest1: "+rest);
	int j = rest.indexOf(";");
	String value = rest.substring(0,j); // the text from & to the next ;
	rest = rest.substring(++j); // the rest string after the ;
	// System.out.println("rest2: "+rest);
	int k = 0;
	if (value.startsWith("&#x")) { // Hexadecimal
		value = value.substring(3);
		k = hextodec(value);
		char c = (char)k;
		text = text + c + Ref_replace(rest);
//		System.out.println("char Hex: "+c+" "+k+ " " +text);
	} else {
		if (value.startsWith("&#")) { // Decimal
			value = value.substring(2);
			k = Integer.parseInt(value);
			char c = (char)k;
			text = text + c + Ref_replace(rest);
//			System.out.println("char "+c+" "+k+ " " +text);
		} else { // Entity References
			// remove the &
			value = value.substring(1);
			if (entities.containsKey(value)) {
				text = text + entities.get(value).toString() + Ref_replace(rest);
			} else {
				System.out.println("Value "+value+" not found in HashMap.");
				text = text + Ref_replace(rest);
			}
		}
	}

	return text;
   }

   /**
   *  Transforming the hexadecimal number given by the parameter to the corresponding
   *  decimal int.
   */
   private int hextodec(String str) {
	str = str.toLowerCase();
//	System.out.println(str);
	char[] ch_array = str.toCharArray();
	int i = ch_array.length;
	int j = 0;
	int mult = 1;
	int hex = 16;
	while (i-- > 0) {
//		System.out.println(ch_array[i]);
		if (ch_array[i] == 'f') j = j + (15 * mult);
		if (ch_array[i] == 'e') j = j + (14 * mult);
		if (ch_array[i] == 'd') j = j + (13 * mult);
		if (ch_array[i] == 'c') j = j + (12 * mult);
		if (ch_array[i] == 'b') j = j + (11 * mult);
		if (ch_array[i] == 'a') j = j + (10 * mult);
		if (ch_array[i] == '0' ||
		    ch_array[i] == '1' ||
		    ch_array[i] == '2' ||
		    ch_array[i] == '3' ||
		    ch_array[i] == '4' ||
		    ch_array[i] == '5' ||
		    ch_array[i] == '6' ||
		    ch_array[i] == '7' ||
		    ch_array[i] == '8' ||
		    ch_array[i] == '9' ) {
			String s = ch_array[i]+"";
			int k = Integer.parseInt(s);
//			System.out.println(s+" als int "+k);
			j = j + (k * mult);
		}
		mult = mult * hex;
	}
	System.out.println(str+" = "+j+" dec");
	return j;
   }





  /**
   * Creates a new scanner
   * There is also a java.io.InputStream version of this constructor.
   *
   * @param   in  the java.io.Reader to read input from.
   */
  public Lexer_Simple(java.io.Reader in) {
    this.yy_reader = in;
  }

  /**
   * Creates a new scanner.
   * There is also java.io.Reader version of this constructor.
   *
   * @param   in  the java.io.Inputstream to read input from.
   */
  public Lexer_Simple(java.io.InputStream in) {
    this(new java.io.InputStreamReader(in));
  }

  /**
   * Unpacks the split, compressed DFA transition table.
   *
   * @return the unpacked transition table
   */
  private static int [] yy_unpack() {
    int [] trans = new int[7439];
    int offset = 0;
    offset = yy_unpack(yy_packed0, offset, trans);
    return trans;
  }

  /**
   * Unpacks the compressed DFA transition table.
   *
   * @param packed   the packed transition table
   * @return         the index of the last entry
   */
  private static int yy_unpack(String packed, int offset, int [] trans) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      value--;
      do trans[j++] = value; while (--count > 0);
    }
    return j;
  }

  /**
   * Unpacks the compressed character translation table.
   *
   * @param packed   the packed character translation table
   * @return         the unpacked character translation table
   */
  private static char [] yy_unpack_cmap(String packed) {
    char [] map = new char[0x10000];
    int i = 0;  /* index in packed string  */
    int j = 0;  /* index in unpacked array */
    while (i < 1322) {
      int  count = packed.charAt(i++);
      char value = packed.charAt(i++);
      do map[j++] = value; while (--count > 0);
    }
    return map;
  }


  /**
   * Refills the input buffer.
   *
   * @return      <code>false</code>, iff there was new input.
   *
   * @exception   IOException  if any I/O-Error occurs
   */
  private boolean yy_refill() throws java.io.IOException {

    /* first: make room (if you can) */
    if (yy_startRead > 0) {
      System.arraycopy(yy_buffer, yy_startRead,
                       yy_buffer, 0,
                       yy_endRead-yy_startRead);

      /* translate stored positions */
      yy_endRead-= yy_startRead;
      yy_currentPos-= yy_startRead;
      yy_markedPos-= yy_startRead;
      yy_pushbackPos-= yy_startRead;
      yy_startRead = 0;
    }

    /* is the buffer big enough? */
    if (yy_currentPos >= yy_buffer.length) {
      /* if not: blow it up */
      char newBuffer[] = new char[yy_currentPos*2];
      System.arraycopy(yy_buffer, 0, newBuffer, 0, yy_buffer.length);
      yy_buffer = newBuffer;
    }

    /* finally: fill the buffer with new input */
    int numRead = yy_reader.read(yy_buffer, yy_endRead,
                                            yy_buffer.length-yy_endRead);

    if (numRead < 0) {
      return true;
    }
    else {
      yy_endRead+= numRead;
      return false;
    }
  }


  /**
   * Closes the input stream.
   */
  final public void yyclose() throws java.io.IOException {
    yy_atEOF = true;            /* indicate end of file */
    yy_endRead = yy_startRead;  /* invalidate buffer    */

    if (yy_reader != null)
      yy_reader.close();
  }


  /**
   * Closes the current stream, and resets the
   * scanner to read from a new input stream.
   *
   * All internal variables are reset, the old input stream
   * <b>cannot</b> be reused (internal buffer is discarded and lost).
   * Lexical state is set to <tt>YY_INITIAL</tt>.
   *
   * @param reader   the new input stream
   */
  final public void yyreset(java.io.Reader reader) throws java.io.IOException {
    yyclose();
    yy_reader = reader;
    yy_atBOL  = true;
    yy_atEOF  = false;
    yy_endRead = yy_startRead = 0;
    yy_currentPos = yy_markedPos = yy_pushbackPos = 0;
    yyline = yychar = yycolumn = 0;
    yy_lexical_state = YYINITIAL;
  }


  /**
   * Returns the current lexical state.
   */
  final public int yystate() {
    return yy_lexical_state;
  }


  /**
   * Enters a new lexical state
   *
   * @param newState the new lexical state
   */
  final public void yybegin(int newState) {
    yy_lexical_state = newState;
  }


  /**
   * Returns the text matched by the current regular expression.
   */
  final public String yytext() {
    return new String( yy_buffer, yy_startRead, yy_markedPos-yy_startRead );
  }


  /**
   * Returns the character at position <tt>pos</tt> from the
   * matched text.
   *
   * It is equivalent to yytext().charAt(pos), but faster
   *
   * @param pos the position of the character to fetch.
   *            A value from 0 to yylength()-1.
   *
   * @return the character at position pos
   */
  final public char yycharat(int pos) {
    return yy_buffer[yy_startRead+pos];
  }


  /**
   * Returns the length of the matched text region.
   */
  final public int yylength() {
    return yy_markedPos-yy_startRead;
  }


  /**
   * Reports an error that occured while scanning.
   *
   * In a wellformed scanner (no or only correct usage of
   * yypushback(int) and a match-all fallback rule) this method
   * will only be called with things that "Can't Possibly Happen".
   * If this method is called, something is seriously wrong
   * (e.g. a JFlex bug producing a faulty scanner etc.).
   *
   * Usual syntax/scanner level error handling should be done
   * in error fallback rules.
   *
   * @param   errorCode  the code of the errormessage to display
   */
  private void yy_ScanError(int errorCode) {
    String message;
    try {
      message = YY_ERROR_MSG[errorCode];
    }
    catch (ArrayIndexOutOfBoundsException e) {
      message = YY_ERROR_MSG[YY_UNKNOWN_ERROR];
    }

    throw new Error(message);
  }


  /**
   * Pushes the specified amount of characters back into the input stream.
   *
   * They will be read again by then next call of the scanning method
   *
   * @param number  the number of characters to be read again.
   *                This number must not be greater than yylength()!
   */
  private void yypushback(int number)  {
    if ( number > yylength() )
      yy_ScanError(YY_PUSHBACK_2BIG);

    yy_markedPos -= number;
  }


  /**
   * Contains user EOF-code, which will be executed exactly once,
   * when the end of file is reached
   */
  private void yy_do_eof() throws java.io.IOException {
    if (!yy_eof_done) {
      yy_eof_done = true;
      yyclose();
    }
  }


  /**
   * Resumes scanning until the next regular expression is matched,
   * the end of input is encountered or an I/O-Error occurs.
   *
   * @return      the next token
   * @exception   IOException  if any I/O-Error occurs
   */
  public java_cup.runtime.Symbol next_token() throws java.io.IOException {
    int yy_input;
    int yy_action;

    // cached fields:
    int yy_currentPos_l;
    int yy_startRead_l;
    int yy_markedPos_l;
    int yy_endRead_l = yy_endRead;
    char [] yy_buffer_l = yy_buffer;
    char [] yycmap_l = yycmap;

    int [] yytrans_l = yytrans;
    int [] yy_rowMap_l = yy_rowMap;
    byte [] yy_attr_l = YY_ATTRIBUTE;

    while (true) {
      yy_markedPos_l = yy_markedPos;

      boolean yy_r = false;
      for (yy_currentPos_l = yy_startRead; yy_currentPos_l < yy_markedPos_l;
                                                             yy_currentPos_l++) {
        switch (yy_buffer_l[yy_currentPos_l]) {
        case '\u000B':
        case '\u000C':
        case '\u0085':
        case '\u2028':
        case '\u2029':
          yyline++;
          yycolumn = 0;
          yy_r = false;
          break;
        case '\r':
          yyline++;
          yycolumn = 0;
          yy_r = true;
          break;
        case '\n':
          if (yy_r)
            yy_r = false;
          else {
            yyline++;
            yycolumn = 0;
          }
          break;
        default:
          yy_r = false;
          yycolumn++;
        }
      }

      if (yy_r) {
        // peek one character ahead if it is \n (if we have counted one line too much)
        boolean yy_peek;
        if (yy_markedPos_l < yy_endRead_l)
          yy_peek = yy_buffer_l[yy_markedPos_l] == '\n';
        else if (yy_atEOF)
          yy_peek = false;
        else {
          boolean eof = yy_refill();
          yy_markedPos_l = yy_markedPos;
          yy_buffer_l = yy_buffer;
          if (eof)
            yy_peek = false;
          else
            yy_peek = yy_buffer_l[yy_markedPos_l] == '\n';
        }
        if (yy_peek) yyline--;
      }
      yy_action = -1;

      yy_startRead_l = yy_currentPos_l = yy_currentPos =
                       yy_startRead = yy_markedPos_l;

      yy_state = yy_lexical_state;


      yy_forAction: {
        while (true) {

          if (yy_currentPos_l < yy_endRead_l)
            yy_input = yy_buffer_l[yy_currentPos_l++];
          else if (yy_atEOF) {
            yy_input = YYEOF;
            break yy_forAction;
          }
          else {
            // store back cached positions
            yy_currentPos  = yy_currentPos_l;
            yy_markedPos   = yy_markedPos_l;
            boolean eof = yy_refill();
            // get translated positions and possibly new buffer
            yy_currentPos_l  = yy_currentPos;
            yy_markedPos_l   = yy_markedPos;
            yy_buffer_l      = yy_buffer;
            yy_endRead_l     = yy_endRead;
            if (eof) {
              yy_input = YYEOF;
              break yy_forAction;
            }
            else {
              yy_input = yy_buffer_l[yy_currentPos_l++];
            }
          }
          int yy_next = yytrans_l[ yy_rowMap_l[yy_state] + yycmap_l[yy_input] ];
          if (yy_next == -1) break yy_forAction;
          yy_state = yy_next;

          int yy_attributes = yy_attr_l[yy_state];
          if ( (yy_attributes & 1) == 1 ) {
            yy_action = yy_state;
            yy_markedPos_l = yy_currentPos_l;
            if ( (yy_attributes & 8) == 8 ) break yy_forAction;
          }

        }
      }

      // store back cached position
      yy_markedPos = yy_markedPos_l;

      switch (yy_action) {

        case 30:
        case 31:
        case 32:
        case 33:
        case 34:
        case 62:
        case 63:
        case 64:
        case 65:
        case 92:
        case 93:
        case 94:
        case 95:
        case 113:
        case 114:
        case 115:
        case 126:
        case 128:
        case 136:
        case 137:
        case 143:
        case 144:
        case 149:
        case 154:
          {  return attributename();  }
        case 201: break;
        case 3:
        case 17:
          {  String text = Ref_replace(yytext());
			  return symbol(sym.STRING, text);  }
        case 202: break;
        case 57:
          {  if (ns) {
				if (yytext().equals("\""+rdf.NS+"\"")) RDF_prefix_set.add(NS_Prefix);
				ns = false;
			  }
			  String text = Ref_replace(yytext());
			  return symbol(sym.ATTRIBUTEVALUE, text);  }
        case 203: break;
        case 21:
          {  return symbol(sym.ALEND, yytext());  }
        case 204: break;
        case 29:
          {  return symbol(sym.EQUAL, yytext());  }
        case 205: break;
        case 81:
        case 82:
        case 104:
          {  if (yytext().endsWith("Description")) {
				if (nested_counter == 0) yybegin(YYINITIAL);
				  else {
					yybegin(RDF_YYINITIAL);
					nested_counter--;
				  }
			  } else yybegin(RDF_YYINITIAL);
			  return symbol(sym.QNAME, yytext());  }
        case 206: break;
        case 77:
          {  yybegin(YYINITIAL);  }
        case 207: break;
        case 16:
          {  yybegin(YYINITIAL);  }
        case 208: break;
        case 23:
        case 24:
        case 55:
          {  if (yytext().equals("Description")) {
				if (nested_counter == 0) yybegin(YYINITIAL);
				  else {
					yybegin(RDF_YYINITIAL);
					nested_counter--;
				  }
			  } else yybegin(RDF_YYINITIAL);
			  return symbol(sym.QNAME, yytext());  }
        case 209: break;
        case 175:
          {  return symbol(sym.XMLLANG, yytext());  }
        case 210: break;
        case 199:
          {  return symbol(sym.PARSETYPERES, yytext());  }
        case 211: break;
        case 197:
          {  return symbol(sym.PARSETYPELIT, yytext());  }
        case 212: break;
        case 22:
          {  yybegin(RDF_Attribute);
			  if (yytext().equals("Description")) nested_counter++;
			  return symbol(sym.QNAME, yytext());  }
        case 213: break;
        case 148:
        case 155:
          {  return symbol(sym.RESOURCEATTR, yytext());  }
        case 214: break;
        case 127:
        case 140:
          {  yybegin(RDF_Attribute_IDSYMBOL);
			  return symbol(sym.BAGID, yytext());  }
        case 215: break;
        case 100:
        case 130:
          {  String s = yytext();
   			  int i = s.length();
   			  yypushback(i);
   			  yybegin(QName_Begin);
   			  return symbol(sym.ELSTART, "<");
   			  }
        case 216: break;
        case 83:
        case 119:
          {  yybegin(RDF_End);
			  return symbol(sym.RDFEND, yytext());  }
        case 217: break;
        case 66:
          {  yybegin(RDF_YYINITIAL);
			  return symbol(sym.ALELEND, yytext());  }
        case 218: break;
        case 39:
          {  yybegin(YYINITIAL);
   			  return symbol(sym.ALEND, yytext());  }
        case 219: break;
        case 52:
          {  yybegin(RDF_QName_End);
			  return symbol(sym.ELEND, yytext());  }
        case 220: break;
        case 20:
          {  yybegin(RDF_QName_Begin);
			  return symbol(sym.ELSTART, yytext());  }
        case 221: break;
        case 28:
          {  yybegin(RDF_YYINITIAL);
			  return symbol(sym.ALEND, yytext());  }
        case 222: break;
        case 96:
          {  yybegin(RDF_Attribute);
			  return symbol(sym.ATTRIBUTEVALUE, yytext());  }
        case 223: break;
        case 10:
          {  /* ignore */
			  /* System.out.println("S"); */  }
        case 224: break;
        case 18:
          {  /* ignore */
			  /* System.out.println("S"); */  }
        case 225: break;
        case 25:
          {  /* ignore */
			  /* System.out.println("S"); */  }
        case 226: break;
        case 88:
        case 89:
        case 90:
        case 91:
        case 109:
        case 110:
        case 111:
        case 122:
        case 123:
        case 124:
        case 125:
        case 132:
        case 133:
        case 134:
        case 135:
        case 139:
        case 141:
        case 142:
        case 145:
        case 146:
        case 147:
        case 150:
        case 151:
        case 156:
        case 161:
          {  return nsattributename();  }
        case 227: break;
        case 14:
        case 15:
        case 19:
        case 26:
        case 27:
        case 35:
        case 36:
        case 37:
        case 38:
          {  String state="yystate";
			  switch (yystate()) {
				case 0: state = "YYINITIAL"; break;
				case 4: state = "RDF_YYINITIAL"; break;
				case 1: state = "QName_Begin"; break;
				case 5: state = "RDF_QName_Begin"; break;
				case 2: state = "QName_End"; break;
				case 6: state = "RDF_QName_End"; break;
				case 3: state = "Attribute"; break;
				case 7: state = "RDF_Attribute"; break;
				case 8: state = "RDF_Attribute_IDSYMBOL"; break;
			  }
			  RDF_Error e = new RDF_Error();
			  e.emit_error(0, yystate(), "<"+yytext()+"> at line "+yyline+", column "+yycolumn+", state "+state+".", "lexer:error fallback");
			  //changed on 26. Sept. 2000: start
			  yy_do_eof();
			  }
        case 228: break;
        case 13:
          {  /* ignore */  }
        case 229: break;
        case 12:
          {  /* ignore */  }
        case 230: break;
        case 11:
          {  /* ignore */  }
        case 231: break;
        case 0:
        case 9:
          {  /* ignore */  }
        case 232: break;
        case 102:
        case 131:
          {  yybegin(RDF_Attribute);
   			  String text = yytext();
   			  text = text.substring(1);
   			  /*System.out.println(text);*/
			  return symbol(sym.RDFBEGIN, text);  }
        case 233: break;
        case 80:
          {  yybegin(RDF_Attribute);
			  if (yytext().endsWith("Description")) nested_counter++;
			  return symbol(sym.QNAME, yytext());  }
        case 234: break;
        case 138:
          {  /* ignore */
			  /* System.out.println("Comment"); */  }
        case 235: break;
        default:
          if (yy_input == YYEOF && yy_startRead == yy_currentPos) {
            yy_atEOF = true;
            yy_do_eof();
              { return new java_cup.runtime.Symbol(sym.EOF); }
          }
          else {
            yy_ScanError(YY_NO_MATCH);
          }
      }
    }
  }


}
