/* This software was developed within the context of the project Metaphor for Science
   Museums (Mesmuses) in the framework of the Information Society Technology
   Programme, part of the Fifth Research And Technological Development
   Framework Programme of the European Community, under the Consortium
   Agreement dated <June 30, 2001>, between INRIA, Finsiel Spa, IMSS,
   Valoris , CSI, ICS-FORTH, ENSTB, EDW International.
*/

package gr.forth.ics.vrp.corevrp.model;

/**
 * Represents an RDF triple/statement
 *
 * @author Karsten Tolle & Sofia Alexaki
 * @version 2.5  (30 Januar 2003)
 */
public class Triple {

   public Triple(String pred, String sub, String obj) {
      setPredicate(pred);
      setSubject(sub);
      setObject(obj);
      setIsObjectResource(false);
   }

   public Triple(String pred, String sub, Literal obj) {
      setPredicate(pred);
      setSubject(sub);
      setObject(obj);
      setIsObjectResource(true);
   }

   private String predicate = "";
   private String subject = "";
   private Object object = null;
   private boolean isObjectResource;

  /**
   * Returns the predicate of the triple
   */
   public String getPredicate() {
      return predicate;
   }

  /**
   * Sets the predicate of the triple
   */
   public void setPredicate(String predicate){
      this.predicate = predicate;
   }

  /**
   * Returns the subject of the triple
   */

    public String getSubject() {
      return subject;
   }

  /**
   * Sets the subject of the triple
   */
   public void setSubject(String subject){
      this.subject = subject;
   }

  /**
   * Returns the object of the triple
   */
   public Object getObject() {
      return object;
   }

  /**
   * Sets the object of the triple, when object is resource
   */

   public void setObject(String object){
      this.object = object;
      this.isObjectResource = true;
   }

  /**
   * Sets the object of the triple, when object is literal
   */
   public void setObject(Literal object) {
      this.object = object;
      this.isObjectResource = false;
   }

  /**
   * Returns the type of the object. True when the object is resource.
   */
   public boolean getIsObjectResource() {
      return isObjectResource;
   }

   /**
    * Sets the type of the object. True when the object is resource.
    */
   public void setIsObjectResource(boolean isRes){
      this.isObjectResource = isRes;
   }
}