/* This software was developed within the context of the project Metaphor for Science
   Museums (Mesmuses) in the framework of the Information Society Technology
   Programme, part of the Fifth Research And Technological Development
   Framework Programme of the European Community, under the Consortium
   Agreement dated <June 30, 2001>, between INRIA, Finsiel Spa, IMSS,
   Valoris , CSI, ICS-FORTH, ENSTB, EDW International.
*/

// Resource.java

package gr.forth.ics.vrp.corevrp.model;

import java.net.*;


/** Resource.java - A node in an RDF Model. Also the base class
  * that all RDF things are derived from.
  *
  * We don't actually DO much with a resource, other than get
  * or set its URI.
  *
 * @author Karsten Tolle & Sofia Alexaki
 * @version 2.5  (30 Januar 2003)
  */
public class Resource {

    /**
     * Create a new Resource.
     */
    Resource() { };

    /**
     * Create a new Resource and set the URI.
     */
    Resource(URL theURI) {
	setID(theURI.toString());
    };

    /**
     * Create a new Resource and set the URI.
     */
    Resource(String theURI) {
	setID(theURI);
    };

    /**
     * The URI of a Resource.
     */
    private String uri = "";

    // Getters and setters
    /**
     * Get the URI of the resource.
     */
    public String getID() { return uri;};

    /**
     * Set the URI of the resource.
     */
    public void setID(String theURI) { uri = theURI; };

  }
