/* This software was developed within the context of the project Metaphor for Science
   Museums (Mesmuses) in the framework of the Information Society Technology
   Programme, part of the Fifth Research And Technological Development
   Framework Programme of the European Community, under the Consortium
   Agreement dated <June 30, 2001>, between INRIA, Finsiel Spa, IMSS,
   Valoris , CSI, ICS-FORTH, ENSTB, EDW International.
*/

// RDF_Statement.java

package gr.forth.ics.vrp.corevrp.model;

import java.net.*;

/** RDF_Statement.java - The class for Statements.
  *
 * @author Karsten Tolle & Sofia Alexaki
 * @version 2.5  (30 Januar 2003)
  */
public class RDF_Statement extends RDF_Resource {

    /**
     * Create a new RDF_Statement.
     */
    RDF_Statement() { };

    /**
     * Create a new RDF_Statement and set the URI.
     */
    RDF_Statement(URL theURI) {
	setID(theURI.toString());
    };

    /**
     * Create a new RDF_Statement and set the URI.
     */
    RDF_Statement(String theURI) {
	setID(theURI);
    };

    /**
     * Cast a Resource to a new RDF_Statement.
     */
    RDF_Statement(Resource res) {
	setID(res.getID());
    }

    /**
     * Cast a RDF_Resource to a new RDF_Statement.
     */
    RDF_Statement(RDF_Resource res) {
	setID(res.getID());
  	setcomment(res.getcomment());
	setlabel(res.getlabel());
	setseeAlso(res.getseeAlso());
	setisDefinedBy(res.getisDefinedBy());
	setvalue(res.getvalue());
	settype(res.gettype());
    }

    // Variables
    /** The subject of the RDF_Statement.*/
    private Object subject;
    /** The predicate of the RDF_Statement.*/
    private RDF_Property predicate;
    /** The object of the RDF_Statement.*/
    private Object object;


    // Getters and setters
    /**
     * Enter the subject to the statement. Returns false in the case there exists already a different subject for this statement.
     */
    public boolean setsubject(Object subj) {
        if (subj instanceof Integer) {
            // We are in a phase where all not resoulved links are done by Integer
            // this means that if there exist already a subject it must be an Integer too.
            if (this.subject != null) {
                Integer I,J;
                I = (Integer)subj;
                J = (Integer)this.subject;
                if (!(I.intValue() == J.intValue())) return false;
            }
        } else {
  	  if ( (this.subject != null) && (!(this.subject.equals(subj)))) {
		return false;
	  }
        }
        this.subject = subj;
	return true;
    }

    /**
     * Get the subject of the statement.
     */
    public Object getsubject() { return this.subject; }


    /**
     * Enter the predicate to the statement.  Returns false in the case there exists already a different predicate for this statement.
     */
    public boolean setpredicate(RDF_Property pred) {
	if ( (this.predicate != null) && (!(this.predicate.equals(pred)))) {
		return false;
	} else this.predicate = pred;
	return true;
    }

    /**
     * Get the predicate of the statement.
     */
    public RDF_Property getpredicate() { return this.predicate; }


    /**
     * Enter the object to the statement.  Returns false in the case there exists already a different object for this statement.
     */
    public boolean setobject(Object obj) {
        if (obj instanceof Integer) {
            // We are in a phase where all not resoulved links are done by Integer
            // this means that if there exist already an object it must be an Integer or a Literal.
            if (this.object != null) {
              if (!(this.object instanceof Literal)) {
                Integer I,J;
                I = (Integer)obj;
                J = (Integer)this.object;
                if (!(I.intValue() == J.intValue())) return false;
              }
            }
        } else {
	  if ( (this.object != null) && (!(this.object.equals(obj)))) {
                if ((this.object instanceof Literal) && (obj instanceof Literal)) {
                   Literal l, m;
                   l = (Literal)this.object;
                   m = (Literal)obj;
                   if (l.getvalue().equals(m.getvalue())) return true;
                }
		return false;
	  }
        }
        this.object = obj;
        return true;
    }

    /**
     * Get the object of the statement.
     */
    public Object getobject() { return this.object; }


    /**
     * Returns true if all three (subject, predicate and object) are set (not null).
     */
    public boolean valid() {
	if (this.subject != null && this.predicate != null && this.object != null) return true;
	else {
		// System.out.println(this.subject+", "+this.predicate+", "+this.object);
		return false;
	}
    }

    /**
    * This method is for changing the Integer to links to the real java objects
    * so, we do not need the HashTables any more.
    */
    public void solve_links(Existing existing) {
      // subject and object might be solved
      if (this.subject instanceof Integer) {
        subject = existing.get(((Integer)subject).intValue());
      }
      if (this.object instanceof Integer) {
        object = existing.get(((Integer)object).intValue());
      }
      super.solve_links(existing);
    }

}

