package gr.forth.ics.vrp.corevrp.model;

/**
 *
 * @author Karsten Tolle & Sofia Alexaki
 * @version 2.5  (30 Januar 2003)
 */
public class RDF_MetaClass extends RDF_Class {
	/**
	 * Creates a new MetaClass.
	 */
	public RDF_MetaClass(String URI, int kind) {
		//set metaclass kind
		this.kind = kind;
		setID(URI);
	}

	public RDF_MetaClass(Resource resource, int kind) {
		//set metaclass kind
		this.kind = kind;
		setID(resource.getID());
	}

	public RDF_MetaClass(RDF_Resource rdf_resource, int kind) {
		//set metaclass kind
		this.kind = kind;

		setID(rdf_resource.getID());
		settype(rdf_resource.gettype());
		setcomment(rdf_resource.getcomment());
		setlabel(rdf_resource.getlabel());
		setseeAlso(rdf_resource.getseeAlso());
		 setisDefinedBy(rdf_resource.getisDefinedBy());
		 setvalue(rdf_resource.getvalue());
	}

public RDF_MetaClass(RDF_Class rdf_class, int kind) {
		//set metaclass kind
		this.kind = kind;
		setID(rdf_class.getID());
		settype(rdf_class.gettype());
		setcomment(rdf_class.getcomment());
		setlabel(rdf_class.getlabel());
		setseeAlso(rdf_class.getseeAlso());
		setisDefinedBy(rdf_class.getisDefinedBy());
		setvalue(rdf_class.getvalue());
		setsubClassOf(rdf_class.getsubClassOf());
}

	/**
	 * Shows if the current object is a metaclass of classes, properties.
	 */
	private int kind;

	/**
	 * This flag indicates that the current object is a metaclass of classes
	 */
	public static final int META_CLASS = 0 ;
	/**
	 * This flag indicates that the current object is a metaclass of properties
	 */
	public static final int META_PROPERTY = 1;

	/**
	 * If the object represents a metaclass of classes returns the integer
	 * <RDF_MetaClass.META_CLASS>. Otherwise it returns  the integer
	 * <RDF_MetaClass.META_PROPERTY>
	 */
	public int getKind() {
		return kind;
	}

}