/* This software was developed within the context of the project Metaphor for Science
   Museums (Mesmuses) in the framework of the Information Society Technology
   Programme, part of the Fifth Research And Technological Development
   Framework Programme of the European Community, under the Consortium
   Agreement dated <June 30, 2001>, between INRIA, Finsiel Spa, IMSS,
   Valoris , CSI, ICS-FORTH, ENSTB, EDW International.
*/

// RDF_Container.java


package gr.forth.ics.vrp.corevrp.model;

import java.net.*;
import java.util.*;

/** RDF_Container.java
  *
 * @author Karsten Tolle & Sofia Alexaki
 * @version 2.5  (30 Januar 2003)
  */
public class RDF_Container extends RDF_Resource {

    /**
     * Create a new RDF_Container.
     */
    RDF_Container() { };

    /**
     * Create a new RDF_Container and set the URI.
     */
    RDF_Container(URL theURI) {
	setID(theURI.toString());
    };

    /**
     * Create a new RDF_Container and set the URI.
     */
    RDF_Container(String theURI) {
	setID(theURI);
    };

    /**
     * Cast a Resource to a new RDF_Container.
     */
    RDF_Container(Resource res) {
	setID(res.getID());
    }

    /**
     * Cast a RDF_Resource to a new RDF_Container.
     */
    RDF_Container(RDF_Resource res) {
	setID(res.getID());
  	setcomment(res.getcomment());
	setlabel(res.getlabel());
	setseeAlso(res.getseeAlso());
	setisDefinedBy(res.getisDefinedBy());
	setvalue(res.getvalue());
	settype(res.gettype());
    }

    // Variables
    /** Containing the URIs or Literals of the members of the Container.*/
    private ArrayList member = new ArrayList();

    // Getters and setters
    /**
     * Enter a new member to the member_list.
     */
    public void addmember(Object mem) {
	// We do not know if the Container is a Bag, Set or Alt
	// at this position.
	// The members comming from the parser are in
	// the oposite order. So, we need to enter the
	// mem at the beginning.
	member.add(0, mem);
    }

    /**
     * Get the members.
     */
    public ArrayList getmember() { return member; }

    /**
    * This method is for changing the Integer to links to the real java objects
    * so, we do not need the HashTables any more.
    */
    public void solve_links(Existing existing) {
     ArrayList al = new ArrayList();
     for (Iterator i = this.member.iterator(); i.hasNext();){
          Object o = i.next();
          if (o instanceof Integer) {
            Object obj = existing.get(((Integer)o).intValue());
            al.add(obj);
          } else al.add(o);
        }
      this.member = al;
      super.solve_links(existing);
     }

}

