/* This software was developed within the context of the project Metaphor for Science
	Museums (Mesmuses) in the framework of the Information Society Technology
	Programme, part of the Fifth Research And Technological Development
	Framework Programme of the European Community, under the Consortium
	Agreement dated <June 30, 2001>, between INRIA, Finsiel Spa, IMSS,
	Valoris , CSI, ICS-FORTH, ENSTB, EDW International.
*/

// RDF_Class.java

package gr.forth.ics.vrp.corevrp.model;

import java.util.*;
import java.net.*;



/** RDF_Class.java
  *
 * @author Karsten Tolle & Sofia Alexaki
 * @version 2.5  (30 Januar 2003)
  */
public class RDF_Class extends RDF_Resource {

    /**
     * Create a new RDF_Class.
     */
    public RDF_Class() { };

    /**
     * Create a new RDF_Class and set the URI.
     */
    RDF_Class(URL theURI) {
	setID(theURI.toString());
    };
    /**
     * Create a new RDF_Class and set the URI.
     */
   public RDF_Class(String theURI) {
    	setID(theURI);
    };

    /**
     * Cast the Resource to RDF_Class
     * by creating a new RDF_Class.
     */
    public RDF_Class(Resource res) {
	  setID(res.getID());
    }

    /**
     * Cast the RDF_Resource to RDF_Class
     * by creating a new RDF_Class.
     */
   public RDF_Class(RDF_Resource res) {
	   setID(res.getID());
   	 setcomment(res.getcomment());
	   setlabel(res.getlabel());
   	 setseeAlso(res.getseeAlso());
	   setisDefinedBy(res.getisDefinedBy());
     setvalue(res.getvalue());
     settype(res.gettype());
   }

    // Variables
    /**
     * List containing the super classes of the Class.
     */
    private ArrayList subClassOf = new ArrayList();

    // Getters and setters
    /**
     * Enter a subClassOf statement to the class.
     */
    public void addsubClassOf(RDF_Class subCO) { if (! (subClassOf.contains(subCO))) subClassOf.add(subCO); }

    /**
     * Get all subClassOf statements of the class.
     */
    public ArrayList getsubClassOf() { return subClassOf; }

    /**
     * Setting the subclass(es) of the class.
     */
    public void setsubClassOf(ArrayList sub) { this.subClassOf = sub; }

    public boolean containssubClassOf_type(String type) {
        for (int i=0; i<this.subClassOf.size(); ) {
          RDF_Class super_class = (RDF_Class)this.subClassOf.get(i++);
          if (super_class.getID() == type) return true;
        }
        return false;
    }

    public boolean containssubClassOf_type(RDF_Class c) {
        for (int i=0; i<this.subClassOf.size(); ) {
          RDF_Class super_class = (RDF_Class)this.subClassOf.get(i++);
          if (super_class == c) return true;
        }
        return false;
    }

    public boolean has_type(RDF_Class c) {
      if (this.gettype().contains(c)) return true;
      // we might inherit the type
      // first we inherit as a resource
      for (int j=0; j<this.gettype().size(); ) {
        RDF_Class rdf_class = (RDF_Class)this.gettype().get(j++);
        if (rdf_class.inherit_sCO(c)) return true;
      }
      // second we need to check the type definitions of super
      // classes. This differes from the has_type method of just
      // RDF_Resources
      for (Iterator i = this.getsubClassOf().iterator(); i.hasNext();) {
          RDF_Class super_class = (RDF_Class)i.next();
          if (super_class.has_type(c)) return true;
      }
      return false;
    }

    /**
     * Type inherit for instances, e.g.
     *  Resource A has type Class B
     *  Class B is subClassOf Class C
     *  => Resource A inherits the type C
     */
    boolean inherit_sCO(RDF_Class type_class) {
        if (this.containssubClassOf_type(type_class)) return true;
        for (Iterator i = this.getsubClassOf().iterator(); i.hasNext();) {
          RDF_Class super_class = (RDF_Class)i.next();
          if (super_class.inherit_sCO(type_class)) return true;
        } // end for
      return false;
    }
}
