package gr.forth.ics.vrp.corevrp.model;

import java.util.*;

/**
 * @author Karsten Tolle & Sofia Alexaki
 * @version 2.5  (30 Januar 2003)
 */
public class Namespace {
	/**
	 * The uri of the namespace
	 */
	private String uri;

	/**
	 * Contains the names that are defined in the namespace
	 */
	private HashSet names = new HashSet();

  /**
	* Create a namespace
	*/
	public Namespace(String uri) {
		this.uri = uri;
	}

	/**
	 * Returns the URI of the namespace
	 */
	public String getURI() {
		return uri;
	}

	/**
	 * Test if the resource <res> is defined in the NS
	 */
	public boolean contains(Resource res) {
		if (names.contains(res) ) {
			return true;
		}
		return false;
	}

		/**
	 * Test if the resource <res> is defined in the NS
	 */
	public void addName(Resource res) {
		names.add(res);
	}

	public HashSet getNames() {
		return names;
	}

	/**
	 *Indicates if the resource is defined in one of the selected namespace(s).
	 *param res The resource reference
	 *@selectedNS A hashset containing the selected namespaces
	 *@return True if the resource <res> is defined in one of the selected
	 *namespace(s), false otherwise.
	 */
	public static boolean isDefinedINNamespace(Resource res, HashSet selectedNS) {
		for (Iterator it = selectedNS.iterator(); it.hasNext(); ){
			Namespace ns = (Namespace)it.next();
			if ( ns.contains(res) ) {
				return true;
			}
		}
		return false;
	}

}
