 /* This software was developed within the context of the project Metaphor for Science
   Museums (Mesmuses) in the framework of the Information Society Technology
   Programme, part of the Fifth Research And Technological Development
   Framework Programme of the European Community, under the Consortium
   Agreement dated <June 30, 2001>, between INRIA, Finsiel Spa, IMSS,
   Valoris , CSI, ICS-FORTH, ENSTB, EDW International.
*/


package gr.forth.ics.vrp.corevrp.model;

/**
 * Title:        RDF Literals for VRP
 * Description:  Representing Literals inside the RDF model generated by VRP. A literal as specified in
 * @author Karsten Tolle & Sofia Alexaki
 * @version 2.5  (30 Januar 2003)
 */

 /*
 *  CHANGE LOG:
 *  Each entry starts with a date, who did the changed and what has been done.
 *  Separated by ':'.
 *
 *  03.12.2002 : Karsten Tolle : Added the type and language fields to Literals.
 *                               Also added the toString method for printing the
 *                               Literal.
 *  30.12.2002 : Karsten Tolle : Added the compare method for Literals.
 */
public class Literal {

  /** The default constructor. */
  public Literal() {}
  /** The constructor already sets the value, type and language of the Literal. */
  public Literal(String s) {
      // the language and the data type are not specified at the moment
      setvalue(s);
  }
  public Literal(String val, String lan, String typ) {
      setvalue(val);
      setlang(lan);
      settype(typ);
  }

  private String value;
  private String lang;
  private String type;

  public String getvalue() {
    if (value == null) return "";
    return value;
  }
  public void setvalue(String s) { this.value = s; }

  public String getlang() {
    if (lang == null) return "";
    return lang;
  }
  public void setlang(String s) { this.lang = s; }

  public String gettype() {
    if (type == null) return "";
    return type;
  }
  public void settype(String s) { this.type = s; }

  public String toString() {
    if (this.getlang().equals("")) { // no language defined
          if (this.gettype().equals("")) return "\""+this.value+"\"";
          return "\""+this.value+"\""+"^^<"+this.type+">";
    } else { // language defined
          if (this.gettype().equals("")) return "\""+this.value+"\""+"@"+this.getlang();
          return "\""+this.value+"\""+"@"+this.getlang()+"^^<"+this.type+">";
    }
  }

  public boolean equals(Literal l) {
      if (l.getvalue().equals(this.getvalue())
          && l.getlang().equals(this.getlang())
          && l.gettype().equals(this.gettype()) ) return true;
      return false;
  }

}