/*
 *  CHANGE LOG:
 *  Each entry starts with a date, who did the changed and what has been done.
 *  Separated by ':'.
 *
 *  02.07.2002 : Karsten Tolle : Generated this interface.
 */


package gr.forth.ics.vrp.corevrp.model;

/**
 * <p>berschrift: VRP</p>
 * <p>Beschreibung: Validating RDF Parser</p>
 * <p>Copyright: Copyright (c) 1999</p>
 * <p>Organisation: University of Crete & University of Frankfurt</p>
 * @author Karsten Tolle & Sofia Alexaki
 * @version 2.5  (30 Januar 2003)
 */

import java.util.*;
import gr.forth.ics.vrp.corevrp.parser.*;


public interface IModel {

  /**
   *  Indicates whether messages about the actions performed by the VRP will be reported.
   */
     void setverbose(boolean b);
     boolean getverbose();

   /**
    * Returns a HashMap. The key of hashmap is the URIs of the resource.
    * The value is the respective VRP object (RDF_Class, RDF_Property,
    * RDF_Container, RDF_Statement, RDF_Resource and Resource) created for the resource
    */
     //HashMap getexisting();

    /** To enter a statement with a literal or a string representing the
     *  resource uri of the object.
     */
     void addStatement(String pred, String subj, Object obj);

     /**
     * Returning a Collection containing all the values of the existing HashMap.
     */
     Collection getNodes();

     /**
     * Returns a boolean weather the resource having the specified URI is contained by the model.
     */
     boolean contains(String URI);

     /**
     * Returns the resource with the specified URI.
     */
     Resource getResource(String URI);

     /**
     * Returning a Collection of all classes contained by the model.
     */
     Collection getClasses();

     /**
     * Returning a Collection of all properties contained by the model.
     */
     Collection getProperties();

     /**
     * Returning a Collection of all reified statements contained in the model.
     */
     Collection getReifiedStatements();

    /**
    * Returning a Collection of all RDF containers contained in the model.
    */
    Collection getContainers();

    /**
     *  Returns a Collection of all resources that don't belong
     *  to the basic RDF types i.e., rdfs:Class, rdf:Property, rdf:Container and
     *  rdf:Statement.
     */
     Collection getDataResources();

     /**
     * Returning a boolean whether the statement contained by the model.
     */
     boolean contains(String pred, String sub, String obj);

     /**
     * Returning a boolean whether the statement contained by the model.
     */
     boolean contains(String pred, String sub, Literal obj);

     /**
     * Will be called by the parser if he reached the EOF of the current file. The explicit stated namespaces are inside the Array List.
     * The idea is to include everything in advance and do not allow to fetch during validation to provide a determinitic result of the
     * validator.
     */
     void fetch_all(ArrayList ex_ns, parser par);

     /**
     * Try to get all information of RDF_Properties and RDF_Classes
     * we entered to the Model.
     */
     void fetch();

     /**
     * In the case the URI belongs to a namespace, we try to get the information
     * about URI and enter them to our basis_model.
     * Moved from Validator to the Model 03. Aug. 2001 by KT
     */
     void fetch(String URI);

     /**
     * To infer the type of the given classname for all instances of its subclasses (recursive).
     * Will be used as an optional feature, at the beginning only for rdfs:Class and
     * rdf:Property only.
     */
     void infer();

     /**
     * Returns the statements comprising the model.
     */
     ArrayList getStatements();

     /**
     * Prints the statements of this model.
     */
     int printStatements();

     int[] getStatistics();

      /** Prints the statistic containing the number of triples, classes, properties, containers, refeid statements and resources to the
      *  output stream declared in Output.
      */
      void printStatistics();

      /** Whenever a system-generated identifier is needed for
      * statements or nodes.
      * (Should this generate a URI instead? Right now you can
      * use the getBaseURI() and combine it with the generated
      * System ID to get a URI for some internal model resources).
      */
      String genSysID();

      /** Set the base URI for the model. */
      void setBaseURI(String bURI);

      /** Get the base URI for the model. */
      String getBaseURI();

      /** Dump the content of the model and print it to the outputfile
      * defined in RDF_PAV/Main.
      */
      void dump();
}