package gr.forth.ics.vrp.corevrp.model;

import gr.forth.ics.vrp.corevrp.vocabulary.*;
import java.util.*;

/**
 * @author Karsten Tolle & Sofia Alexaki
 * @version 2.5  (30 Januar 2003)
 */

public class Existing {
  int count = 0;
  int cap = 10000;
  HashMap URL_map = new HashMap(cap);
  ArrayList values = new ArrayList(cap);

  public Existing(boolean init) {
	 // init inserts some needed resources form the rdf and rdfs namespace
	 // into the datasructure.
	 if (init) {
		 this.init();
	 }
  }

  private void init() {
    // insert the classes of rdf and rdfschema
		RDF_Class c = new RDF_Class(rdf.Alt);
      this.put(rdf.Alt, c);
      this.put(rdf.Seq, new RDF_Class(rdf.Seq));
      this.put(rdf.Bag, new RDF_Class(rdf.Bag));
      this.put(rdf.Property, new RDF_Class(rdf.Property));
      this.put(rdf.Statement, new RDF_Class(rdf.Statement));
      this.put(rdfschema.Class, new RDF_Class(rdfschema.Class));
      this.put(rdfschema.ConstraintResource, new RDF_Class(rdfschema.ConstraintResource));
      this.put(rdfschema.ConstraintProperty, new RDF_Class(rdfschema.ConstraintProperty));
      this.put(rdfschema.Container, new RDF_Class(rdfschema.Container));
      this.put(rdfschema.ContainerMembershipProperty, new RDF_Class(rdfschema.ContainerMembershipProperty));
      this.put(rdfschema.Literal, new RDF_Class(rdfschema.Literal));
      this.put(rdfschema.Resource, new RDF_Class(rdfschema.Resource));
  }

  // need to implement
  // get, put, values, containsKey, size

  public Object get(String url) {
      Object o = URL_map.get(url);
      if (o == null) return o;
      Integer Int = (Integer)o;
      return values.get(Int.intValue());
  }

  public int get_int(String url) {
		Object o = URL_map.get(url);
		if (o == null) return -1;
		Integer Int = (Integer)o;
		return Int.intValue();
  }

  public Object get(int i) {
		return values.get(i);
  }

  public String get_url(int i) {
		Resource r = (Resource)this.get(i);
		return r.getID();
  }

  public int put(String url, Object obj) {
		Object o = URL_map.get(url);
		Integer I = null;
		if (o == null) { // entering a new object
		  I = new Integer(count);
		  URL_map.put(url,I);
		  values.add(count,obj);
		  count++;
		} else {
		  I = (Integer)o;
		  values.set(I.intValue(),obj);
		}
		return I.intValue();
  }

  public Collection values() {
	 return values;
  }

  public boolean containsKey(String url) {
	 return URL_map.containsKey(url);
  }

  public int size() {
	 return URL_map.size();
  }

	/**
	 * Modify the URI of an object in the HashMap.
	 *@oldURI the old URI of the object
	 *@URI The new URI of the object
	 */
	public void changesKey(String oldURI, String URI) {
		int count = get_int(oldURI);
		if ( count != -1) {
			Integer I = new Integer(count);
			URL_map.put(URI, I);
		}
	}
}
