/* This software was developed within the context of the project Metaphor for Science
   Museums (Mesmuses) in the framework of the Information Society Technology
   Programme, part of the Fifth Research And Technological Development
   Framework Programme of the European Community, under the Consortium
   Agreement dated <June 30, 2001>, between INRIA, Finsiel Spa, IMSS,
   Valoris , CSI, ICS-FORTH, ENSTB, EDW International.
*/

/*
 *  CHANGE LOG:
 *  Each entry starts with a date, who did the changed and what has been done.
 *  Separated by ':'.
 *
 *  01.03.2002 : Karsten Tolle : Updated error message 2004 (removed aboutEach, aboutEachPrefix) and entered a
 *                               a new error message 2011 in case the attributes occur.
 *  16.12.2002 : Karsten Tolle : Added 2.12 URI check.
 *  29.01.2003 : Karsten Tolle : Added 2.13 Namespace prefix rdf and xml not allowed.
 *  31.01.2003 : Karsten Tolle : Added 3.100 for rdf:_nnn.
 *
 */


// RDF_Error.java

package gr.forth.ics.vrp.corevrp;

/**
 * RDF_Error.java - Containing all error messages.
 *
 * @author Karsten Tolle & Sofia Alexaki
 * @version 2.5  (31 Januar 2003)
 */
public class RDF_Error extends Exception{

	/** Create a new RDF_Error.*/
	public RDF_Error() {  }

	private Output put = new Output();

	public void out(String txt) {
			put.outln(txt, false);
	}

	/** This method is called whenever an error is found. */
	public void emit_error(int kind, int number, String message, String by) {
		Main.error_counter++;
		if (Main.getnoerrormsg()) return;
		out(get_text(kind, number));
		if (kind != 1) {
			if (!(message.equals("")))
            out("\t"+message);
			out("\tError called by: "+by);
		 	if (Main.p_all != null)
            Main.p_all.report_error("", null);
		} else {
			out("\tError called by: "+by);
			if (!(message.equals(""))) out("\t"+message);
		}
	}

	/** This method is called whenever a warning is found. */
	public void emit_warning(String message, String by) {
		Main.warning_counter++;
		if (Main.getnoerrormsg()) return;
		String submessage;
		int size = 60;
		out("\nWarning!: ");
		while (message.length() > size) {
			submessage = message.substring(0, size);
			message = message.substring(size);
			out("\t"+submessage);
		}
		if (!(message.equals(""))) out("\t"+message);
		out("\tWarning called by: "+by+"\n");
	}


	/** Contains the collection of all error messages. Sorted by the kinds
	 * (0) Lexical error, (1) Syntax error, (2) Semantic/Syntax error,
	 * (3) Semantic error and (4) System error.
	 */
	private String get_text(int kind, int number) {
	  // out("in get_text");
	  StringBuffer m = new StringBuffer("");
	  switch(kind) {
      case 0: {
		    m.append("Lexical error \n");
		    if (number > 9) m.append("\t00"+number+": ");
		    else m.append("\t000"+number+": Illegal character(s)\n\t");
		    switch(number) {
			    case 0: m.append("A valid XML, RDF or HTML statement expected."); break;
			    case 1: m.append("A qualified name expected ([NSprefix:]QName). \n\tSee http://www.w3.org/TR/1999/REC-xml-names-19990114/ for more info about QName."); break;
    			case 2: m.append("A qualified name expected ([NSprefix:]QName). \n\tSee http://www.w3.org/TR/1999/REC-xml-names-19990114/ for more info about QName."); break;
		    	case 3: m.append("A valid XML Attribute expected."); break;
    			case 4: m.append("A valid RDF element expected."); break;
			    case 5: m.append("A qualified name expected. \n\tSee http://www.w3.org/TR/1999/REC-xml-names-19990114/ for more info about QName."); break;
     			case 6: m.append("A qualified name expected ([NSprefix:]QName). \n\tSee http://www.w3.org/TR/1999/REC-xml-names-19990114/ for more info."); break;
		    	case 7: m.append("A valid XML/RDF Attribute expected."); break;
			case 8: m.append("A qualified name in quotas expected (=\"QName\"). \n\tSee http://www.w3.org/TR/1999/REC-xml-names-19990114/ for more info about QName."); break;
			default: m.append("default"); break;
		   } break; // end switch(number)
	      } // end case 0

		case 1: {
		    m.append("Syntax error \n");
		    if (number > 9) m.append("\t10"+number+": ");
		    else m.append("\t100"+number+": ");
		    switch(number) {
			case 1: m.append("See RDF M&S [6.1]."); break;
			case 2: m.append("Error in a description, compare with [6.3] RDF M&S."); break;
			case 3: m.append("Error in an attributelist."); break;
			case 4: m.append("Error in a propertyele [6.12] RDF M&S."); break;
			case 5: m.append("Error in a sequence, see [6.25] of RDF M&S."); break;
			case 6: m.append("Error in a bag, see [6.26] of RDF M&S."); break;
			case 7: m.append("Error in an alternative, see [6.27] of RDF M&S."); break;
			case 8: m.append("Error in a member, see [6.28]-[6.30] of RDF M&S."); break;
			case 9: m.append("This is not a well-formed XML [6.34] RDF M&S."); break;
			default: m.append("default"); break;
		   } break; // end switch(number)
	      } // end case 1

		case 2: {
		    m.append("Semantic/Syntax error \n");
		    if (number > 9) m.append("\t20"+number+": ");
		    else m.append("\t200"+number+": ");
		    switch(number) {
			case 1: m.append("You are not allowed to enter other attributes than ID-attr at this position."); break;
			case 2: m.append("ID should be unique."); break;
			case 3: m.append("Attribute used twice in a attribute list."); break;
			case 4: m.append("Only one of the attributes rdf:ID, rdf:nodeID or rdf:about are allowed in an attr_list."); break;
			case 6: m.append("You need to specify an alternative"); break;
			case 7: m.append("You can not define the same prefix more than one time."); break;
			case 8: m.append("The prefix of the tag name is not declared."); break;
			case 9: m.append("The start tag does not match end tag."); break;
			case 10: m.append("You are only allowed to enter one of rdf:ID, rdf:nodeID or rdf:resource within one propertyEle."); break;
                        case 11: m.append("The attributes rdf:aboutEach and rdf:aboutEachPrefix have been removed by the RDF WG. The corresponding typedNode therefore will be ignored."); break;
                        case 12: m.append("Not a valid URI!"); break;
                        case 13: m.append("The rdf and XML namespace URL is not allowed as a prefix for other namespaces."); break;
			default: m.append("default"); break;
		   } break; // end switch(number)
	      } // end case 2

	      case 3: {
		  m.append("Semantic error \n");
		    if (number > 9) m.append("\t30"+number+": ");
		    else m.append("\t300"+number+": ");
		  switch(number) {
			case 1: m.append("You are not allowed to change a rdfs:Class to a rdf:Property."); break;
			case 2: m.append("You are not allowed to change a rdfs:Class to a rdf:Statement."); break;
			case 3: m.append("You are not allowed to change a rdfs:Class to a rdf:Container."); break;
			case 4: m.append("You are not allowed to change a rdf:Property to a rdfs:Class."); break;
			case 5: m.append("You are not allowed to change a rdf:Property to a rdf:Statement."); break;
			case 6: m.append("You are not allowed to change a rdf:Property to a rdf:Container."); break;
			case 7: m.append("You are not allowed to change a rdf:Statement to a rdfs:Class."); break;
			case 8: m.append("You are not allowed to change a rdf:Statement to a rdf:Property."); break;
			case 9: m.append("You are not allowed to change a rdf:Statement to a rdf:Container."); break;
			case 10: m.append("You are not allowed to change a rdf:Container to a rdfs:Class."); break;
			case 11: m.append("You are not allowed to change a rdf:Container to a rdf:Property."); break;
			case 12: m.append("You are not allowed to change a rdf:Container to a rdf:Statement."); break;
			case 13: m.append("The rdfs:subPropertyOf is not allowed to use with a class as subject."); break;
			case 14: m.append("The rdfs:subPropertyOf is not allowed to use with a property as object."); break;
			case 15: m.append("The rdfs:range property is not allowed to use with a class as subject."); break;
			case 16: m.append("The rdfs:range property is not allowed to use with a property as object."); break;
			case 17: m.append("The rdfs:domain property is not allowed to use with a class as subject."); break;
			case 18: m.append("The rdfs:domain property is not allowed to use with a property as object."); break;
			case 19: m.append("The object for this triple must be a Literal."); break;
			case 20: m.append("This properties are not allowed to use with a Literal as object."); break;
			case 21: m.append("The object for the property rdf:type can not be a property."); break;
			case 22: m.append("The rdf:type property is not allowed to be used with a Literal as object."); break;
			case 23: m.append("The property of the statement had not been inserted in the model as a property."); break;
			case 24: m.append("Type mismatch, it is not allowed to mix the types: Class, Property and Statement."); break;
			case 25: m.append("The element is not declared in the RDF-Schema namespace."); break;
			case 26: m.append("The element is not declared in the RDF namespace."); break;
			case 27: m.append("The element is not declared in the corresponding namespace."); break;
			case 28: m.append("The Container you are asking for is not a Container."); break;
			case 29: m.append("Loop detected!!"); break;
			case 30: m.append("There is only one range declaration per rdf:Property allowed."); break;
			case 31: m.append("There is only one subject declaration per rdf:Statement allowed."); break;
			case 32: m.append("There is only one predicate declaration per rdf:Statement allowed."); break;
			case 33: m.append("There is only one object declaration per rdf:Statement allowed."); break;
			case 34: m.append("There need to be for each rdf:Statement exactly one predicate, subject and object."); break;
			case 35: m.append("Where not able to find the type:Statement for this rdf:Statement."); break;
			case 36: m.append("Where not able to find the type:Class for this rdfs:Class."); break;
			case 37: m.append("Where not able to find the type:Property for this rdf:Property."); break;
			case 38: m.append("Where not able to find one of the types:Bag, Seq or Alt for this rdf:Container."); break;
			case 39: m.append("The range definition of the sub property does not fit to the range definition of the super property."); break;
			case 40: m.append("The domain definition of the sub property does not fit to the domain definition of the super property."); break;
			case 41: m.append("Error in range domain check."); break;
			case 42: m.append(""); break;
			case 43: m.append("The namespace does not contain the element you requested."); break;
			case 44: m.append("The range of a property should be unique and defined."); break;
			case 45: m.append("The domain of a property should be defined and unique."); break;
       	                case 46: m.append("Type error."); break;
                        case 100: m.append("For container members the rdf:_nnn property is only allowed for nnn being integers greater 0 with no leading 0."); break;
			default: m.append("default"); break;
		   } break; // end switch(number)
	      } // end case 3

	        case 4: {
		   m.append("System error \n");
		    if (number > 9) m.append("\t40"+number+": ");
		    else m.append("\t400"+number+": ");
		   switch(number) {
			case 1: m.append("Output file does not exists."); break;
			case 2: m.append("Can't read output file."); break;
			case 3: m.append("Can't write to output file."); break;
			case 4: m.append("Error in creation or connection with the output file."); break;
			case 5: m.append("Could not go on parsing or validate."); break;
			case 6: m.append("Could not connect to file."); break;
			case 7: m.append("Invalid option. Valid options are: d, f, g, o, s, t and v."); break;
			case 8: m.append("To many arguments! Run program with no arguments to get the usage-text."); break;
			case 9: m.append("Expected '-' at the beginning of the options."); break;

			default: m.append("default"); break;
		   } break; // end switch(number)
	      } // end case 4
      case 5: {
		     m.append("Schema update error \n");
		    if (number > 9) m.append("\t20"+number+": ");
		    else m.append("\t200"+number+": ");
		    switch(number) {
    			case 1: m.append("Class has been removed from the namespace."); break;
     			case 2: m.append("Property has been removed from the namespace."); break;
     			case 3: m.append("You are not allowed to change a rdfs:Class to a rdf:Property."); break;
     			case 4: m.append("You are not allowed to change a rdf:Property to a rdfs:Class."); break;
     			case 5: m.append("You are not allowed to change the domain of a property."); break;
     			case 6: m.append("You are not allowed to change the range of a property."); break;
    			case 7: m.append("You are not allowed to delete a superlass of a class."); break;
     			case 8: m.append("You are not allowed to add a superlass to a class."); break;
     			case 9: m.append("You are not allowed to delete a superproperty of a property."); break;
    			case 10: m.append("You are not allowed to add a superproperty to a property."); break;
          case 11: m.append("MetaClass has been removed from the namespace."); break;
        	case 12: m.append("You are not allowed to change a rdfs:Class to a MetaProperty."); break;
     			case 13: m.append("You are not allowed to change a rdf:Property to a MetaClass."); break;
     			case 14: m.append("You are not allowed to change a MetaClass to a rdfs:Class."); break;
    			case 15: m.append("You are not allowed to change a MetaClass to a rdf:Property."); break;
          case 16: m.append("You are not allowed to delete an instantiation link between a class and a metaclass."); break;
          case 17: m.append("You are not allowed to add an instantiation link between a class and a metaclass."); break;
          case 18: m.append("You are not allowed to delete an instantiation link between a property and a metaclass."); break;
          case 19: m.append("You are not allowed to add an instantiation link between a property and a metaclass."); break;
          case 20: m.append("You are not allowed to add a new value to the enumeration type used as range of the property:"); break;
          case 21: m.append("You are not allowed to delete a value from an enumeration type used as range of the property:"); break;

		 	default: m.append("default"); break;
		   } break; // end switch(number)
      } // end case 5                                             :w


      case 6: {
		    m.append("Metamodel Semantic error \n");
		    if (number > 9) m.append("\t20"+number+": ");
		    else m.append("\t200"+number+": ");
		    switch(number) {
		    	case 1: m.append("The superclasses of a metaclass should be metaclasses."); break;
          case 2: m.append("A metaclass can only be instance of rdfs:Class."); break;
			 case 3: m.append("A class can only be instance of a metaclass."); break;
			 case 4: m.append("The superclasses of a class should be classes."); break;
			 case 5: m.append("You are not allowed to change an MetaClass to a RDFEnumeration."); break;
        	case 6: m.append("You are not allowed to change an RDF_Property to a RDFEnumeration."); break;
        	case 7: m.append("You are not allowed to change an Thesaurus to a RDFEnumeration."); break;
          case 8: m.append("You are not allowed to change an MetaClass to a Thesaurus."); break;
          case 9: m.append("You are not allowed to change an RDF_Property to a Thesaurus."); break;
        	case 10: m.append("You are not allowed to change an RDFEnumeration to a Thesaurus."); break;
        	case 11: m.append("An enumeration can be instance of only RDFEnumeration."); break;
        	case 12: m.append("A thesaurus can be instance of only Thesaurus."); break;
        	case 13: m.append("A enumeration is not allowed to be assigned superclasses."); break;
        	case 14: m.append("A thesaurus is not allowed to be assigned superclasses."); break;
          case 15: m.append("You are not allowed to change an Thesaurus to an rdfs:Class."); break;
          case 16: m.append("You are not allowed to change an Thesaurus to an rdf:Property."); break;
          case 17: m.append("You are not allowed to change an RDFEnumeration to an rdfs:Class."); break;
          case 18: m.append("You are not allowed to change an RDFEnumeration to an rdf:Property."); break;
          case 19: m.append("You are not allowed to change an MetaClass to an rdfs:Class."); break;
          case 20: m.append("You are not allowed to change an MetaClass to a rdf:Property."); break;
          case 21: m.append("You are not allowed to classify a resource both as data and schema."); break;

        	default: m.append("default"); break;
		    } break; // end switch(number)
	    } // end case 6

   	} // end switch(kind)
	  // out("out get_text");
	  return m.toString();
  } // end get_text
}
