/* This software was developed within the context of the project Metaphor for Science
   Museums (Mesmuses) in the framework of the Information Society Technology
   Programme, part of the Fifth Research And Technological Development
   Framework Programme of the European Community, under the Consortium
   Agreement dated <June 30, 2001>, between INRIA, Finsiel Spa, IMSS,
   Valoris , CSI, ICS-FORTH, ENSTB, EDW International.
*/
 // Output.java

 /*
 *  CHANGE LOG:
 *  Each entry starts with a date, who did the changed and what has been done.
 *  Separated by ':'.
 *
 *  24.07.2003 : Karsten Tolle : Added the possibility to specify an OutputStream for the output.
 */

package gr.forth.ics.vrp.corevrp;

import java.io.*;

/**
 * Output.java - Writing to the output file.
 *
 * @author Karsten Tolle & Sofia Alexaki
 * @version 2.5  (30 Januar 2003)
 */

public class Output {

 /**
 * In case the GUI is not used this OutputStreamWriter can be setted via the set_OS
 * method to direct the output. Default is System.out.
 */
 private static OutputStreamWriter osw = new OutputStreamWriter(System.out);


 /**
  * For redirecting the output in case the GUI is not used.
  * @param os The OutputStream that is going to be used, default is System.out.
  */
 public static void set_OS(OutputStream os) {
    osw = new OutputStreamWriter(os);
 }

 public void outln(String s) {
  outln(s, false);
 }


  /** Printing the String <s> to the OutputFile specified in 'Main.java'.*/
  public void outln(String s, boolean isRes) {
    RDF_Error e = new RDF_Error();
	// Output to sandard IO
//  	if (Main.OutputFile == null && Main.gui == null && Main.storageGUI == null ) {
	if (Main.getOutputFile() == null && Main.gui == null ) {
                  try {
                    osw.write(s+"\n");
                    osw.flush();
                  } catch(Exception ex) {
                    e.emit_error(4, 4, ex.toString(), "Output.out");
                  }
		 return;
	}
	else if (! (Main.getOutputFile() == null)) {
 		PrintWriter pw = null;
		try {
			File f = new File(Main.getOutputFile());
			FileWriter fw = new FileWriter(Main.getOutputFile(), true);
			if (!f.exists() || !f.canRead()) 	e.emit_error(4, 1, f.toString(), "Output.out");
			if (!f.canWrite()) e.emit_error(4, 3, f.toString(), "Output.out");
			pw = new PrintWriter(fw);
			pw.println(s);
		} catch (IOException ex) {
			e.emit_error(4, 4, ex.toString(), "Output.out");
		} finally {
			if (pw != null) pw.close();
		}
	}
	if (! (Main.gui == null)) {
		Main.gui.outln(s, isRes);
	}
  }

 public void out(String s) {
  out(s, false);
 }



   public void out(String s, boolean isRes) {

    RDF_Error e = new RDF_Error();
	// Output to sandard IO
//  	if (Main.OutputFile == null && Main.gui == null && Main.storageGUI == null) {
	if (Main.getOutputFile() == null && Main.gui == null ) {
                  try {
                    osw.write(s);
                    osw.flush();
                  } catch(Exception ex) {
                    e.emit_error(4, 4, ex.toString(), "Output.out");
                  }
		 return;
	}
	else if (!(Main.getOutputFile() == null)) {
 		PrintWriter pw = null;
		try {
			File f = new File(Main.getOutputFile());
			FileWriter fw = new FileWriter(Main.getOutputFile(), true);
			if (!f.exists() || !f.canRead()) 	e.emit_error(4, 1, f.toString(), "Output.out");
			if (!f.canWrite()) e.emit_error(4, 3, f.toString(), "Output.out");
			pw = new PrintWriter(fw);
			pw.print(s);
		} catch (IOException ex) {
			e.emit_error(4, 4, ex.toString(), "Output.out");
		} finally {
			if (pw != null) pw.close();
		}
	}
	if (! (Main.gui == null)) {
		Main.gui.out(s, isRes);
	}
  }
}
