REM This makefile generates the VRP lexer and parser modules 
REM i.e., parser.java, sym.java, Lexer.java and Lexer_simple.java
REM and compiles the VRP packages

REM Please adjust the paths CUP_HOME, JFLEX_HOME, VRP_HOME and JAVA_HOME to suit your needs
REM (please do not add a trailing backslash)

REM The path for VRP.
set VRP_HOME=D:\tmp_local_users\alexaki\RDF_VRP2_5

REM The path for CUP.
set CUP_HOME=%VRP_HOME%\jars\java_cup.jar

REM The path for JFlex.
set JFLEX_HOME=%VRP_HOME%\jars\JFlex.jar

set JAVA_HOME=C:\j2sdk1.4.1_01\bin

REM For generating the parser.java and sym.java files by running CUP.
REM The new files will be written to the subdirectory src\gr\forth\ics\vrp\corevrp\parser 
REM of VRP_HOME.

cd %VRP_HOME%\src\gr\forth\ics\vrp\corevrp\parser
%JAVA_HOME%\java -cp %CUP_HOME% java_cup.Main <%VRP_HOME%\src\gr\forth\ics\vrp\corevrp\Cup_JFlex\parser.cup
cd %VRP_HOME%

REM For generating the Lexer.java file by running JFlex.
REM The new file will be written to the subdirectory src\gr\forth\ics\vrp\corevrp\parser
REM of VRP_HOME.
%JAVA_HOME%\java -jar %JFLEX_HOME% -d %VRP_HOME%\src\gr\forth\ics\vrp\corevrp\parser %VRP_HOME%\src\gr\forth\ics\vrp\corevrp\Cup_JFlex\lexer.jflex

REM For generating the simple lexer Lexer_simple.java file by running JFlex.
REM The new file will be written to the subdirectory src\gr\forth\ics\vrp\corevrp\parser
REM of VRP_HOME.
%JAVA_HOME%\java -jar %JFLEX_HOME% -d %VRP_HOME%\src\gr\forth\ics\vrp\corevrp\parser %VRP_HOME%\src\gr\forth\ics\vrp\corevrp\Cup_JFlex\lexer_simple.jflex

set CLASSPATHCP=%CLASSPATH%;%VRP_HOME%\jars\vrp2.5.jar;%VRP_HOME%\jars\java_cup.jar;%VRP_HOME%\jars\xsdlib.jar;%VRP_HOME%\jars\relaxngDatatype.jar

REM Compiling the packages.
cd %VRP_HOME%\src
%JAVA_HOME%\javac -classpath %CLASSPATHCP% -d %VRP_HOME%\classes gr\forth\ics\vrp\corevrp\*.java
%JAVA_HOME%\javac -classpath %CLASSPATHCP% -d %VRP_HOME%\classes gr\forth\ics\vrp\corevrp\model\*.java
%JAVA_HOME%\javac -classpath %CLASSPATHCP% -d %VRP_HOME%\classes gr\forth\ics\vrp\corevrp\parser\*.java
%JAVA_HOME%\javac -classpath %CLASSPATHCP% -d %VRP_HOME%\classes gr\forth\ics\vrp\corevrp\validator\*.java
%JAVA_HOME%\javac -classpath %CLASSPATHCP% -d %VRP_HOME%\classes gr\forth\ics\vrp\corevrp\vocabulary\*.java

%JAVA_HOME%\javac -classpath %CLASSPATHCP% -d %VRP_HOME%\classes gr\forth\ics\vrp\corevrp\broker\*.java
%JAVA_HOME%\javac -classpath %CLASSPATHCP% -d %VRP_HOME%\classes gr\forth\ics\vrp\visualization\*.java

%JAVA_HOME%\javac -classpath %CLASSPATHCP% -d %VRP_HOME%\classes gr\forth\ics\vrp\statistics\*.java
%JAVA_HOME%\javac -classpath %CLASSPATHCP% -d %VRP_HOME%\classes gr\forth\ics\vrp\vrpgui\*.java