package eworks.RQL.model;

import eworks.RDF.model.*;
import eworks.RQL.engine.SymbolTable;
import eworks.RQL.engine.VariableNotBoundException;

/**
 * <p>An abstract base class for classes that represent RQL variables.</p>
 * 
 * @author Fabian Wleklinski (<a href="mailto:fabian@wleklinski.de">fabian@wleklinski.de</a>)
 * @version 1.00 (2003-11-03)
 */
public abstract class Variable extends Value {

	private String variable;

	/**
	 * Constructs a new RQL variable with a certain name.
	 * @param variable The variable's name.
	 */
	public Variable( String variable ) {
		super();
		this.variable=variable;
	}
	
	/**
	 * Returns the variable's name.
	 * @return The variable's name.
	 */
	public String getName() {
		return this.variable;
	}

	/**
	 * Returns the variable's value, using a certain symbol table.
	 * @param symbols The symbol table to look up the variable's value.
	 * @throws VariableNotBoundException if this variable cannot be found
	 *         inside the given symbol table.
	 * @return The variable's value.
	 */
	public LiteralValue getValue( SymbolTable symbols ) throws VariableNotBoundException {
		return symbols.get(this.variable);
	}
	
	/**
	 * Returns this variable's string representation, that it's name.
	 * @return This variable's string representation.
	 */
	public String toString() {
		return this.variable;
	}
}
