package eworks.RQL.model;

/**
 * <p>Represents a single component of a <code>ProjectionList</code>, that is a
 * certain variable which is part of a query's result (other variables may be bound
 * as well, but will not be returned as the query's result). This aspect and
 * terminology is copied from database query languages like SQL.</p>
 * 
 * @author Fabian Wleklinski (<a href="mailto:fabian@wleklinski.de">fabian@wleklinski.de</a>)
 * @version 1.00 (2003-11-03)
 * @see ProjectionList
 * @see <a href="http://139.91.183.30:9090/RDF/RQL/" target="_blank">
 *      The RDF Query Language (RQL)</a>
 */
public class Projection {
	private Variable variable;
	
	/**
	 * Creates a new projection with a certain variable to encapsulate.
	 * 
	 * @param variable The variable to encapsulate.
	 */
	public Projection( Variable variable ) {
		this.variable = variable;		
	}
	
	/**
	 * Returns this projection's encapsulated variable.
	 * 
	 * @return This projection's encapsulated variable.
	 */
	public Variable getVariable() {
		return this.variable;
	}
	
	/**
	 * Returns this projection's string representation.
	 * 
	 * @return This projection's string representation.
	 */
	public String toString() {
		return "Projection[" + this.variable.toString() + "]";
	}
}
