package eworks.RQL.model;

import eworks.RDF.model.*;

/**
 * <p>Represents a compare operator that compares two values for equality.</p>
 * 
 * @author Fabian Wleklinski (<a href="mailto:fabian@wleklinski.de">fabian@wleklinski.de</a>)
 * @version 1.00 (2003-11-03)
 * @see <a href="http://139.91.183.30:9090/RDF/RQL/" target="_blank">
 *      The RDF Query Language (RQL)</a>
 */
public class EqualityCompareOperator extends CompareOperator {
	/**
	 * Compares two given values for equality.
	 * @param op1 The first value to compare.
	 * @param op2 The second value to compare.
	 */
	public boolean compare(LiteralValue op1, LiteralValue op2) {
		return op1.equals(op2);
	}
	
	/**
	 * Returns this object's string representation, always &quot;=&quot;.
	 */
	public String toString() {
		return "=";
	}
}
