package eworks.RQL.model;

/**
 * <p>Represents an RQL &quot;data variable&quot;, that is a variable that can
 * only contain instances of &quot;RDFS classes&quot; (but no instances of
 * &quot;RDFS meta-classes&quot; or the classes or meta-classes itself).</p>
 * 
 * @author Fabian Wleklinski (<a href="mailto:fabian@wleklinski.de">fabian@wleklinski.de</a>)
 * @version 1.00 (2003-11-03)
 * @see <a href="http://139.91.183.30:9090/RDF/RQL/" target="_blank">
 *      The RDF Query Language (RQL)</a>
 */
public class DataVariable extends Variable {

	/**
	 * Create a new RQL &quot;data variable&quot; with a certain name.
	 * 
	 * @param variable The variable's name.
	 */
	public DataVariable(String variable) {
		super(variable);
	}

}
