package eworks.RQL.model;

import eworks.RQL.engine.VariableNotBoundException;

/**
 * <p>An abstract base class for classes that represent conditions for comparing
 * two values against each other.
 * 
 * @author Fabian Wleklinski (<a href="mailto:fabian@wleklinski.de">fabian@wleklinski.de</a>)
 * @version 1.00 (2003-11-03)
 * @see <a href="http://139.91.183.30:9090/RDF/RQL/" target="_blank">
 *      The RDF Query Language (RQL)</a>
 */
public abstract class Condition {
	
	/**
	 * Creates a new condition.
	 */
	protected Condition() {
	}

	/**
	 * Returns this condition's string representation, that is this
	 * class it's name (without the package name). 
	 * 
	 * @return This condition's string representation.
	 */
	public String toString() {
		return this.getClass().getName().substring(
			this.getClass().getName().lastIndexOf('.')+1);
	}
	
	/**
	 * Returns a compacted copy of this condition, which is the condition
	 * itself by default, but may be overwritten in derived classes.
	 * 
	 * @return A compacted copy of this condition.
	 */
	public Condition compact() {
		return this;
	}
	
	/**
	 * Checks if this condition is satisfied using a certain symbol table.
	 * 
	 * @param symbols The symbol table to use.
	 * @return <code>true</code> if this condition is satisfied,
	 *         <code>false</code> else.
	 * @throws VariableNotBoundException if one or several needed values of this
	 *         condition's values are not bound by the given symbol table.
	 */
	public abstract boolean matches(eworks.RQL.engine.SymbolTable symbols) throws VariableNotBoundException;
}