package eworks.RQL.model;

import eworks.RDF.model.*;

/**
 * <p>An abstract base class for compare operators.</p>
 * 
 * @author Fabian Wleklinski (<a href="mailto:fabian@wleklinski.de">fabian@wleklinski.de</a>)
 * @version 1.00 (2003-11-03)
 * @see <a href="http://139.91.183.30:9090/RDF/RQL/" target="_blank">
 *      The RDF Query Language (RQL)</a>
 */
public abstract class CompareOperator {

	/**
	 * The only existing instance of <code>EqualityCompareOperator</code>
	 * (singleton-pattern).
	 */
	public static EqualityCompareOperator Equality;

	/**
	 * The only existing instance of <code>AlikenessCompareOperator</code>
	 * (singleton-pattern).
	 */
	public static AlikenessCompareOperator Alikeness;
	
	static {
		Equality = new EqualityCompareOperator();
		Alikeness = new AlikenessCompareOperator();
	}
	
	/**
	 * Abstract method that compares two given values against each other,
	 * each one being an instance of <code>LiteralValue</code>.
	 * 
	 * @param op1 The first operand to compare.
	 * @param op2 The second operand to compare.
	 * @return <code>true</code> if both values match, <code>false</code> else.
	 */
	public abstract boolean compare(LiteralValue op1, LiteralValue op2);
}
