package eworks.RQL.engine;

import eworks.RQL.model.Variable;

/**
 * <p>Indicates that a variable is already bound and is tried to be bound a
 * second time, which is not allowed.</p>
 * 
 * @author Fabian Wleklinski (<a href="mailto:fabian@wleklinski.de">fabian@wleklinski.de</a>)
 * @version 1.00 (2003-11-03)
 */
public class VariableAlreadyBoundException extends Exception {

	private Variable variable;

	/**
	 * Creates a new instance and encapsulates the given variable.
	 * @param variable The variable that is already bound.
	 */
	public VariableAlreadyBoundException( Variable variable ) {
		super();
		this.variable = variable;
	}

	/**
	 * Creates a new instance with the given description.
	 * @param message The exception's description.
	 */
	public VariableAlreadyBoundException(String message) {
		super(message);
	}

	/**
	 * Creates a new instance and encapsulated the given exception as the
	 * exception's cause.
	 * @param cause The exception which has caused the exception.
	 */
	public VariableAlreadyBoundException(Throwable cause) {
		super(cause);
	}

	/**
	 * Creates a new instance and encapsulated the given exception and message
	 * as the exception's cause and description.
	 * @param message The exception's description.
	 * @param cause The exception which has caused the exception.
	 */
	public VariableAlreadyBoundException(String message, Throwable cause) {
		super(message, cause);
	}

}
