package eworks.RQL.engine;

/**
 * <p>Indicates that a query is tried to be evaluated although no data model
 * has been bound, which is not allowed.</p>
 * 
 * @author Fabian Wleklinski (<a href="mailto:fabian@wleklinski.de">fabian@wleklinski.de</a>)
 * @version 1.00 (2003-11-03)
 */
public class NoModelBoundException extends Exception {

	/**
	 * Creates a new instance.
	 */
	public NoModelBoundException() {
		super();
	}

	/**
	 * Creates a new instance with the given description.
	 * @param message The exception's description.
	 */
	public NoModelBoundException(String message) {
		super(message);
	}

	/**
	 * Creates a new instance and encapsulated the given exception as the
	 * exception's cause.
	 * @param cause The exception which has caused the exception.
	 */
	public NoModelBoundException(Throwable cause) {
		super(cause);
	}

	/**
	 * Creates a new instance and encapsulated the given exception and message
	 * as the exception's cause and description.
	 * @param message The exception's description.
	 * @param cause The exception which has caused the exception.
	 */
	public NoModelBoundException(String message, Throwable cause) {
		super(message, cause);
	}
}