package eworks.RDF.model;

import eworks.RQL.engine.SymbolTable;
import eworks.RQL.engine.VariableNotBoundException;

/**
 * <p>Abstract base class for all "values". Values are RDF componentes, that can be
 * evaluated to a single value, example given variables or literals.</p>
 * 
 * @author Fabian Wleklinski (<a href="mailto:fabian@wleklinski.de">fabian@wleklinski.de</a>)
 * @version 1.00 (2003-11-03)
 */
public abstract class Value {

	/**
	 * Creates a new instance.
	 */	
	protected Value() {
	}
	
	/**
	 * Returns this value's literal value, according to a given symbol table.
	 * Derived classes have to implement this method to return a class-specific
	 * evaluated literal.
	 * 
	 * @param symbols The symbol table to use, if a symbol table is needed.
	 * @return This value's literal value.
	 * @throws VariableNotBoundException if a needed variable is not bound inside
	 *         the given symbol table (<code>symbols</code>).
	 */
	public abstract LiteralValue getValue( SymbolTable symbols ) throws VariableNotBoundException;
}