package eworks.RDF.model;

import java.util.Collection;

/**
 * <p>Represents a set of grouped tuples and provides methods to manage them. Each
 * tuple is represented by an instance of a class that implements the {@link Tuple}
 * interface.</p>
 * 
 * <p>This implementation supports the grouping of tuples as defined by
 * the methods {@link Tuples#getNumberOfGroups} and {@link Tuples#getTuplesByGroup}.
 * All tuples are contained generally inside the same tuple group.</p>
 *
 * @author Fabian Wleklinski (<a href="mailto:fabian@wleklinski.de">fabian@wleklinski.de</a>)
 * @version 1.00 (2003-11-03)
 */
public class UngroupedTuples extends AbstractTuples {

	/**
	 * Creates a new and empty set of tuples.
	 */
	public UngroupedTuples() {
		super();
	}

	/**
	 * Creates a new and empty set of tuples with a given initial tuple.
	 * 
	 * @param t The initial tuple.
	 */
	public UngroupedTuples(Tuple t) {
		super(t);
	}

	/**
	 * Creates a new and empty set of tuples with a given initial capacity.
	 * 
	 * @param initialCapacity The initial capacity.
	 */
	public UngroupedTuples(int initialCapacity) {
		super(initialCapacity);
	}

	/**
	 * Creates a new set of tuples and initializes it with a given set of tuples.
	 * 
	 * @param c The set of tuples to initialize the new tuple set.
	 */
	public UngroupedTuples(Collection c) {
		super(c);
	}

	/**
	 * Clones this tuple set and returns a new instance containing the same tuples.
	 * 
	 * @return A clone of this tuple set.
	 */	
	public Object clone() {
		return new UngroupedTuples( (Collection) super.clone() );
	}
}