package eworks.RDF.model;

/**
 * <p>Represents the interface of a tuple. A tuple is an ordered  set of componentens
 * (a "list" of components). In this case, it is an ordered set of instances of
 * {@link LiteralValue}. Each of the components can be defined and retrieved by it's
 * numerical index.</p>
 * 
 * <p>This interface extends the {@link Tuples} interface for performance reasons.
 * So every single <code>Tuple</code> instance can be used whereever a
 * <code>Tuples</code> instance is expected. In such cases this tuple is treated as
 * a set of tuples with one only encapsulated tuple. So there is no need to created
 * a seperate <code>tuples</code> instance for this one and only tuple.</p>
 * 
 * @author Fabian Wleklinski (<a href="mailto:fabian@wleklinski.de">fabian@wleklinski.de</a>)
 * @version 1.00 (2003-11-03)
 */
public interface Tuple extends Tuples {
	
	/**
	 * Returns the tuple's component with the given <code>index</code>.
	 * 
	 * @param index The index of the component to return.
	 * @return The tuple's component with the given <code>index</code>.
	 */
	public Value get(int index);

	/**
	 * Sets the tuple's component with the given <code>index</code>
	 * to <code>value</code>.
	 * 
	 * @param index The index of the component to set.
	 * @param value The component's new value.
	 */
	public void set(int index, LiteralValue value);

	/**
	 * Returns the tupel's number of components.
	 * 
	 * @return The tupel's number of components.
	 */	
	public int getSize();

	/**
	 * Checks the tuple for equality with a given object <code>o</code>.
	 * 
	 * @param o The object the tuple to compare to.
	 */
	public boolean equals( Object o );
}
