package eworks.RDF.model;

/**
 * <p>Represents a string literal.</p>
 * 
 * @author Fabian Wleklinski (<a href="mailto:fabian@wleklinski.de">fabian@wleklinski.de</a>)
 * @version 1.00 (2003-11-03)
 */
public class StringLiteralValue extends LiteralValue {

	/**
	 * The encapsulated string.
	 */
	protected String literal; 

	/**
	 * Creates a new instance representing the given string literal.
	 * 
	 * @param literal The string literal to represent.
	 */
	public StringLiteralValue(String literal) {
		super();
		this.literal = literal;
	}

	/**
	 * Returns the literal's string representation, that's the encapsulated string.
	 * 
	 * @return The encapsulated string.
	 */
	public String toString() {
		return this.literal;
	}
}