package eworks.RDF.model;

import java.util.Iterator;

/**
 * <p>An iterator for an instance of {@link StaticCollection}.</p>
 * 
 * @author Fabian Wleklinski (<a href="mailto:fabian@wleklinski.de">fabian@wleklinski.de</a>)
 * @version 1.00 (2003-11-03)
 */
public class StaticCollectionIterator implements Iterator {

	private StaticCollection collection;

	/**
	 * Creates a new iterator for the given <code>collection</code>.
	 * 
	 * @param collection The collection to iterate trough.
	 */
	public StaticCollectionIterator( StaticCollection collection ) {
		super();
		this.collection = collection;
	}

	/**
	 * Do not call this method, as it throws an {@link UnsupportedOperationException}.
	 * This method is implemented due to the contract with {@link Iterator}, but
	 * cannot be applied on instances of this class.
	 * 
	 * @throws UnsupportedOperationException always.
	 */
	public void remove() {
		throw new UnsupportedOperationException();
	}

	/**
	 * Returns <code>true</code> if the iteration has more elements. (In other words,
	 * returns <code>true</code> if {@link #next} would return an element rather than
	 * throwing an exception.)
	 * 
	 * @return <code>true</code> if the iterator has more elements.
	 */
	public boolean hasNext() {
		return this.collection != null;
	}

	/**
	 * Returns the next element in the iteration.
	 * 
	 * @return the next element in the iteration.
	 */
	public Object next() {
		Object result = this.collection;
		this.collection = null;
		return result;
	}
}