package eworks.RDF.model;

import java.util.Collection;
import java.util.Iterator;

/**
 * <p>A specialized collection for collecting all kind of objects.</p>
 * 
 * @author Fabian Wleklinski (<a href="mailto:fabian@wleklinski.de">fabian@wleklinski.de</a>)
 * @version 1.00 (2003-11-03)
 */
public class StaticCollection implements Collection {

	/**
	 * Creates a new and empty collection.
	 */
	public StaticCollection() {
		super();
	}

	/**
	 * Returns the number of elements inside the collection.
	 * 
	 * @return The number of elements inside the collection.
	 */
	public int size() {
		return 1;
	}

	/**
	 * Do not call this method, as it throws an {@link UnsupportedOperationException}.
	 * This method is implemented due to the contract with {@link Collection}, but
	 * cannot be applied on instances of this class.
	 * 
	 * @throws UnsupportedOperationException always.
	 */
	public void clear() {
		throw new UnsupportedOperationException();
	}

	/**
	 * Returns <code>true</code> if and only if this collection does not contain
	 * eny element.
	 * 
	 * @return <code>true</code> if and only if this collection is empty.
	 */
	public boolean isEmpty() {
		return false;
	}

	/**
	 * Converts the collection into an array, containing all elements of this
	 * collection.
	 * 
	 * @return An array containing all elements of the collection.
	 */
	public Object[] toArray() {
		return new Object[]{ this };
	}

	/**
	 * Converts the collection into an array, containing all elements of this
	 * collection. The runtime type of the returned array may be specified by
	 * the given array <code>a</code>, see {@link Collection#toArray(Object[])}.
	 * 
	 * @return An array containing all elements of the collection.
	 */
	public Object[] toArray(Object[] a) {
		if (a.length < 1)
			a = (Object[])java.lang.reflect.Array.newInstance(
				a.getClass().getComponentType(), 1);
		
		a[0] = this;
		return a;
	}

	/**
	 * Do not call this method, as it throws an {@link UnsupportedOperationException}.
	 * This method is implemented due to the contract with {@link Collection}, but
	 * cannot be applied on instances of this class.
	 * 
	 * @throws UnsupportedOperationException always.
	 */
	public boolean add(Object o) {
		throw new UnsupportedOperationException();
	}

	/**
	 * Checks if a given object <code>o</code> exists inside the collection, and
	 * returns <code>true</code> if so, <code>else</code> otherwise.
	 * 
	 * @param o The object to find.
	 * @return <code>true</code> if and only if <code>o</code> exists inside the
	 *         collection.
	 */
	public boolean contains(Object o) {
		return this.equals(o);
	}

	/**
	 * Do not call this method, as it throws an {@link UnsupportedOperationException}.
	 * This method is implemented due to the contract with {@link Collection}, but
	 * cannot be applied on instances of this class.
	 * 
	 * @throws UnsupportedOperationException always.
	 */
	public boolean remove(Object o) {
		throw new UnsupportedOperationException();
	}

	/**
	 * Do not call this method, as it throws an {@link UnsupportedOperationException}.
	 * This method is implemented due to the contract with {@link Collection}, but
	 * cannot be applied on instances of this class.
	 * 
	 * @throws UnsupportedOperationException always.
	 */
	public boolean addAll(Collection c) {
		throw new UnsupportedOperationException();
	}

	/**
	 * Checks for a given collection of objects <code>c</code>, if every contained
	 * object does also exists inside this collection, and returns <code>true</code>
	 * if so, <code>else</code> otherwise.
	 * 
	 * @param c A collection of objects to find.
	 * @return <code>true</code> if and only if all objects contained inside
	 *         <code>c</code> exists inside this collection.
	 */
	public boolean containsAll(Collection c) {
		Iterator i = c.iterator();
		while (i.hasNext())
			if (! this.equals(i.next()))
				return false;
		return true;
	}

	/**
	 * Do not call this method, as it throws an {@link UnsupportedOperationException}.
	 * This method is implemented due to the contract with {@link Collection}, but
	 * cannot be applied on instances of this class.
	 * 
	 * @throws UnsupportedOperationException always.
	 */
	public boolean removeAll(Collection c) {
		throw new UnsupportedOperationException();
	}

	/**
	 * Do not call this method, as it throws an {@link UnsupportedOperationException}.
	 * This method is implemented due to the contract with {@link Collection}, but
	 * cannot be applied on instances of this class.
	 * 
	 * @throws UnsupportedOperationException always.
	 */
	public boolean retainAll(Collection c) {
		throw new UnsupportedOperationException();
	}

	/**
	 * Returns an iterator over the elements in this collection. There are no
	 * guarantees concerning the order in which the elements are returned (unless
	 * this collection is an instance of some class that provides a guarantee).
	 * 
	 * @return an <code>Iterator</code> over the elements inside this collection.
	 */
	public Iterator iterator() {
		return new StaticCollectionIterator(this);
	}
}