package eworks.RDF.model;

import java.util.Collection;

/**
 * <p>Represents a set of grouped tuples and provides methods to manage them. Each
 * tuple is represented by an instance of a class that implements the {@link Tuple}
 * interface.</p>
 * 
 * <p>This implementation supports the grouping of tuples as defined by
 * the methods {@link Tuples#getNumberOfGroups} and {@link Tuples#getTuplesByGroup}.
 * Every single tuple is generally contained inside it's own group.</p>
 *
 * @author Fabian Wleklinski (<a href="mailto:fabian@wleklinski.de">fabian@wleklinski.de</a>)
 * @version 1.00 (2003-11-03)
 */
public class SingleGroupedTuples extends AbstractTuples {

	/**
	 * Creates a new and empty set of tuples.
	 */
	public SingleGroupedTuples() {
		super();
	}

	/**
	 * Creates a new and empty set of tuples with a given initial tuple.
	 * 
	 * @param t The initial tuple.
	 */
	public SingleGroupedTuples(Tuple t) {
		super(t);
	}

	/**
	 * Creates a new and empty set of tuples with a given initial capacity.
	 * 
	 * @param initialCapacity The initial capacity.
	 */
	public SingleGroupedTuples(int initialCapacity) {
		super(initialCapacity);
	}

	/**
	 * Creates a new set of tuples and initializes it with a given set of tuples.
	 * 
	 * @param c The set of tuples to initialize the new tuple set.
	 */
	public SingleGroupedTuples(Collection c) {
		super(c);
	}

	/**
	 * Returns the number of tuple groups. That's the number of tuples in this
	 * implementation.
	 * 
	 * @return The number of tuple groups.
	 */
	public int getNumberOfGroups() {
		return this.size();
	}
	
	/**
	 * Returns all tuples of a certain tuple groups, that is specified by it's
	 * numerical index. The returned tuples are returned using a class that implements
	 * the {@link Tuples} interface as well.
	 * 
	 * @param groupIndex The group's index.
	 * @return The tuples of the tuple group <code>index</code>.
	 * @throws ArrayIndexOutOfBoundsException if this tuple group does not
	 *         exist, see {@link #getNumberOfGroups()}.
	 */
	public Tuples getTuplesByGroup( int groupIndex ) {
		return this.getTuple(groupIndex);
	}

	/**
	 * Clones this tuple set and returns a new instance containing the same tuples.
	 * 
	 * @return A clone of this tuple set.
	 */	
	public Object clone() {
		return new SingleGroupedTuples( (Collection) super.clone() );
	}
}
