package eworks.RDF.model;

import eworks.RQL.engine.SymbolTable;

/**
 * <p>Abstract base classes for representing literals.</p>
 * 
 * @author Fabian Wleklinski (<a href="mailto:fabian@wleklinski.de">fabian@wleklinski.de</a>)
 * @version 1.00 (2003-11-03)
 */
public abstract class LiteralValue extends Value {

	/**
	 * Creates a new instance.
	 */
	protected LiteralValue() {
	}

	/**
	 * Checks if the literal is equal to a given object. To do so it is checked if the
	 * given object <code>o</code> is an instance of <code>LiteralValue</code>,
	 * too. If so, both literals' string representation are checked for equality
	 * (case sensitive). Otherwise the call is propagated to the inhertied
	 * implementation {@link Value#equals(Object)}.
	 * 
	 * @return <code>true</code> if and only if the literal is equal to <code>o</code>.
	 */
	public boolean equals( Object o ) {
		if (o instanceof LiteralValue) {
			return ((LiteralValue) o).toString().equals(this.toString());
		}
		return super.equals(o);
	}
	
	/**
	 * Returns the literals hash code.
	 * 
	 * @return The literals hash code.
	 */
	public int hashCode() {
		return this.toString().toLowerCase().hashCode();
	}

	/**
	 * Returns the literal value, that's the instance itself.
	 * 
	 * @param symbols The symbol table to use as declared in
	 *        {@link Value#getValue}, but it is not used in this
	 *        implementation.
	 * @return The instance itself.
	 */
	public LiteralValue getValue( SymbolTable symbols ) {
		return this;
	}

	/**
	 * Returns the literal value, that's the instance itself.
	 * 
	 * @return The instance itself.
	 */
	public LiteralValue getValue() {
		return this;
	}
}