package eworks.RQL.parser;
import java_cup.runtime.*;

%%

%class scanner
%cup
%ignorecase
%8bit
%public

%{
  String name;

  StringBuffer string = new StringBuffer();

  static {
  	yycmap['\t'] = yycmap[' '];
  	yycmap[',']  = yycmap[' '];
  	yycmap['=']  = yycmap[' '];
  	yycmap['(']  = yycmap[' '];
  	yycmap[')']  = yycmap[' '];
  	yycmap['{']  = yycmap[' '];
  	yycmap['}']  = yycmap[' '];
  	yycmap['\''] = yycmap[' '];
  	yycmap['\n'] = yycmap[' '];
  }

  private Symbol symbol(int type) {
    return new Symbol(type, yyline, yycolumn);
  }
  private Symbol symbol(int type, Object value) {
    return new Symbol(type, yyline, yycolumn, value);
  }
%}

LineTerminator = \r|\n|\r\n
WhiteSpace     = {LineTerminator} | [ \t\f]

%state STRING

%%

<YYINITIAL> {
	\"				{ string.setLength(0); yybegin(STRING); }
	{WhiteSpace}			{ if (yytext().equals(","))
						return symbol(sym.COMMA);
					  else if (yytext().equals("="))
					  	return symbol(sym.EQUALITYOPERATOR);
					  else if (yytext().equals("("))
					  	return symbol(sym.LBRACKET);
					  else if (yytext().equals(")"))
					  	return symbol(sym.RBRACKET);
					  else if (yytext().equals("{"))
					  	return symbol(sym.LCURLYBRACKET);
					  else if (yytext().equals("}"))
					  	return symbol(sym.RCURLYBRACKET);
					}
	"SELECT"			{ return symbol(sym.SELECT); }
	"DISTINCT"			{ return symbol(sym.DISTINCT); }
	"FROM"				{ return symbol(sym.FROM); }
	"WHERE"				{ return symbol(sym.WHERE); }
	"AND"				{ return symbol(sym.ANDOPERATOR); }
	"OR"				{ return symbol(sym.OROPERATOR); }
	"LIKE"				{ return symbol(sym.LIKEOPERATOR); }
	@[a-zA-Z][a-zA-Z0-9_]*		{ return symbol(sym.AT_IDENTIFIER,yytext()); }
	\$[a-zA-Z][a-zA-Z0-9_]*		{ return symbol(sym.DOLLAR_IDENTIFIER,yytext()); }
	[a-zA-Z][a-zA-Z0-9_]*		{ return symbol(sym.IDENTIFIER,yytext()); }
	&((http|file):\/\/)?[^ \(\)\\{}<>\"]+ { return symbol(sym.URI,yytext().substring(1)); }
	[^ ()\[\]{}<>~\"]+		{ return symbol(sym.STRING,yytext()); }
}

<STRING> {
	\"				{ yybegin(YYINITIAL); 
					  return symbol(sym.STRING, 
					  string.toString()); }
	[^\n\r\"\\]+			{ string.append( yytext() ); }
	\\t				{ string.append('\t'); }
	\\n				{ string.append('\n'); }

	\\r				{ string.append('\r'); }
	\\\"				{ string.append('\"'); }
	\\				{ string.append('\\'); }
}

/* error fallback */
.|\n					{ throw new Error("Illegal character <" + yytext() + ">"); }