/*
 * Decompiled with CFR 0.152.
 */
package gr.forth.ics.vrp.vrpgui;

import gr.forth.ics.vrp.vrpgui.VRPPanel;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;

public class SVGOutputDialog
extends JDialog {
    private JTextField output = new JTextField("output.svg", 20);
    private JButton select_output = new JButton("Browse");
    private JComboBox width = new JComboBox();
    private JComboBox height = new JComboBox();
    protected Container cont;
    protected JButton ok = new JButton("        Ok        ");

    public SVGOutputDialog(JFrame jFrame) {
        super(jFrame, "SVG output option", true);
        JPanel jPanel = new JPanel();
        this.select_output.setBorder(BorderFactory.createBevelBorder(0));
        jPanel.add(this.output);
        jPanel.add(this.select_output);
        jPanel.setBorder(BorderFactory.createTitledBorder("File name"));
        this.width.addItem("800");
        this.width.addItem("1024");
        this.width.addItem("1280");
        this.width.setEditable(true);
        this.width.setSelectedItem("800");
        this.height.addItem("600");
        this.height.addItem("768");
        this.height.addItem("1024");
        this.height.setEditable(true);
        this.height.setSelectedItem("600");
        JPanel jPanel2 = new JPanel();
        jPanel2.add(new JLabel("Width"));
        jPanel2.add(this.width);
        JPanel jPanel3 = new JPanel();
        jPanel3.add(new JLabel("Height"));
        jPanel3.add(this.height);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BoxLayout(jPanel4, 0));
        jPanel4.add(jPanel2);
        jPanel4.add(Box.createRigidArea(new Dimension(15, 0)));
        jPanel4.add(Box.createHorizontalGlue());
        jPanel4.add(jPanel3);
        jPanel4.setBorder(BorderFactory.createTitledBorder("SVG size"));
        this.cont = this.getContentPane();
        this.cont.setLayout(new BoxLayout(this.cont, 1));
        JPanel jPanel5 = new JPanel();
        jPanel5.setAlignmentX(0.0f);
        this.ok.setAlignmentX(0.5f);
        this.ok.setBorder(BorderFactory.createBevelBorder(0));
        jPanel5.add(this.ok);
        this.cont.add(jPanel);
        this.cont.add(jPanel4);
        this.cont.add(jPanel5);
        this.ok.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SVGOutputDialog.this.dispose();
            }
        });
        this.select_output.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SVGOutputDialog.this.select_file();
            }
        });
        this.pack();
    }

    private void select_file() {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setDialogTitle("Select file");
        jFileChooser.setFileFilter(new FileFilter(){

            public boolean accept(File file) {
                if (file != null) {
                    if (file.isDirectory()) {
                        return true;
                    }
                    String string = this.getExtension(file);
                    if (string != null && string.equals("svg")) {
                        return true;
                    }
                }
                return false;
            }

            public String getExtension(File file) {
                String string;
                int n;
                if (file != null && (n = (string = file.getName()).lastIndexOf(46)) > 0 && n < string.length() - 1) {
                    return string.substring(n + 1).toLowerCase();
                }
                return null;
            }

            public String getDescription() {
                return "SVG files (*.svg)";
            }
        });
        int n = jFileChooser.showDialog(this, "Ok");
        if (n == 0) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(jFileChooser.getCurrentDirectory().toString());
            stringBuffer.append(File.separator);
            stringBuffer.append(jFileChooser.getSelectedFile().getName());
            this.output.setText(stringBuffer.toString());
        }
    }

    public void dispose() {
        int n;
        int n2;
        if (this.output.getText().equals("")) {
            this.output.setText("output.svg");
        }
        VRPPanel.main.setsvgoutput(this.output.getText());
        try {
            n2 = Integer.parseInt(this.width.getSelectedItem().toString());
        }
        catch (Exception exception) {
            n2 = 800;
        }
        if (n2 < 600) {
            n2 = 600;
        }
        try {
            n = Integer.parseInt(this.height.getSelectedItem().toString());
        }
        catch (Exception exception) {
            n = 800;
        }
        if (n < 480) {
            n = 480;
        }
        this.width.setSelectedItem(String.valueOf(n2));
        this.height.setSelectedItem(String.valueOf(n));
        VRPPanel.main.setsvgsize(n2, n);
        super.dispose();
    }
}

