/*
 * Decompiled with CFR 0.152.
 */
package gr.forth.ics.vrp.visualization;

import gr.forth.ics.vrp.corevrp.broker.RDF_SemanticBroker;
import gr.forth.ics.vrp.corevrp.model.Link;
import gr.forth.ics.vrp.corevrp.model.Literal;
import gr.forth.ics.vrp.corevrp.model.RDF_Class;
import gr.forth.ics.vrp.corevrp.model.RDF_Container;
import gr.forth.ics.vrp.corevrp.model.RDF_Property;
import gr.forth.ics.vrp.corevrp.model.RDF_Resource;
import gr.forth.ics.vrp.corevrp.model.RDF_Statement;
import gr.forth.ics.vrp.corevrp.model.Resource;
import gr.forth.ics.vrp.visualization.Clipping;
import gr.forth.ics.vrp.visualization.RDF_Visualization;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Point;
import java.awt.Toolkit;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.TreeSet;

public class SVGGenerator
extends RDF_Visualization {
    public static int SVGWidth = 0;
    public static int SVGHeight = 0;
    public static final int MinClassRx = 50;
    public static final int ClassRy = 14;
    public static final int MinResourceWidth = 150;
    public static final int ResourceHeight = 25;
    public static final int MinFocusClassWidth = 150;
    public static final int MinFocusResourceWidth = 200;
    public static final int MinTreeWindowWidth = 150;
    public static int MaxTreeWindowWidth;
    public static int TreeWindowWidth;
    public static int TreeViewWidth;
    public static int TreeWindowHeight;
    public static int TreeViewHeight;
    public static int DesktopWindowWidth;
    public static int DesktopViewWidth;
    public static int DesktopWindowHeight;
    public static int DesktopViewHeight;
    public static final String ClassColor = "cyan";
    public static final String ResourceColor = "lime";
    public static final String PropertyColor = "royalblue";
    public static final String MetaColor = "springgreen";
    public static final String NoneTransitiveProperty = "mediumblue";
    public static final String TransitiveProperty = "magenta";
    public static final String NoneTransitiveClass = "slateblue";
    public static final String TransitiveClass = "hotpink";
    public static final String NoneTransitiveResource = "seagreen";
    public static final String TransitiveResource = "coral";
    ArrayList classList;
    ArrayList resourceList;
    ArrayList propertyList;
    private int path_counter;

    public SVGGenerator(RDF_SemanticBroker rDF_SemanticBroker) {
        super(rDF_SemanticBroker);
        if (SVGWidth == 0 && SVGHeight == 0) {
            SVGGenerator.setSVGSize(800, 600);
        }
        this.classList = new ArrayList(rDF_SemanticBroker.getAllClasses(true));
        if (this.classList.contains("http://www.w3.org/2000/01/rdf-schema#Literal")) {
            System.out.println("CONTAINS");
        } else {
            System.out.println("NOT CONTAINS");
        }
        this.resourceList = new ArrayList(rDF_SemanticBroker.getAllResources(true));
        this.propertyList = new ArrayList(rDF_SemanticBroker.getAllProperties(true));
    }

    public static void setSVGSize(int n, int n2) {
        SVGWidth = n;
        if (SVGWidth < 600) {
            SVGWidth = 600;
        }
        if ((SVGHeight = n2) < 480) {
            SVGHeight = 480;
        }
        MaxTreeWindowWidth = SVGWidth / 4;
        TreeWindowHeight = SVGHeight - 30;
        TreeViewHeight = TreeWindowHeight - 35;
        DesktopWindowHeight = SVGHeight - 30;
        DesktopViewHeight = DesktopWindowHeight - 10;
    }

    public static void setTreeWindowWidth(int n) {
        TreeWindowWidth = n;
        if (TreeWindowWidth > MaxTreeWindowWidth) {
            TreeWindowWidth = MaxTreeWindowWidth;
        }
        if (TreeWindowWidth < 150) {
            TreeWindowWidth = 150;
        }
        DesktopWindowWidth = SVGWidth - TreeWindowWidth;
        TreeViewWidth = TreeWindowWidth - 10;
        DesktopViewWidth = DesktopWindowWidth - 10;
    }

    public void generate() throws IOException {
        this.path_counter = 1;
        this.println("<?xml version='1.0'?>");
        this.println("   <!DOCTYPE svg PUBLIC '-//W3C//DTD SVG 1.0//EN'");
        this.println("       'http://www.w3.org/TR/2001/REC-SVG-20010904/DTD/svg10.dtd'>");
        this.println("<svg width='" + SVGWidth + "' height='" + SVGHeight + "' desktopview='none'>");
        this.printScripts();
        this.printTemplates();
        this.printTitleWindow();
        this.printTreeWindow();
        this.printDesktopWindow();
        this.println("</svg>");
    }

    private void printScripts() throws IOException {
        this.println("<!-- ECMAScript for SVG visualization -->");
        this.println("<script type='text/ecmascript'><![CDATA[");
        this.println("\tfunction scroll(myview, dx, dy) {");
        this.println("\t\tvar box = myview.getAttribute('viewBox');");
        this.println("\t\tvar values = box.split(' ');");
        this.println("\t\tvar x = values[0];");
        this.println("\t\tvar y = values[1];");
        this.println("\t\tvar w = values[2];");
        this.println("\t\tvar h = values[3];");
        this.println("\t\tvar nx = eval(x+dx);");
        this.println("\t\tif (eval(nx) < 0) nx = '0';");
        this.println("\t\tvar ny = eval(y+dy);");
        this.println("\t\tif (eval(ny) < 0) ny = '0';");
        this.println("\t\tif (nx!=x||ny!=y)");
        this.println("\t\t\tmyview.setAttribute('viewBox', nx+' '+ny+' '+w+' '+h);");
        this.println("\t}");
        this.println("\tfunction scrollto(myview, nx, ny) {");
        this.println("\t\tvar box = myview.getAttribute('viewBox');");
        this.println("\t\tvar values = box.split(' ');");
        this.println("\t\tvar x = values[0];");
        this.println("\t\tvar y = values[1];");
        this.println("\t\tvar w = values[2];");
        this.println("\t\tvar h = values[3];");
        this.println("\t\tif (nx!=x||ny!=y)");
        this.println("\t\t\tmyview.setAttribute('viewBox', nx+' '+ny+' '+w+' '+h);");
        this.println("\t}");
        this.println("\tfunction scroll_desktop(evt) {");
        this.println("\t\tvar c = evt.target;");
        this.println("\t\tvar svgdoc = c.getOwnerDocument();");
        this.println("\t\tvar viewname=svgdoc.rootElement.getAttribute('desktopview');");
        this.println("\t\tif (viewname!='none') {");
        this.println("\t\t\tvar desktopview = getView(svgdoc, viewname);");
        this.println("\t\t\tvar button=evt.target.getAttribute('xlink:href');");
        this.println("\t\t\tif (button=='#up')");
        this.println("\t\t\t\tscroll(desktopview, '+0', '-300');");
        this.println("\t\t\telse if (button=='#down')");
        this.println("\t\t\t\tscroll(desktopview, '+0', '+300');");
        this.println("\t\t\telse if (button=='#left')");
        this.println("\t\t\t\tscroll(desktopview, '-200', '+0');");
        this.println("\t\t\telse if (button=='#right')");
        this.println("\t\t\t\tscroll(desktopview, '+200', '+0');");
        this.println("\t\t\telse if (button=='#coin')");
        this.println("\t\t\t\tscrollto(desktopview, '0', '0');");
        this.println("\t\t}");
        this.println("\t}");
        this.println("\tfunction scroll_tree(evt) {");
        this.println("\t\tvar c = evt.target;");
        this.println("\t\tvar svgdoc = c.getOwnerDocument();");
        this.println("\t\tvar treeview = getTreeView(svgdoc, 'ClassTree');");
        this.println("\t\tif (treeview.getAttribute('display')=='none')");
        this.println("\t\t\ttreeview = getTreeView(svgdoc, 'PropertyTree');");
        this.println("\t\tvar button=evt.target.getAttribute('xlink:href');");
        this.println("\t\tif (button=='#up')");
        this.println("\t\t\tscroll(treeview, '+0', '-100');");
        this.println("\t\telse if (button=='#down')");
        this.println("\t\t\tscroll(treeview, '+0', '+100');");
        this.println("\t\telse if (button=='#left')");
        this.println("\t\t\tscroll(treeview, '-50', '+0');");
        this.println("\t\telse if (button=='#right')");
        this.println("\t\t\tscroll(treeview, '+50', '+0');");
        this.println("\t\telse if (button=='#coin')");
        this.println("\t\t\tscrollto(treeview, '0', '0');");
        this.println("\t}");
        this.println("\tfunction getTreeView(svgdoc, viewname) {");
        this.println("\t\tvar win;");
        this.println("\t\tfor (win=svgdoc.rootElement.firstChild; ;win=win.nextSibling) {");
        this.println("\t\t\tif (win.tagName=='svg')");
        this.println("\t\t\t\tif (win.getAttribute('id')=='TreeWindow') break;");
        this.println("\t\t}");
        this.println("\t\tvar viewtag;");
        this.println("\t\tfor (viewtag = win.firstChild; ;viewtag = viewtag.nextSibling) {");
        this.println("\t\t\tif (viewtag.tagName=='svg')");
        this.println("\t\t\t\tif (viewtag.getAttribute('id')==viewname) break;");
        this.println("\t\t}");
        this.println("\t\treturn viewtag;");
        this.println("\t}");
        this.println("   function tree_view(evt) {");
        this.println("   \tvar c = evt.target;");
        this.println("\t\tvar svgdoc = c.getOwnerDocument();");
        this.println("\t\tvar link = c.getAttribute('xlink:href');");
        this.println("\t\tvar str = link.substring(1, link.length)+'Tree';");
        this.println("\t\tvar treeview = getTreeView(svgdoc, str);");
        this.println("\t\tif (treeview.getAttribute('display')=='none') {");
        this.println("\t\t\tvar other;");
        this.println("\t\t\tif (str=='ClassTree') other='PropertyTree';");
        this.println("\t\t\telse other='ClassTree';");
        this.println("\t\t\tgetTreeView(svgdoc, other).setAttribute('display', 'none');");
        this.println("\t\t\ttreeview.setAttribute('display', 'inline');");
        this.println("\t\t}");
        this.println("    }");
        this.println("\tfunction getView(svgdoc, viewname) {");
        this.println("\t\tvar desktopwin;");
        this.println("\t\tfor (desktopwin=svgdoc.rootElement.firstChild; ;desktopwin=desktopwin.nextSibling) {");
        this.println("\t\t\tif (desktopwin.tagName=='svg')");
        this.println("\t\t\t\tif (desktopwin.getAttribute('id')=='DesktopWindow') break;");
        this.println("\t\t}");
        this.println("\t\tvar viewtag;");
        this.println("\t\tfor (viewtag = desktopwin.firstChild; ;viewtag = viewtag.nextSibling) {");
        this.println("\t\t\tif (viewtag.tagName=='svg')");
        this.println("\t\t\t\tif (viewtag.getAttribute('id')==viewname) break;");
        this.println("\t\t}");
        this.println("\t\treturn viewtag;");
        this.println("\t}");
        this.println("   function view_click(evt) {");
        this.println("   \tvar c = evt.target;");
        this.println("\t\tvar svgdoc = c.getOwnerDocument();");
        this.println("\t\tvar viewname=svgdoc.rootElement.getAttribute('desktopview');");
        this.println("\t\tif (viewname!='none') {");
        this.println("\t\t\tgetView(svgdoc, viewname).setAttribute('display', 'none');");
        this.println("\t\t}");
        this.println("\t\tvar link = c.getAttribute('xlink:href');");
        this.println("\t\tvar str = 'view:'+link.substring(1, link.length);");
        this.println("\t\tgetView(svgdoc, str).setAttribute('display', 'inline');");
        this.println("\t\tsvgdoc.rootElement.setAttribute('desktopview', str);");
        this.println("    }");
        this.println("   function view2_click(evt) {");
        this.println("   \tvar c = evt.target;");
        this.println("\t\tvar svgdoc = c.getOwnerDocument();");
        this.println("\t\tvar viewname=svgdoc.rootElement.getAttribute('desktopview');");
        this.println("\t\tif (viewname!='none') {");
        this.println("\t\t\tgetView(svgdoc, viewname).setAttribute('display', 'none');");
        this.println("\t\t}");
        this.println("\t\tvar link = c.getAttribute('xlink:href');");
        this.println("\t\tvar str = 'view:'+link.substring(2, link.length);");
        this.println("\t\tgetView(svgdoc, str).setAttribute('display', 'inline');");
        this.println("\t\tsvgdoc.rootElement.setAttribute('desktopview', str);");
        this.println("    }");
        this.println("   function view3_click(evt) {");
        this.println("   \tvar c = evt.target;");
        this.println("\t\tvar svgdoc = c.getOwnerDocument();");
        this.println("\t\tvar viewname=svgdoc.rootElement.getAttribute('desktopview');");
        this.println("\t\tif (viewname!='none') {");
        this.println("\t\t\tgetView(svgdoc, viewname).setAttribute('display', 'none');");
        this.println("\t\t}");
        this.println("\t\tlink = c.getAttribute('viewID');");
        this.println("\t\tgetView(svgdoc, link).setAttribute('display', 'inline');");
        this.println("\t\tsvgdoc.rootElement.setAttribute('desktopview', link);");
        this.println("    }");
        this.println("\tfunction open_tree(node) {");
        this.println("\t\tif (node.getAttribute('state')=='close') {");
        this.println("\t\t \tnode.setAttribute('state', 'open');");
        this.println("\t\t\tvar y=0;");
        this.println("\t  \t\tfor (var subnode=node.firstChild; ; subnode=subnode.nextSibling) {");
        this.println("\t  \t\t\tif (subnode.tagName=='g') {");
        this.println("\t\t\t\t\tsubnode.setAttribute('visibility', 'visible');");
        this.println("\t\t\t\t\ty=y+15;");
        this.println("\t\t\t\t\tsubnode.setAttribute('transform', 'translate(10,'+y+')');");
        this.println("\t\t\t\t}");
        this.println("\t\t\t\tif (subnode==node.lastChild) break;");
        this.println("\t  \t\t}");
        this.println("\t\t\tnode.setAttribute('style','fill:red');");
        this.println("\t\t}");
        this.println("\t}");
        this.println("\tfunction close_tree(node) {");
        this.println("\t\tif (node.getAttribute('state')=='open') {");
        this.println("\t\t \tnode.setAttribute('state', 'close');");
        this.println("\t  \t\tfor (var subnode=node.firstChild; ; subnode=subnode.nextSibling) {");
        this.println("\t  \t\t\tif (subnode.tagName=='g') {");
        this.println("\t\t\t\t\tsubnode.setAttribute('visibility', 'hidden');");
        this.println("\t\t\t\t\tclose_tree(subnode);");
        this.println("\t\t\t\t}");
        this.println("\t\t\t\tif (subnode==node.lastChild) break;");
        this.println("\t  \t\t}");
        this.println("\t\t\tnode.setAttribute('style','fill:green');");
        this.println("\t\t}");
        this.println("\t}");
        this.println("\tfunction height_tree(node) {");
        this.println("\t\tvar y=15;");
        this.println("\t\tif (node.getAttribute('state')=='open') {");
        this.println("\t  \t\tfor (var subnode=node.firstChild; ; subnode=subnode.nextSibling) {");
        this.println("\t\t  \t\tif (subnode.tagName=='g') y=y+height_tree(subnode);");
        this.println("\t\t\t\tif (subnode==node.lastChild) break;");
        this.println("\t\t\t}");
        this.println("\t  \t}");
        this.println("\t\treturn y;");
        this.println("\t}");
        this.println("\tfunction arrange_tree(node) {");
        this.println("\t\tvar y = 15;");
        this.println("\t  \tfor (var subnode=node.firstChild; ; subnode=subnode.nextSibling) {");
        this.println("\t  \t\tif (subnode.tagName=='g') {");
        this.println("\t  \t\t\tsubnode.setAttribute('transform', 'translate(10,'+y+')');");
        this.println("\t\t\t\ty=y+height_tree(subnode);");
        this.println("\t\t\t}");
        this.println("\t\t\tif (subnode==node.lastChild) break;");
        this.println("\t  \t}");
        this.println("\t\tif (node.parentNode.tagName=='g') arrange_tree(node.parentNode);");
        this.println("\t}");
        this.println("\tfunction tree_click(evt) {");
        this.println("\t\tvar c = evt.target;");
        this.println("\t\tvar node=c.parentNode;");
        this.println("\t\tif (node.getAttribute('state')=='open') {");
        this.println("\t\t\tclose_tree(node);");
        this.println("\t\t\tarrange_tree(node.parentNode);");
        this.println("\t\t}else");
        this.println("\t\t\tif (node.getAttribute('state')=='close') {");
        this.println("\t\t\t\topen_tree(node);");
        this.println("\t\t\t\tarrange_tree(node.parentNode);");
        this.println("\t\t\t}");
        this.println("\t}");
        this.println("]]></script>");
    }

    private void printTemplates() throws IOException {
        this.println("<!-- Visualization templates -->");
        this.println("<defs>");
        this.println("\t<filter id='Bevel' filterUnits='objectBoundingBox' x='-10%' y='-10%' ");
        this.println("\t\t\twidth='150%' height='150%'>");
        this.println("\t\t<feGaussianBlur in='SourceAlpha' stdDeviation='3' result='blur'/>");
        this.println("\t\t<feSpecularLighting in='blur' surfaceScale='5' specularConstant='0.5'");
        this.println("\t\t\tspecularExponent='10' result='specOut'");
        this.println("\t\t \tstyle='lighting-color:white'>");
        this.println("\t\t\t<fePointLight x='-5000' y='-10000' z='20000'/>");
        this.println("\t\t</feSpecularLighting>");
        this.println("\t\t<feComposite in='specOut' in2='SourceAlpha' operator='in' result='specOut2'/>");
        this.println("\t\t<feComposite in='SourceGraphic' in2='specOut2' operator='arithmetic' k1='0'");
        this.println("\t\t\tk2='1' k3='1' k4='0' result='litPaint'/>");
        this.println("\t</filter>");
        this.println("\t<marker id='marker:Triangle' viewBox='0 0 10 10' refX='10' refY='5'");
        this.println("\t\tmarkerUnits='strokeWidth' markerWidth='6' markerHeight='4' orient='auto'>");
        this.println("\t\t<path d='M0 0 L10 5 L0 10 z'/>");
        this.println("\t</marker>");
        this.println("\t<marker id='marker:Triangle-mediumblue' viewBox='0 0 10 10' refX='10' refY='5'");
        this.println("\t\tmarkerUnits='strokeWidth' markerWidth='6' markerHeight='4' orient='auto'>");
        this.println("\t\t<path d='M0 0 L10 5 L0 10' style='fill:none;stroke:mediumblue'/>");
        this.println("\t</marker>");
        this.println("\t<marker id='marker:Triangle-magenta' viewBox='0 0 10 10' refX='10' refY='5'");
        this.println("\t\tmarkerUnits='strokeWidth' markerWidth='6' markerHeight='4' orient='auto'>");
        this.println("\t\t<path d='M0 0 L10 5 L0 10' style='fill:none;stroke:magenta'/>");
        this.println("\t</marker>");
        this.println("\t<marker id='marker:Triangle-royalblue' viewBox='0 0 10 10' refX='10' refY='5'");
        this.println("\t\tmarkerUnits='strokeWidth' markerWidth='6' markerHeight='4' orient='auto'>");
        this.println("\t\t<path d='M0 0 L10 5 L0 10' style='fill:none;stroke:royalblue'/>");
        this.println("\t</marker>");
        this.println("\t<marker id='marker:Triangle2' viewBox='0 0 10 10' refX='10' refY='5'");
        this.println("\t\tmarkerUnits='strokeWidth' markerWidth='6' markerHeight='4' orient='auto'>");
        this.println("\t\t<path d='M0 0 L10 5 L0 10' style='fill:none;stroke:black'/>");
        this.println("\t</marker>");
        this.println("\t<polygon id='opencoin' points='0,0 10,5 0,10 3,5' ");
        this.println("\t\t\tstyle='fill:blue;stroke:blue;stroke-width:1'/>");
        this.println("\t<ellipse id='leafcoin' cx='5' cy='5' rx='3' ry='3' ");
        this.println("\t\t\tstyle='fill:blue;stroke:blue;stroke-width:1'/>");
        this.println("\t<g id='up'>");
        this.println("\t\t<rect width='20' height='20' style='fill:lightgrey;stroke:grey;filter:url(#Bevel)'/>");
        this.println("\t\t<polygon transform='translate(5 5)' points='10,7 5,0 0,7 3,7 3,10 7,10 7,7'");
        this.println("\t\t\t style='fill:blue;stroke:blue;stroke-width:1'/>");
        this.println("\t</g>");
        this.println("\t<g id='down'>");
        this.println("\t\t<rect width='20' height='20' style='fill:lightgrey;stroke:grey;filter:url(#Bevel)'/>");
        this.println("\t\t<polygon transform='translate(5 5)' points='10,3 5,10 0,3 3,3 3,0 7,0 7,3'");
        this.println("\t\t\t style='fill:blue;stroke:blue;stroke-width:1'/>");
        this.println("\t</g>");
        this.println("\t<g id='right'>");
        this.println("\t\t<rect width='20' height='20' style='fill:lightgrey;stroke:grey;filter:url(#Bevel)'/>");
        this.println("\t\t<polygon transform='translate(5 5)' points='3,0 10,5 3,10 3,7 0,7 0,3 3,3'");
        this.println("\t\t\t style='fill:blue;stroke:blue;stroke-width:1'/>");
        this.println("\t\t</g>");
        this.println("\t<g id='left'>");
        this.println("\t\t<rect width='20' height='20' style='fill:lightgrey;stroke:grey;filter:url(#Bevel)'/>");
        this.println("\t\t<polygon transform='translate(5 5)' points='7,0 0,5 7,10 7,7 10,7 10,3 7,3'");
        this.println("\t\t\t style='fill:blue;stroke:blue;stroke-width:1'/>");
        this.println("\t</g>");
        this.println("\t<g id='coin'>");
        this.println("\t\t<rect width='20' height='20' style='fill:lightgrey;stroke:grey;filter:url(#Bevel)'/>");
        this.println("\t\t<polygon transform='translate(5 5)' points='7,0 0,0 0,7 2,5 5,8 8,5 5,2'");
        this.println("\t\t\t style='fill:blue;stroke:blue;stroke-width:1'/>");
        this.println("\t</g>");
        this.printClassTemplates();
        this.printPropertyTemplates();
        this.printResourceTemplates();
        this.println("</defs>");
    }

    private int getLabelWidth(String string) {
        Font font = new Font("Arial", 0, 12);
        FontMetrics fontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(font);
        return fontMetrics.stringWidth(string);
    }

    private int getLabelWidth2(String string) {
        Font font = new Font("Arial", 0, 14);
        FontMetrics fontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(font);
        return fontMetrics.stringWidth(string);
    }

    private int getRx(RDF_Class rDF_Class) {
        int n = this.getLabelWidth(this.broker.getLabelFor(rDF_Class)) / 2 + 5;
        if (n < 50) {
            n = 50;
        }
        return n;
    }

    private void printClassTemplates() throws IOException {
        int n = 0;
        while (n < this.classList.size()) {
            RDF_Class rDF_Class = (RDF_Class)this.classList.get(n);
            String string = "C" + n;
            String string2 = this.broker.getLabelFor(rDF_Class);
            int n2 = this.getRx(rDF_Class);
            this.println("\t<text id='" + string + "' style='font-size:12;font-family:Arial'>" + string2 + "</text>");
            this.println("\t<g id='_" + string + "'>");
            this.println("\t\t<ellipse rx='" + n2 + "' ry='" + 14 + "' style='fill:cyan;stroke-width:1;stroke:black;filter:url(#Bevel)'/>");
            this.println("\t\t<use y='4' xlink:href='#" + string + "' style='text-anchor:middle;fill:black'/>");
            this.println("\t</g>");
            ++n;
        }
    }

    private void printPropertyTemplates() throws IOException {
        int n = 0;
        while (n < this.propertyList.size()) {
            RDF_Property rDF_Property = (RDF_Property)this.propertyList.get(n);
            String string = "P" + n;
            String string2 = this.broker.getLabelFor(rDF_Property);
            this.println("\t<text id='" + string + "' style='font-size:12;font-family:Arial'>" + string2 + "</text>");
            ++n;
        }
    }

    private int getWidth(RDF_Resource rDF_Resource) {
        int n = this.getLabelWidth(this.broker.getLabelFor(rDF_Resource)) + 10;
        if (n < 150) {
            n = 150;
        }
        return n;
    }

    private void printResourceTemplates() throws IOException {
        int n = 0;
        while (n < this.resourceList.size()) {
            RDF_Resource rDF_Resource = (RDF_Resource)this.resourceList.get(n);
            String string = "R" + n;
            String string2 = this.broker.getLabelFor(rDF_Resource);
            int n2 = this.getWidth(rDF_Resource);
            this.println("\t<text id='" + string + "' style='font-size:12;font-family:Arial'>" + string2 + "</text>");
            this.println("\t<g id='_" + string + "'>");
            this.println("\t\t<rect width='" + n2 + "' height='" + 25 + "' style='fill:lime;stroke-width:1;stroke:black;filter:url(#Bevel)'/>");
            this.println("\t\t<use x='" + n2 / 2 + "' y='18' xlink:href='#" + string + "' style='text-anchor:middle;fill:black'/>");
            this.println("\t</g>");
            ++n;
        }
    }

    private void printTitleWindow() throws IOException {
        this.println("<!-- Title window -->");
        this.println("<rect x='0' y='" + (SVGHeight - 30) + "' width='" + SVGWidth + "' height='30'");
        this.println("\t style='fill:lightgray;stroke:grey;filter:url(#Bevel)'/>");
        String string = this.broker.getNamespaceInfor();
        string = "<![CDATA[" + string + "]]>";
        this.println("<svg id='TitleWindow' x='5' y='" + (SVGHeight - 26) + "' width='" + (SVGWidth - 10) + "' height='22'>");
        this.println("\t<text y='16' style='fill:red;font-size:12;font-family:Arial'>");
        this.println("\t\t" + string);
        this.println("\t\t<animate attributeName='x' attributeType='XML' \tfrom='" + (SVGWidth - 10) + "' to='-" + this.getLabelWidth(string) + "'");
        this.println("\t\t\tbegin='0s' dur='60s' fill='freeze' repeatCount='indefinite'/>");
        this.println("\t</text>");
        this.println("</svg>");
    }

    private void printTreeNode(RDF_Class rDF_Class, int n) throws IOException {
        String string;
        String string2;
        String string3;
        String string4;
        String string5;
        String string6 = this.broker.isRootClass(rDF_Class) ? "visible" : "hidden";
        String string7 = string5 = n != 0 ? "transform='translate(10," + n + ")'" : "";
        if (this.broker.isLeafClass(rDF_Class)) {
            string4 = "red";
            string3 = "";
            string2 = "#leafcoin";
            string = "";
        } else {
            string4 = "green";
            string3 = "state='close'";
            string2 = "#opencoin";
            string = "onclick='tree_click(evt)'";
        }
        String string8 = "C" + this.classList.indexOf(rDF_Class);
        this.println("\t\t<g " + string5 + " style='fill:" + string4 + "' visibility='" + string6 + "' " + string3 + ">");
        this.println("\t\t\t<use xlink:href='" + string2 + "' x='0' y='5' " + string + "/>");
        this.println("\t\t\t<use xlink:href='#" + string8 + "' x='15' y='15' onclick='view_click(evt)'/>");
        Iterator iterator = this.broker.getSubClasses(rDF_Class, false, true).iterator();
        while (iterator.hasNext()) {
            this.printTreeNode((RDF_Class)iterator.next(), 0);
        }
        this.println("\t\t</g>");
    }

    private void printTreePropertyNode(RDF_Property rDF_Property, int n) throws IOException {
        String string;
        String string2;
        String string3;
        String string4;
        String string5;
        String string6 = this.broker.isRootProperty(rDF_Property) ? "visible" : "hidden";
        String string7 = string5 = n != 0 ? "transform='translate(10," + n + ")'" : "";
        if (this.broker.isLeafProperty(rDF_Property)) {
            string4 = "red";
            string3 = "";
            string2 = "#leafcoin";
            string = "";
        } else {
            string4 = "green";
            string3 = "state='close'";
            string2 = "#opencoin";
            string = "onclick='tree_click(evt)'";
        }
        String string8 = "P" + this.propertyList.indexOf(rDF_Property);
        this.println("\t\t<g " + string5 + " style='fill:" + string4 + "' visibility='" + string6 + "' " + string3 + ">");
        this.println("\t\t\t<use xlink:href='" + string2 + "' x='0' y='5' " + string + "/>");
        this.println("\t\t\t<use xlink:href='#" + string8 + "' x='15' y='15' onclick='view_click(evt)'/>");
        Iterator iterator = this.broker.getSubProperties(rDF_Property, false, true).iterator();
        while (iterator.hasNext()) {
            this.printTreePropertyNode((RDF_Property)iterator.next(), 0);
        }
        this.println("\t\t</g>");
    }

    private int getNodeWidth(RDF_Class rDF_Class, int n) {
        int n2 = this.getLabelWidth(this.broker.getLabelFor(rDF_Class)) + n * 10 + 15;
        Iterator iterator = this.broker.getSubClasses(rDF_Class, false, false).iterator();
        while (iterator.hasNext()) {
            int n3 = this.getNodeWidth((RDF_Class)iterator.next(), n + 1);
            if (n2 >= n3) continue;
            n2 = n3;
        }
        return n2;
    }

    private void printTreeWindow() throws IOException {
        Iterator iterator;
        int n;
        Object object;
        this.println("<!-- Tree window -->");
        int n2 = 0;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        Iterator iterator2 = this.broker.getRootClasses(true).iterator();
        while (iterator2.hasNext()) {
            object = (RDF_Class)iterator2.next();
            if (this.broker.isAttributeClass((RDF_Class)object) || this.broker.isBasicResource((RDF_Resource)object) && this.broker.getSubClasses((RDF_Class)object, false, false).isEmpty()) continue;
            if (this.broker.isSchemaClass((RDF_Class)object)) {
                arrayList2.add(object);
                continue;
            }
            arrayList.add(object);
        }
        object = arrayList.iterator();
        while (object.hasNext()) {
            n = this.getNodeWidth((RDF_Class)object.next(), 1);
            if (n2 >= n) continue;
            n2 = n;
        }
        SVGGenerator.setTreeWindowWidth(n2 + 10);
        this.println("<svg id='TreeWindow' x='0' y='0' width='" + TreeWindowWidth + "' height='" + TreeWindowHeight + "'>");
        this.println("<defs>");
        this.println("\t<g id='Class'>");
        this.println("\t\t<rect width='" + TreeWindowWidth / 2 + "' height='25' style='fill:lightgrey;stroke:grey;filter:url(#Bevel)'/>");
        this.println("\t\t<text x='" + TreeWindowWidth / 4 + "' y='16' style='text-anchor:middle;fill:blue;font-size:14;font-family:Arial'>Classes</text>");
        this.println("\t</g>");
        this.println("\t<g id='Property'>");
        this.println("\t\t<rect width='" + TreeWindowWidth / 2 + "' height='25' style='fill:lightgrey;stroke:grey;filter:url(#Bevel)'/>");
        this.println("\t\t<text x='" + TreeWindowWidth / 4 + "' y='16' style='text-anchor:middle;fill:blue;font-size:14;font-family:Arial'>Properties</text>");
        this.println("\t</g>");
        this.println("</defs>");
        this.println("<rect x='0' y='0' width='" + TreeWindowWidth + "' height='" + TreeWindowHeight + "'");
        this.println("\t \tstyle='fill:lightgray;stroke:grey;filter:url(#Bevel)'/>");
        this.println("<use xlink:href='#Class' x='0' y='0' onclick='tree_view(evt)'/>");
        this.println("<use xlink:href='#Property' x='" + TreeWindowWidth / 2 + "' y='0' onclick='tree_view(evt)'/>");
        this.println("<svg id='ClassTree' x='5' y='30' width='" + TreeViewWidth + "' height='" + TreeViewHeight + "'");
        this.println("\t\tdisplay='inline' viewBox='0 0 " + TreeViewWidth + " " + TreeViewHeight + "'>");
        this.println("\t<g transform='translate(-10,-15)' state='open'>");
        this.println("\t<g transform='translate(10,15)' state='open'>");
        this.println("\t\t<text x='0' y='15' style='fill:blue;font-size:12;font-family:Arial'>All Classes:</text>");
        n = 15;
        Iterator iterator3 = arrayList.iterator();
        while (iterator3.hasNext()) {
            this.printTreeNode((RDF_Class)iterator3.next(), n);
            n += 15;
        }
        this.println("\t</g>");
        if (!arrayList2.isEmpty()) {
            n = (arrayList.size() + 1) * 15 + 15;
            this.println("\t<g transform='translate(10," + n + ")' state='open'>");
            this.println("\t\t<text x='0' y='15' style='fill:blue;font-size:12;font-family:Arial'>Meta Classes:</text>");
            n = 15;
            iterator = arrayList2.iterator();
            while (iterator.hasNext()) {
                this.printTreeNode((RDF_Class)iterator.next(), n);
                n += 15;
            }
            this.println("\t</g>");
        }
        this.println("\t</g>");
        this.println("</svg>");
        this.println("<svg id='PropertyTree' x='5' y='30' width='" + TreeViewWidth + "' height='" + TreeViewHeight + "'");
        this.println("\t\tdisplay='none' viewBox='0 0 " + TreeViewWidth + " " + TreeViewHeight + "'>");
        this.println("\t<g transform='translate(-10,-15)' state='open'>");
        this.println("\t<g transform='translate(10,15)' state='open'>");
        this.println("\t\t<text x='0' y='15' style='fill:blue;font-size:12;font-family:Arial'>All Properties:</text>");
        n = 15;
        iterator = this.broker.getRootProperties(true).iterator();
        while (iterator.hasNext()) {
            this.printTreePropertyNode((RDF_Property)iterator.next(), n);
            n += 15;
        }
        this.println("\t</g>");
        this.println("\t</g>");
        this.println("</svg>");
        this.println("<use xlink:href='#up' x='" + (TreeWindowWidth - 20) + "' y='" + (TreeWindowHeight - 60) + "' onclick='scroll_tree(evt)'/>");
        this.println("<use xlink:href='#down' x='" + (TreeWindowWidth - 20) + "' y='" + (TreeWindowHeight - 40) + "' onclick='scroll_tree(evt)'/>");
        this.println("<use xlink:href='#coin' x='" + (TreeWindowWidth - 20) + "' y='" + (TreeWindowHeight - 20) + "' onclick='scroll_tree(evt)'/>");
        this.println("<use xlink:href='#left' x='" + (TreeWindowWidth - 60) + "' y='" + (TreeWindowHeight - 20) + "' onclick='scroll_tree(evt)'/>");
        this.println("<use xlink:href='#right' x='" + (TreeWindowWidth - 40) + "' y='" + (TreeWindowHeight - 20) + "' onclick='scroll_tree(evt)'/>");
        this.println("</svg>");
    }

    private void printDesktopWindow() throws IOException {
        this.println("<!-- Desktop window -->");
        this.println("<svg id='DesktopWindow' x='" + TreeWindowWidth + "' y='0' width='" + DesktopWindowWidth + "' height='" + DesktopWindowHeight + "'>");
        this.println("<rect x='0' y='0' width='" + DesktopWindowWidth + "' height='" + DesktopWindowHeight + "'");
        this.println("\t style='fill:lightgray;stroke:grey;filter:url(#Bevel)'/>");
        this.printClassViews();
        this.printPropertyViews();
        this.printResourceViews();
        this.println("<use xlink:href='#up' x='" + (DesktopWindowWidth - 20) + "' y='" + (DesktopWindowHeight - 60) + "' onclick='scroll_desktop(evt)'/>");
        this.println("<use xlink:href='#down' x='" + (DesktopWindowWidth - 20) + "' y='" + (DesktopWindowHeight - 40) + "' onclick='scroll_desktop(evt)'/>");
        this.println("<use xlink:href='#coin' x='" + (DesktopWindowWidth - 20) + "' y='" + (DesktopWindowHeight - 20) + "' onclick='scroll_desktop(evt)'/>");
        this.println("<use xlink:href='#left' x='" + (DesktopWindowWidth - 60) + "' y='" + (DesktopWindowHeight - 20) + "' onclick='scroll_desktop(evt)'/>");
        this.println("<use xlink:href='#right' x='" + (DesktopWindowWidth - 40) + "' y='" + (DesktopWindowHeight - 20) + "' onclick='scroll_desktop(evt)'/>");
        this.println("</svg>");
    }

    private void printClassViews() throws IOException {
        int n = 0;
        while (n < this.classList.size()) {
            RDF_Class rDF_Class = (RDF_Class)this.classList.get(n);
            String string = "C" + n;
            this.printClassView(string, rDF_Class);
            ++n;
        }
    }

    private void printClassView(String string, RDF_Class rDF_Class) throws IOException {
        int n;
        int n2;
        int n3;
        Point[] pointArray;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        int n10;
        int n11;
        int n12;
        Object object6;
        RDF_Class rDF_Class2;
        Iterator iterator;
        Object object7;
        Object object8;
        Collection collection = this.broker.getPropertiesWithDomain(rDF_Class, true);
        Collection collection2 = this.broker.getPropertiesWithRange(rDF_Class, true);
        Collection collection3 = this.broker.getSuperClasses(rDF_Class, false, false);
        Collection collection4 = this.broker.getSubClasses(rDF_Class, false, false);
        SizeComparator sizeComparator = new SizeComparator();
        TreeSet<PropertyArc> treeSet = new TreeSet<PropertyArc>(sizeComparator);
        TreeSet<PropertyArc> treeSet2 = new TreeSet<PropertyArc>(sizeComparator);
        ArrayList<PropertyArc> arrayList = new ArrayList<PropertyArc>();
        String string2 = "";
        Iterator iterator2 = rDF_Class.getcomment().iterator();
        while (iterator2.hasNext()) {
            if (!string2.equals("")) {
                string2 = string2 + ". ";
            }
            string2 = string2 + ((Literal)iterator2.next()).getvalue();
        }
        Iterator iterator3 = collection.iterator();
        while (iterator3.hasNext()) {
            object8 = (RDF_Property)iterator3.next();
            object7 = this.broker.getRangeOfProperty((RDF_Property)object8, false, false);
            if (object7.isEmpty()) {
                arrayList.add(new PropertyArc(null, (RDF_Property)object8));
            }
            iterator = object7.iterator();
            while (iterator.hasNext()) {
                rDF_Class2 = (RDF_Class)iterator.next();
                object6 = new PropertyArc(rDF_Class2, (RDF_Property)object8);
                if (this.broker.isAttributeClass(rDF_Class2)) {
                    arrayList.add((PropertyArc)object6);
                    continue;
                }
                treeSet.add((PropertyArc)object6);
            }
        }
        object8 = collection2.iterator();
        while (object8.hasNext()) {
            object7 = (RDF_Property)object8.next();
            iterator = this.broker.getDomainOfProperty((RDF_Property)object7, false, false).iterator();
            while (iterator.hasNext()) {
                rDF_Class2 = (RDF_Class)iterator.next();
                if (rDF_Class2 == rDF_Class) continue;
                treeSet2.add(new PropertyArc(rDF_Class2, (RDF_Property)object7));
            }
        }
        int n13 = 45 + arrayList.size() * 15;
        object7 = this.broker.getLabelFor(rDF_Class);
        int n14 = this.getLabelWidth2((String)object7);
        iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            int n15 = this.getLabelWidth(((PropertyArc)iterator.next()).getAttributeLabel());
            if (n14 >= n15) continue;
            n14 = n15;
        }
        if ((n14 += 10) < 150) {
            n14 = 150;
        }
        int n16 = 35 * treeSet2.size();
        int n17 = 0;
        int n18 = 0;
        object6 = treeSet2.iterator();
        while (object6.hasNext()) {
            int n19 = this.getRx(((PropertyArc)object6.next()).rdf_class) * 2;
            if (++n18 * 35 / 2 - n13 / 2 < 100) {
                n19 += 100;
            }
            if (n17 >= n19) continue;
            n17 = n19;
        }
        n17 += 10;
        int n20 = 35 * treeSet.size();
        int n21 = 0;
        n18 = 0;
        Iterator iterator4 = treeSet.iterator();
        while (iterator4.hasNext()) {
            n12 = this.getRx(((PropertyArc)iterator4.next()).rdf_class) * 2;
            if (++n18 * 35 / 2 - n13 / 2 < 100) {
                n12 += 100;
            }
            if (n21 >= n12) continue;
            n21 = n12;
        }
        if (n17 + n14 + (n21 += 10) < DesktopViewWidth) {
            n11 = DesktopViewWidth;
            n12 = n17 + n14 / 2 <= n11 / 2 && n21 + n14 / 2 <= n11 / 2 ? n11 / 2 : n17 + (n11 - n17 - n21) / 2;
        } else {
            n11 = n17 + n14 + n21;
            n12 = n17 + n14 / 2;
        }
        int n22 = 0;
        int n23 = 35;
        Iterator iterator5 = collection3.iterator();
        while (iterator5.hasNext()) {
            int n24 = this.getRx((RDF_Class)iterator5.next()) * 2;
            if ((n22 += n24 + 10) <= n11 - 10) continue;
            n23 += 35;
            n22 = 0;
        }
        n23 = collection3.isEmpty() ? 10 : (n23 += 20);
        if (!string2.equals("")) {
            n23 += 50;
        }
        int n25 = 0;
        int n26 = 35;
        Iterator iterator6 = collection4.iterator();
        while (iterator6.hasNext()) {
            n10 = this.getRx((RDF_Class)iterator6.next()) * 2;
            if ((n25 += n10 + 10) <= n11 - 10) continue;
            n26 += 35;
            n25 = 0;
        }
        n26 = collection4.isEmpty() ? 10 : (n26 += 20);
        n10 = n23 + Math.max(n16, n20) / 2;
        int n27 = n23 + n13 / 2;
        if (!collection3.isEmpty()) {
            n27 += 100;
        }
        if (n10 < n27) {
            n10 = n27;
        } else {
            n27 = n10;
        }
        n27 += Math.max(n16, n20) / 2;
        int n28 = n13 / 2;
        if (!collection4.isEmpty()) {
            n28 += 100;
        }
        if (n27 < n10 + n28) {
            n27 = n10 + n28;
        }
        n27 -= n23;
        this.println("\t<svg id='view:" + string + "' x='5' y='5' width='" + DesktopViewWidth + "' height='" + DesktopViewHeight + "'");
        this.println("\t\t\tdisplay='none' viewBox='0 0 " + DesktopViewWidth + " " + DesktopViewHeight + "'>");
        if (!string2.equals("")) {
            string2 = "<![CDATA[" + string2 + "]]>";
            this.println("\t\t<rect x='0' y='5' width='" + n11 + "' height='40'");
            this.println("\t\t\t style='fill:lightgreen;stroke:lightgreen;filter:url(#Bevel)'/>");
            this.println("\t\t<svg x='5' y='5' width='" + (n11 - 10) + "' height='40'>");
            this.println("\t\t\t<text x='0' y='15' style='fill:black;font-size:12;");
            this.println("\t\t\t\tfont-family:Arial'>Comment:</text>");
            this.println("\t\t\t<text y='30' style='fill:red;font-size:12;font-family:Arial'>");
            this.println("\t\t\t\t" + string2);
            this.println("\t\t\t\t<animate attributeName='x' attributeType='XML' \tfrom='" + (n11 - 10) + "' to='-" + this.getLabelWidth(string2) + "'");
            this.println("\t\t\t\t\tbegin='0s' dur='60s' fill='freeze' repeatCount='indefinite'/>");
            this.println("\t\t\t</text>");
            this.println("\t\t</svg>");
        }
        String string3 = "";
        String string4 = "";
        String string5 = "grey";
        if (this.broker.isMetaClass(rDF_Class)) {
            string3 = "Meta-class";
        } else if (this.broker.isPropertyClass(rDF_Class)) {
            string3 = "Meta-Property";
        } else {
            object5 = this.broker.getMetaClass(rDF_Class);
            if (object5 != null) {
                string3 = this.broker.getLabelFor((RDF_Resource)object5);
                string5 = MetaColor;
                string4 = "viewID='view:C" + this.classList.indexOf(object5) + "' onclick='view3_click(evt)'";
            }
        }
        this.println("\t\t<g transform='translate(" + (n12 - n14 / 2) + "," + (n10 - n13 / 2) + ")'>");
        this.println("\t\t\t<rect  width='" + n14 + "' height='" + n13 + "' rx='10'");
        this.println("\t\t\t\t style='fill:yellow;stroke:black;stroke-width:1;filter:url(#Bevel)'/>");
        this.println("\t\t\t<text x='" + n14 / 2 + "' y='20' style='text-anchor:middle;fill:black;");
        this.println("\t\t\t\t font-size:14;font-family:Arial'>" + (String)object7 + "</text>");
        this.println("\t\t\t<text x='" + n14 / 2 + "' y='35' style='text-anchor:middle;fill:" + string5 + ";");
        this.println("\t\t\t\t font-size:12;font-family:Arial' " + string4 + ">(" + string3 + ")</text>");
        this.println("\t\t\t<line x1='0' y1='40' x2='" + n14 + "' y2='40'");
        this.println("\t\t\t\t \tstyle='fill:none;stroke:grey;stroke-width:1'/>");
        int n29 = 55;
        object5 = arrayList.iterator();
        while (object5.hasNext()) {
            object4 = (PropertyArc)object5.next();
            string5 = ((PropertyArc)object4).isDefinedWithDomain(rDF_Class) ? NoneTransitiveProperty : TransitiveProperty;
            object3 = "viewID='view:P" + this.propertyList.indexOf(((PropertyArc)object4).rdf_property) + "' onclick='view3_click(evt)'";
            this.println("\t\t\t<text x='5' y='" + n29 + "' style='fill:" + string5 + ";font-size:12;");
            this.println("\t\t\t\t\tfont-family:Arial' " + object3 + ">" + ((PropertyArc)object4).getAttributeLabel() + "</text>");
            n29 += 15;
        }
        this.println("\t\t</g>");
        if (collection3.size() > 0) {
            int n30 = n23 - 10;
            n29 = 5;
            if (!string2.equals("")) {
                n30 -= 50;
                n29 += 50;
            }
            this.println("\t\t<rect x='0' y='" + n29 + "' width='" + n11 + "' height='" + n30 + "'");
            this.println("\t\t\t style='fill:yellow;stroke:yellow;filter:url(#Bevel)'/>");
            n29 = n23 - 28;
            object3 = new ArrayList();
            n22 = 0;
            object2 = collection3.iterator();
            while (object2.hasNext()) {
                object = (RDF_Class)object2.next();
                n9 = this.getRx((RDF_Class)object) * 2;
                if (n22 + n9 + 10 > n11 - 10) {
                    this.printClassLine((Collection)object3, n29, n22, n11);
                    ((ArrayList)object3).clear();
                    n22 = n9;
                    n29 -= 35;
                } else {
                    n22 += n9 + 10;
                }
                ((ArrayList)object3).add(object);
            }
            this.printClassLine((Collection)object3, n29, n22, n11);
            n8 = n12;
            n7 = n10 - n13 / 2;
            n6 = n11 / 2;
            n5 = n23 - 5;
            this.println("\t\t<path id='p" + this.path_counter + "' d='M" + n8 + " " + n7 + " L" + n6 + " " + n5 + "'");
            this.println("\t\t\t style='marker-end:url(#marker:Triangle);fill:none;stroke:black;stroke-width:2'/>");
            if (n6 < n8) {
                ++this.path_counter;
                this.println("\t\t<path id='p" + this.path_counter + "' d='M" + n6 + " " + n5 + " L" + n8 + " " + n7 + "'");
                this.println("\t\t\t style='fill:none;stroke:none'/>");
            }
            this.println("\t\t<text style='text-anchor:middle;font-size:12;font-family:Arial'>");
            this.println("\t\t\t<textPath xlink:href='#p" + this.path_counter + "' startOffset='50%'>");
            this.println("\t\t\t\trdfs:subClassOf");
            this.println("\t\t\t</textPath>");
            this.println("\t\t</text>");
            ++this.path_counter;
        }
        if (collection4.size() > 0) {
            n29 = n23 + n27 + 5;
            this.println("\t\t<rect x='0' y='" + n29 + "' width='" + n11 + "' height='" + (n26 - 10) + "'");
            this.println("\t\t\t style='fill:yellow;stroke:yellow;filter:url(#Bevel)'/>");
            n29 = n23 + n27 + 28;
            object4 = new ArrayList();
            n25 = 0;
            object3 = collection4.iterator();
            while (object3.hasNext()) {
                object2 = (RDF_Class)object3.next();
                int n31 = this.getRx((RDF_Class)object2) * 2;
                if (n25 + n31 + 10 > n11 - 10) {
                    this.printClassLine((Collection)object4, n29, n25, n11);
                    ((ArrayList)object4).clear();
                    n25 = n31;
                    n29 += 35;
                } else {
                    n25 += n31 + 10;
                }
                ((ArrayList)object4).add(object2);
            }
            this.printClassLine((Collection)object4, n29, n25, n11);
            n8 = n11 / 2;
            n7 = n23 + n27 + 5;
            n6 = n12;
            n5 = n10 + n13 / 2;
            this.println("\t\t<path id='p" + this.path_counter + "' d='M" + n8 + " " + n7 + " L" + n6 + " " + n5 + "'");
            this.println("\t\t\t style='marker-end:url(#marker:Triangle);fill:none;stroke:black;stroke-width:2'/>");
            if (n6 < n8) {
                ++this.path_counter;
                this.println("\t\t<path id='p" + this.path_counter + "' d='M" + n6 + " " + n5 + " L" + n8 + " " + n7 + "'");
                this.println("\t\t\t style='fill:none;stroke:none'/>");
            }
            this.println("\t\t<text style='text-anchor:middle;font-size:12;font-family:Arial'>");
            this.println("\t\t\t<textPath xlink:href='#p" + this.path_counter + "' startOffset='50%'>");
            this.println("\t\t\t\trdfs:subClassOf");
            this.println("\t\t\t</textPath>");
            this.println("\t\t</text>");
            ++this.path_counter;
        }
        n29 = n10;
        if (treeSet2.size() % 2 == 0) {
            n29 -= 17;
        }
        int n32 = 35;
        object3 = treeSet2.iterator();
        while (object3.hasNext()) {
            object2 = (PropertyArc)object3.next();
            int n33 = this.getRx(((PropertyArc)object2).rdf_class) * 2;
            n4 = 10 + n33 / 2;
            string5 = ((PropertyArc)object2).isDefinedWithRange(rDF_Class) ? NoneTransitiveProperty : TransitiveProperty;
            string4 = "C" + this.classList.indexOf(((PropertyArc)object2).rdf_class);
            this.println("\t\t<use x='" + n4 + "' y='" + n29 + "' xlink:href='#_" + string4 + "' onclick='view2_click(evt)'/>");
            String string6 = "viewID='view:P" + this.propertyList.indexOf(((PropertyArc)object2).rdf_property) + "' onclick='view3_click(evt)'";
            n8 = 10 + n33;
            n7 = n29;
            pointArray = Clipping.getClipped(n8, n7, n12, n10, n12 - n14 / 2, n12 + n14 / 2, n10 - n13 / 2, n10 + n13 / 2);
            if (pointArray[0].x == n12 && pointArray[0].y == n10) {
                n6 = pointArray[1].x;
                n5 = pointArray[1].y;
            } else {
                n6 = pointArray[0].x;
                n5 = pointArray[0].y;
            }
            n3 = (int)Math.sqrt((n8 - n6) * (n8 - n6) + (n7 - n5) * (n7 - n5));
            n2 = (this.getLabelWidth(((PropertyArc)object2).getPropertyLabel()) + n3) * 25 / n3;
            this.println("\t\t<path id='p" + this.path_counter + "' d='M" + n8 + " " + n7 + " L" + n6 + " " + n5 + "'");
            this.println("\t\t\t style='marker-end:url(#marker:Triangle-" + string5 + ");fill:none;stroke:" + string5 + ";stroke-width:2'/>");
            this.println("\t\t<text style='text-anchor:middle;fill:" + string5 + ";font-size:12;font-family:Arial'>");
            this.println("\t\t\t<textPath xlink:href='#p" + this.path_counter + "' startOffset='" + n2 + "%' " + string6 + ">");
            this.println("\t\t\t" + ((PropertyArc)object2).getPropertyLabel() + "");
            this.println("\t\t\t</textPath>");
            this.println("\t\t</text>");
            ++this.path_counter;
            n29 += n32;
            n32 = n32 > 0 ? -(n32 + 35) : -n32 + 35;
        }
        n29 = n10;
        if (treeSet.size() % 2 == 0) {
            n29 -= 17;
        }
        n32 = 35;
        object2 = treeSet.iterator();
        while (object2.hasNext()) {
            object = (PropertyArc)object2.next();
            n9 = this.getRx(((PropertyArc)object).rdf_class) * 2;
            n4 = n11 - 10 - n9 / 2;
            string5 = ((PropertyArc)object).isDefinedWithDomain(rDF_Class) ? NoneTransitiveProperty : TransitiveProperty;
            string4 = "C" + this.classList.indexOf(((PropertyArc)object).rdf_class);
            this.println("\t\t<use x='" + n4 + "' y='" + n29 + "' xlink:href='#_" + string4 + "' onclick='view2_click(evt)'/>");
            pointArray = "viewID='view:P" + this.propertyList.indexOf(((PropertyArc)object).rdf_property) + "' onclick='view3_click(evt)'";
            n6 = n11 - 10 - n9;
            n5 = n29;
            Point[] pointArray2 = Clipping.getClipped(n6, n5, n12, n10, n12 - n14 / 2, n12 + n14 / 2, n10 - n13 / 2, n10 + n13 / 2);
            if (pointArray2[0].x == n12 && pointArray2[0].y == n10) {
                n8 = pointArray2[1].x;
                n7 = pointArray2[1].y;
            } else {
                n8 = pointArray2[0].x;
                n7 = pointArray2[0].y;
            }
            n2 = (int)Math.sqrt((n8 - n6) * (n8 - n6) + (n7 - n5) * (n7 - n5));
            n = (this.getLabelWidth(((PropertyArc)object).getPropertyLabel()) + n2) * 25 / n2;
            if (n < 50) {
                n = 100 - n;
            }
            this.println("\t\t<path id='p" + this.path_counter + "' d='M" + n8 + " " + n7 + " L" + n6 + " " + n5 + "'");
            this.println("\t\t\t style='marker-end:url(#marker:Triangle-" + string5 + ");fill:none;stroke:" + string5 + ";stroke-width:2'/>");
            this.println("\t\t<text style='text-anchor:middle;fill:" + string5 + ";font-size:12;font-family:Arial'>");
            this.println("\t\t\t<textPath xlink:href='#p" + this.path_counter + "' startOffset='" + n + "%' " + (String)pointArray + ">");
            this.println("\t\t\t" + ((PropertyArc)object).getPropertyLabel() + "");
            this.println("\t\t\t</textPath>");
            this.println("\t\t</text>");
            ++this.path_counter;
            n29 += n32;
            n32 = n32 > 0 ? -(n32 + 35) : -n32 + 35;
        }
        if (!this.broker.isSchemaClass(rDF_Class) && !this.broker.isAttributeClass(rDF_Class)) {
            int n34;
            Object object9;
            object = this.broker.getInstanceResources(rDF_Class, true, true);
            Collection collection5 = this.broker.getInstanceResources(rDF_Class, false, true);
            n4 = 0;
            n29 = n23 + n27 + n26 + 10;
            int n35 = 1;
            n2 = 0;
            n = 0;
            if (object.size() != 0) {
                object9 = object.iterator();
                while (object9.hasNext()) {
                    n34 = this.getWidth((RDF_Resource)object9.next());
                    if (n35 >= n34) continue;
                    n35 = n34;
                }
                if (n11 < n35) {
                    n11 = n35;
                }
                n2 = n11 / n35;
                n = object.size() / n2;
                if (object.size() % n2 != 0) {
                    ++n;
                }
                n3 = 15 * n + 5;
            } else {
                n3 = 20;
            }
            object9 = "Resource Instances";
            if (this.broker.isContainerClass(rDF_Class)) {
                object9 = "Container Instances";
            } else if (this.broker.isStatementClass(rDF_Class)) {
                object9 = "Reified Statements";
            }
            this.println("\t\t<g transform='translate(" + n4 + "," + n29 + ")'>");
            this.println("\t\t\t<rect x='0' y='0' width='" + n11 + "' height='30' style='fill:limegreen;filter:url(#Bevel)'/>");
            this.println("\t\t\t<text x='" + n11 / 2 + "' y='20' style='text-anchor:middle;font-size:14;font-family:Arial'>" + (String)object9 + "</text>");
            this.println("\t\t\t<rect x='0' y='30' width='" + n11 + "' height='" + n3 + "' style='fill:beige'/>");
            n34 = 0;
            int n36 = 1;
            Iterator iterator7 = object.iterator();
            while (iterator7.hasNext()) {
                n8 = n34 * n35 + 5;
                n7 = 15 * n36 + 30;
                RDF_Resource rDF_Resource = (RDF_Resource)iterator7.next();
                string5 = collection5.contains(rDF_Resource) ? NoneTransitiveResource : TransitiveResource;
                string4 = "R" + this.resourceList.indexOf(rDF_Resource);
                this.println("\t\t\t<use x='" + n8 + "' y='" + n7 + "' xlink:href='#" + string4 + "' style='fill:" + string5 + "' onclick='view_click(evt)'/>");
                if (++n36 <= n) continue;
                n36 = 1;
                ++n34;
            }
            this.println("\t\t</g>");
        } else if (this.broker.isMetaClass(rDF_Class)) {
            int n37;
            int n38;
            object = this.broker.getClassesOfMetaclass(rDF_Class, true);
            n4 = 0;
            n29 = n23 + n27 + n26 + 10;
            n9 = 1;
            n3 = 0;
            n2 = 0;
            if (object.size() != 0) {
                Iterator iterator8 = object.iterator();
                while (iterator8.hasNext()) {
                    n38 = this.getRx((RDF_Class)iterator8.next()) * 2;
                    if (n9 >= n38) continue;
                    n9 = n38;
                }
                if (n11 < n9) {
                    n11 = n9;
                }
                n3 = n11 / n9;
                n2 = object.size() / n3;
                if (object.size() % n3 != 0) {
                    ++n2;
                }
                n37 = 15 * n2 + 5;
            } else {
                n37 = 20;
            }
            this.println("\t\t<g transform='translate(" + n4 + "," + n29 + ")'>");
            this.println("\t\t\t<rect x='0' y='0' width='" + n11 + "' height='30' style='fill:lime;filter:url(#Bevel)'/>");
            this.println("\t\t\t<text x='" + n11 / 2 + "' y='20' style='text-anchor:middle;font-size:14;font-family:Arial'>Class Instances</text>");
            this.println("\t\t\t<rect x='0' y='30' width='" + n11 + "' height='" + n37 + "' style='fill:beige'/>");
            int n39 = 0;
            n38 = 1;
            Iterator iterator9 = object.iterator();
            while (iterator9.hasNext()) {
                n8 = n39 * n9 + 5;
                n7 = 15 * n38 + 30;
                string4 = "C" + this.classList.indexOf(iterator9.next());
                this.println("\t\t\t<use x='" + n8 + "' y='" + n7 + "' xlink:href='#" + string4 + "' style='fill:" + NoneTransitiveClass + "' onclick='view_click(evt)'/>");
                if (++n38 <= n2) continue;
                n38 = 1;
                ++n39;
            }
            this.println("\t\t</g>");
        } else if (this.broker.isPropertyClass(rDF_Class)) {
            int n40;
            int n41;
            object = this.broker.getPropertiesOfClass(rDF_Class, true);
            n4 = 0;
            n29 = n23 + n27 + n26 + 10;
            n9 = 1;
            n3 = 0;
            n2 = 0;
            if (object.size() != 0) {
                Iterator iterator10 = object.iterator();
                while (iterator10.hasNext()) {
                    object7 = this.broker.getLabelFor((RDF_Property)iterator10.next());
                    n41 = this.getLabelWidth((String)object7) + 10;
                    if (n9 >= n41) continue;
                    n9 = n41;
                }
                if (n11 < n9) {
                    n11 = n9;
                }
                n3 = n11 / n9;
                n2 = object.size() / n3;
                if (object.size() % n3 != 0) {
                    ++n2;
                }
                n40 = 15 * n2 + 5;
            } else {
                n40 = 20;
            }
            this.println("\t\t<g transform='translate(" + n4 + "," + n29 + ")'>");
            this.println("\t\t\t<rect x='0' y='0' width='" + n11 + "' height='30' style='fill:lime;filter:url(#Bevel)'/>");
            this.println("\t\t\t<text x='" + n11 / 2 + "' y='20' style='text-anchor:middle;font-size:14;font-family:Arial'>Property Instances</text>");
            this.println("\t\t\t<rect x='0' y='30' width='" + n11 + "' height='" + n40 + "' style='fill:beige'/>");
            int n42 = 0;
            n41 = 1;
            Iterator iterator11 = object.iterator();
            while (iterator11.hasNext()) {
                n8 = n42 * n9 + 5;
                n7 = 15 * n41 + 30;
                string4 = "P" + this.propertyList.indexOf(iterator11.next());
                this.println("\t\t\t<use x='" + n8 + "' y='" + n7 + "' style='fill:" + NoneTransitiveProperty + "' xlink:href='#" + string4 + "' onclick='view_click(evt)'/>");
                if (++n41 <= n2) continue;
                n41 = 1;
                ++n42;
            }
            this.println("\t\t</g>");
        }
        this.println("\t</svg>");
    }

    private void printClassLine(Collection collection, int n, int n2, int n3) throws IOException {
        int n4 = (n3 - n2) / 2;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            RDF_Class rDF_Class = (RDF_Class)iterator.next();
            int n5 = this.getRx(rDF_Class) * 2;
            String string = "C" + this.classList.indexOf(rDF_Class);
            this.println("\t\t<use x='" + (n4 + n5 / 2) + "' y='" + n + "' xlink:href='#_" + string + "' onclick='view2_click(evt)'/>");
            n4 += n5 + 10;
        }
    }

    private void printPropertyViews() throws IOException {
        int n = 0;
        while (n < this.propertyList.size()) {
            RDF_Property rDF_Property = (RDF_Property)this.propertyList.get(n);
            String string = "P" + n;
            this.printPropertyView(string, rDF_Property);
            ++n;
        }
    }

    private void printPropertyView(String string, RDF_Property rDF_Property) throws IOException {
        int n;
        int n2;
        Object object;
        Object object2;
        Object object3;
        int n3;
        int n4;
        int n5;
        int n6;
        Collection collection = this.broker.getDomainOfProperty(rDF_Property, true, false);
        Collection collection2 = this.broker.getRangeOfProperty(rDF_Property, true, false);
        Collection collection3 = this.broker.getSuperProperties(rDF_Property, false, true);
        Collection collection4 = this.broker.getSubProperties(rDF_Property, false, true);
        String string2 = "";
        Iterator iterator = rDF_Property.getcomment().iterator();
        while (iterator.hasNext()) {
            if (!string2.equals("")) {
                string2 = string2 + ". ";
            }
            string2 = string2 + ((Literal)iterator.next()).getvalue();
        }
        int n7 = DesktopViewWidth * 4 / 5;
        int n8 = 20 + collection3.size() * 15;
        if (!string2.equals("")) {
            n8 += 50;
        }
        int n9 = 20 + collection4.size() * 15;
        int n10 = 1;
        int n11 = 0;
        int n12 = 0;
        Iterator iterator2 = collection.iterator();
        while (iterator2.hasNext()) {
            n6 = this.getRx((RDF_Class)iterator2.next()) * 2;
            if (n10 >= n6) continue;
            n10 = n6;
        }
        n6 = 1;
        int n13 = 0;
        int n14 = 0;
        Iterator iterator3 = collection2.iterator();
        while (iterator3.hasNext()) {
            n5 = this.getRx((RDF_Class)iterator3.next()) * 2;
            if (n6 >= n5) continue;
            n6 = n5;
        }
        if (n7 < n10 * 2 + 20) {
            n7 = n10 * 2 + 20;
        }
        if (n7 < n6 * 2 + 20) {
            n7 = n6 * 2 + 20;
        }
        if ((n11 = (n7 / 2 - 10) / n10) == 0) {
            n11 = 1;
        }
        n12 = collection.size() / n11;
        if (collection.size() % n11 != 0) {
            ++n12;
        }
        if (n12 == 0) {
            n12 = 1;
        }
        if ((n13 = (n7 / 2 - 10) / n6) == 0) {
            n13 = 1;
        }
        n14 = collection2.size() / n13;
        if (collection2.size() % n13 != 0) {
            ++n14;
        }
        if (n14 == 0) {
            n14 = 1;
        }
        n5 = n12 > n14 ? n12 : n14;
        int n15 = 65 + n5 * 15;
        int n16 = n7 <= DesktopViewWidth ? DesktopViewWidth / 2 : n7 / 2;
        int n17 = n8 + n15 / 2;
        if (!collection3.isEmpty()) {
            n17 += 120;
        }
        this.println("\t<svg id='view:" + string + "' display='none' viewBox='0 0 " + DesktopViewWidth + " " + DesktopViewHeight + "'>");
        if (!string2.equals("")) {
            string2 = "<![CDATA[" + string2 + "]]>";
            this.println("\t\t<rect x='" + (n16 - n7 / 2) + "' y='5' width='" + n7 + "' height='40'");
            this.println("\t\t\t style='fill:lightgreen;stroke:lightgreen;filter:url(#Bevel)'/>");
            this.println("\t\t<svg x='" + (n16 - n7 / 2 + 5) + "' y='5' width='" + (n7 - 10) + "' height='40'>");
            this.println("\t\t\t<text x='0' y='15' style='fill:black;font-size:12;");
            this.println("\t\t\t\tfont-family:Arial'>Comment:</text>");
            this.println("\t\t\t<text y='30' style='fill:red;font-size:12;font-family:Arial'>");
            this.println("\t\t\t\t" + string2);
            this.println("\t\t\t\t<animate attributeName='x' attributeType='XML' \tfrom='" + (n7 - 10) + "' to='-" + this.getLabelWidth(string2) + "'");
            this.println("\t\t\t\t\tbegin='0s' dur='60s' fill='freeze' repeatCount='indefinite'/>");
            this.println("\t\t\t</text>");
            this.println("\t\t</svg>");
        }
        String string3 = this.broker.getLabelFor(rDF_Property);
        String string4 = "";
        String string5 = "";
        String string6 = "grey";
        RDF_Class rDF_Class = this.broker.getClassTypeOfProperty(rDF_Property);
        if (rDF_Class != null) {
            string4 = this.broker.getLabelFor(rDF_Class);
            string6 = MetaColor;
            string5 = "viewID='view:C" + this.classList.indexOf(rDF_Class) + "' onclick='view3_click(evt)'";
        }
        this.println("\t\t<g transform='translate(" + (n16 - n7 / 2) + "," + (n17 - n15 / 2) + ")'>");
        this.println("\t\t\t<rect  width='" + n7 + "' height='" + n15 + "'");
        this.println("\t\t\t\t style='fill:yellow;stroke:black;stroke-width:1;filter:url(#Bevel)'/>");
        this.println("\t\t\t<text x='" + n7 / 2 + "' y='20' style='text-anchor:middle;fill:black;");
        this.println("\t\t\t\t font-size:14;font-family:Arial'>" + string3 + "</text>");
        this.println("\t\t\t<text x='" + n7 / 2 + "' y='35' style='text-anchor:middle;fill:" + string6 + ";");
        this.println("\t\t\t\t font-size:12;font-family:Arial' " + string5 + ">(" + string4 + ")</text>");
        this.println("\t\t\t<line x1='0' y1='40' x2='" + n7 + "' y2='40'");
        this.println("\t\t\t\t \tstyle='fill:none;stroke:grey;stroke-width:1'/>");
        this.println("\t\t\t<line x1='" + n7 / 2 + "' y1='40' x2='" + n7 / 2 + "' y2='" + n15 + "'");
        this.println("\t\t\t\t \tstyle='fill:none;stroke:grey;stroke-width:1'/>");
        this.println("\t\t\t<text x='" + n7 / 4 + "' y='55' style='fill:black;text-anchor:middle;");
        this.println("\t\t\t\t font-size:12;font-family:Arial'>Domain</text>");
        int n18 = 55;
        int n19 = 0;
        int n20 = 1;
        Iterator iterator4 = collection.iterator();
        while (iterator4.hasNext()) {
            n4 = n19 * n10 + 10;
            n3 = 15 * n20 + n18;
            object3 = (RDF_Class)iterator4.next();
            string5 = "C" + this.classList.indexOf(object3);
            string6 = rDF_Property.getdomain().contains(object3) ? NoneTransitiveClass : TransitiveClass;
            this.println("\t\t\t<use x='" + n4 + "' y='" + n3 + "' xlink:href='#" + string5 + "' style='fill:" + string6 + "' onclick='view_click(evt)'/>");
            if (++n20 <= n5) continue;
            n20 = 1;
            ++n19;
        }
        this.println("\t\t\t<text x='" + n7 * 3 / 4 + "' y='55' style='fill:black;text-anchor:middle;");
        this.println("\t\t\t\t font-size:12;font-family:Arial'>Range</text>");
        n18 = 55;
        n19 = 0;
        n20 = 1;
        object3 = collection2.iterator();
        while (object3.hasNext()) {
            n4 = n19 * n6 + n7 / 2 + 10;
            n3 = 15 * n20 + n18;
            object2 = (RDF_Class)object3.next();
            string5 = "C" + this.classList.indexOf(object2);
            string6 = rDF_Property.getrange().contains(object2) ? NoneTransitiveClass : TransitiveClass;
            this.println("\t\t\t<use x='" + n4 + "' y='" + n3 + "' xlink:href='#" + string5 + "' style='fill:" + string6 + "' onclick='view_click(evt)'/>");
            if (++n20 <= n5) continue;
            n20 = 1;
            ++n19;
        }
        this.println("\t\t</g>");
        if (collection3.size() > 0) {
            int n21 = n8 - 10;
            n18 = 5;
            if (!string2.equals("")) {
                n21 -= 50;
                n18 += 50;
            }
            this.println("\t\t<rect x='" + (n16 - n7 / 2) + "' y='" + n18 + "' width='" + n7 + "' height='" + n21 + "'");
            this.println("\t\t\t style='fill:yellow;stroke:yellow;filter:url(#Bevel)'/>");
            n18 += 15;
            object = collection3.iterator();
            while (object.hasNext()) {
                RDF_Property rDF_Property2 = (RDF_Property)object.next();
                string5 = "P" + this.propertyList.indexOf(rDF_Property2);
                this.println("\t\t<use x='" + n16 + "' y='" + n18 + "' style='text-anchor:middle;fill:" + NoneTransitiveProperty + "' xlink:href='#" + string5 + "' onclick='view_click(evt)'/>");
                n18 += 15;
            }
            n4 = n16;
            n3 = n17 - n15 / 2;
            n2 = n16;
            n = n8 - 5;
            this.println("\t\t<path id='p" + this.path_counter + "' d='M" + n4 + " " + n3 + " L" + n2 + " " + n + "'");
            this.println("\t\t\t style='marker-end:url(#marker:Triangle);fill:none;stroke:black;stroke-width:2'/>");
            this.println("\t\t<text style='text-anchor:middle;font-size:12;font-family:Arial'>");
            this.println("\t\t\t<textPath xlink:href='#p" + this.path_counter + "' startOffset='50%'>");
            this.println("\t\t\t\trdfs:subPropertyOf");
            this.println("\t\t\t</textPath>");
            this.println("\t\t</text>");
            ++this.path_counter;
        }
        if (collection4.size() > 0) {
            n18 = n17 + n15 / 2 + 125;
            this.println("\t\t<rect x='" + (n16 - n7 / 2) + "' y='" + n18 + "' width='" + n7 + "' height='" + (n9 - 10) + "'");
            this.println("\t\t\t style='fill:yellow;stroke:yellow;filter:url(#Bevel)'/>");
            n18 += 15;
            object2 = collection4.iterator();
            while (object2.hasNext()) {
                object = (RDF_Property)object2.next();
                string5 = "P" + this.propertyList.indexOf(object);
                this.println("\t\t<use x='" + n16 + "' y='" + n18 + "' style='text-anchor:middle;fill:" + NoneTransitiveProperty + "' xlink:href='#" + string5 + "' onclick='view_click(evt)'/>");
                n18 += 15;
            }
            n4 = n16;
            n3 = n17 + n15 / 2 + 125;
            n2 = n16;
            n = n17 + n15 / 2;
            this.println("\t\t<path id='p" + this.path_counter + "' d='M" + n4 + " " + n3 + " L" + n2 + " " + n + "'");
            this.println("\t\t\t style='marker-end:url(#marker:Triangle);fill:none;stroke:black;stroke-width:2'/>");
            this.println("\t\t<text style='text-anchor:middle;font-size:12;font-family:Arial'>");
            this.println("\t\t\t<textPath xlink:href='#p" + this.path_counter + "' startOffset='50%'>");
            this.println("\t\t\t\trdfs:subPropertyOf");
            this.println("\t\t\t</textPath>");
            this.println("\t\t</text>");
            ++this.path_counter;
        }
        this.println("\t</svg>");
    }

    private void printResourceViews() throws IOException {
        int n = 0;
        while (n < this.resourceList.size()) {
            RDF_Resource rDF_Resource = (RDF_Resource)this.resourceList.get(n);
            String string = "R" + n;
            this.printResourceView(string, rDF_Resource);
            ++n;
        }
    }

    private void printResourceView(String string, RDF_Resource rDF_Resource) throws IOException {
        int n;
        Point[] pointArray;
        Object object;
        int n2;
        int n3;
        int n4;
        int n5;
        Object object2;
        Iterator iterator;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        int n11;
        int n12;
        int n13;
        Object object3;
        Object object4;
        Object object5;
        Object object6;
        HashMap hashMap = this.broker.getLinksWithSubject(rDF_Resource);
        HashMap hashMap2 = this.broker.getLinksWithObject(rDF_Resource);
        Collection collection = this.broker.getClassTypes(rDF_Resource, true);
        SizeComparator2 sizeComparator2 = new SizeComparator2();
        TreeSet<LinkArc> treeSet = new TreeSet<LinkArc>(sizeComparator2);
        TreeSet<LinkArc> treeSet2 = new TreeSet<LinkArc>(sizeComparator2);
        ArrayList<String> arrayList = new ArrayList<String>();
        String string2 = this.broker.getLabelFor(rDF_Resource);
        if (rDF_Resource instanceof RDF_Container) {
            string2 = "Container: " + string2;
            int n14 = 1;
            object6 = ((RDF_Container)rDF_Resource).getmember().iterator();
            while (object6.hasNext()) {
                object5 = object6.next();
                object4 = null;
                if (object5 instanceof RDF_Resource) {
                    object4 = (RDF_Resource)object5;
                }
                if (object4 != null) {
                    object5 = this.broker.getLabelFor((RDF_Resource)object4);
                }
                arrayList.add(n14 + ". " + object5);
                ++n14;
            }
        }
        if (rDF_Resource instanceof RDF_Statement) {
            string2 = "Statement: " + string2;
            Object object7 = ((RDF_Statement)rDF_Resource).getsubject();
            object6 = null;
            object5 = "";
            if (object7 instanceof RDF_Resource) {
                object6 = (RDF_Resource)object7;
            }
            if (object6 != null) {
                object5 = this.broker.getLabelFor((RDF_Resource)object6);
            }
            arrayList.add("Subject: " + (String)object5);
            object7 = ((RDF_Statement)rDF_Resource).getpredicate();
            object6 = (RDF_Resource)object7;
            if (object6 != null) {
                object5 = this.broker.getLabelFor((RDF_Resource)object6);
            }
            arrayList.add("Predicate: " + (String)object5);
            object4 = ((RDF_Statement)rDF_Resource).getobject();
            object5 = object4 instanceof Literal ? ((Literal)object4).getvalue() : ((Resource)object4).getID();
            arrayList.add("Object: " + (String)object5);
        }
        Iterator iterator2 = hashMap.keySet().iterator();
        while (iterator2.hasNext()) {
            object6 = (Link)iterator2.next();
            object5 = (RDF_Property)hashMap.get(object6);
            object4 = ((Link)object6).getobject();
            if (object4 instanceof Literal) {
                arrayList.add(this.broker.getLabelFor((RDF_Resource)object5) + " = " + ((Literal)object4).getvalue());
                continue;
            }
            object3 = null;
            if (object4 instanceof RDF_Resource) {
                object3 = (RDF_Resource)object4;
            }
            treeSet.add(new LinkArc((RDF_Resource)object3, (RDF_Property)object5));
        }
        object6 = hashMap2.keySet().iterator();
        while (object6.hasNext()) {
            object5 = (Link)object6.next();
            object4 = (RDF_Property)hashMap2.get(object5);
            object3 = "test";
            RDF_Resource rDF_Resource2 = this.broker.getResourceByID((String)object3);
            treeSet2.add(new LinkArc(rDF_Resource2, (RDF_Property)object4));
        }
        int n15 = 30 + arrayList.size() * 15;
        int n16 = this.getLabelWidth(string2);
        Iterator iterator3 = arrayList.iterator();
        while (iterator3.hasNext()) {
            n13 = this.getLabelWidth((String)iterator3.next());
            if (n16 >= n13) continue;
            n16 = n13;
        }
        if ((n16 += 10) < 200) {
            n16 = 200;
        }
        if (treeSet2.isEmpty()) {
            n12 = 0;
            n11 = 0;
        } else {
            n12 = this.getWidth(((LinkArc)treeSet2.toArray()[treeSet2.size() - 1]).rdf_resource) + 10;
            n11 = (treeSet2.size() + 1) / 2 * 35 + 50;
        }
        if (treeSet.isEmpty()) {
            n10 = 0;
            n9 = 0;
        } else {
            n10 = this.getWidth(((LinkArc)treeSet.toArray()[treeSet.size() - 1]).rdf_resource) + 10;
            n9 = treeSet.size() / 2 * 35 + 50;
        }
        if (n12 + n16 + n10 < DesktopViewWidth) {
            n8 = DesktopViewWidth;
            n13 = n12 + n16 / 2 <= n8 / 2 && n10 + n16 / 2 <= n8 / 2 ? n8 / 2 : n12 + (n8 - n12 - n10) / 2;
        } else {
            n8 = n12 + n16 + n10;
            n13 = n12 + n16 / 2;
        }
        int n17 = 0;
        int n18 = 35;
        Iterator iterator4 = collection.iterator();
        while (iterator4.hasNext()) {
            n7 = this.getRx((RDF_Class)iterator4.next()) * 2;
            if ((n17 += n7 + 10) <= n8 - 10) continue;
            n18 += 35;
            n17 = 0;
        }
        n18 += 20;
        int n19 = Math.max(n11, n9);
        if (n19 < 100) {
            n19 = 100;
        }
        n7 = n18 + n19 + n15 / 2;
        this.println("\t<svg id='view:" + string + "' display='none' viewBox='0 0 " + DesktopViewWidth + " " + DesktopViewHeight + "'>");
        if (collection.size() > 0) {
            this.println("\t\t<rect x='0' y='5' width='" + n8 + "' height='" + (n18 - 10) + "'");
            this.println("\t\t\t style='fill:yellow;stroke:yellow;filter:url(#Bevel)'/>");
            n6 = n18 - 28;
            ArrayList<RDF_Class> arrayList2 = new ArrayList<RDF_Class>();
            n17 = 0;
            iterator = collection.iterator();
            while (iterator.hasNext()) {
                object2 = (RDF_Class)iterator.next();
                int n20 = this.getRx((RDF_Class)object2) * 2;
                if (n17 + n20 + 10 > n8 - 10) {
                    this.printClassLine(arrayList2, n6, n17, n8);
                    arrayList2.clear();
                    n17 = n20;
                    n6 -= 35;
                } else {
                    n17 += n20 + 10;
                }
                arrayList2.add((RDF_Class)object2);
            }
            this.printClassLine(arrayList2, n6, n17, n8);
            n5 = n13;
            n4 = n7 - n15 / 2;
            n3 = n8 / 2;
            n2 = n18 - 5;
            this.println("\t\t<path id='p" + this.path_counter + "' d='M" + n5 + " " + n4 + " L" + n3 + " " + n2 + "'");
            this.println("\t\t\t style='stroke-dasharray:5,3;marker-end:url(#marker:Triangle);fill:none;stroke:black;stroke-width:2'/>");
            if (n3 < n5) {
                ++this.path_counter;
                this.println("\t\t<path id='p" + this.path_counter + "' d='M" + n3 + " " + n2 + " L" + n5 + " " + n4 + "'");
                this.println("\t\t\t style='fill:none;stroke:none'/>");
            }
            this.println("\t\t<text style='text-anchor:middle;font-size:12;font-family:Arial'>");
            this.println("\t\t\t<textPath xlink:href='#p" + this.path_counter + "' startOffset='50%'>");
            this.println("\t\t\t\trdf:type");
            this.println("\t\t\t</textPath>");
            this.println("\t\t</text>");
            ++this.path_counter;
        }
        this.println("\t\t<g transform='translate(" + (n13 - n16 / 2) + ", " + (n7 - n15 / 2) + ")'>");
        this.println("\t\t\t<rect width='" + n16 + "' height='" + n15 + "'");
        this.println("\t\t\t\t style='fill:yellow;stroke:black;stroke-width:1'/>");
        this.println("\t\t\t<text x='" + n16 / 2 + "' y='18' style='text-anchor:middle'>" + string2 + "</text>");
        this.println("\t\t\t<line x1='0' y1='25' x2='" + n16 + "' y2='25'");
        this.println("\t\t\t\t style='fill:none;stroke:grey;stroke-width:1'/>");
        int n21 = 40;
        iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            this.println("\t\t\t<text x='5' y='" + n21 + "' style='font-size:12;font-family:Arial'>" + (String)iterator.next() + "</text>");
            n21 += 15;
        }
        this.println("\t\t</g>");
        n6 = n7 - n15 / 2 - 80;
        n21 = n15 + 130;
        int n22 = 10;
        object2 = treeSet2.iterator();
        while (object2.hasNext()) {
            LinkArc linkArc = (LinkArc)object2.next();
            object = "R" + this.resourceList.indexOf(linkArc.rdf_resource);
            this.println("\t\t<use x='" + n22 + "' y='" + n6 + "' xlink:href='#_" + (String)object + "' onclick='view2_click(evt)'/>");
            n5 = 10 + this.getWidth(linkArc.rdf_resource);
            n4 = n6 + 12;
            pointArray = Clipping.getClipped(n5, n4, n13, n7, n13 - n16 / 2, n13 + n16 / 2, n7 - n15 / 2, n7 + n15 / 2);
            if (pointArray[0].x == n13 && pointArray[0].y == n7) {
                n3 = pointArray[1].x;
                n2 = pointArray[1].y;
            } else {
                n3 = pointArray[0].x;
                n2 = pointArray[0].y;
            }
            int n23 = (int)Math.sqrt((n5 - n3) * (n5 - n3) + (n4 - n2) * (n4 - n2));
            n = (this.getLabelWidth(linkArc.getPropertyLabel()) + n23) * 25 / n23;
            String string3 = "viewID='view:P" + this.propertyList.indexOf(linkArc.rdf_property) + "' onclick='view3_click(evt)'";
            this.println("\t\t<path id='p" + this.path_counter + "' d='M" + n5 + " " + n4 + " L" + n3 + " " + n2 + "'");
            this.println("\t\t\t style='marker-end:url(#marker:Triangle-royalblue);fill:none;stroke:royalblue;stroke-width:2'/>");
            this.println("\t\t<text style='text-anchor:middle;fill:royalblue;font-size:12;font-family:Arial'>");
            this.println("\t\t\t<textPath xlink:href='#p" + this.path_counter + "' startOffset='" + n + "%' " + string3 + ">");
            this.println("\t\t\t" + linkArc.getPropertyLabel() + "");
            this.println("\t\t\t</textPath>");
            this.println("\t\t</text>");
            ++this.path_counter;
            n6 += n21;
            n21 = n21 > 0 ? -(n21 + 35) : -n21 + 35;
        }
        n6 = n7 + n15 / 2 + 50;
        n21 = -n15 - 130;
        Iterator iterator5 = treeSet.iterator();
        while (iterator5.hasNext()) {
            object = (LinkArc)iterator5.next();
            pointArray = "R" + this.resourceList.indexOf(((LinkArc)object).rdf_resource);
            n22 = n8 - this.getWidth(((LinkArc)object).rdf_resource) - 10;
            this.println("\t\t<use x='" + n22 + "' y='" + n6 + "' xlink:href='#_" + (String)pointArray + "' onclick='view2_click(evt)'/>");
            n3 = n22;
            n2 = n6 + 12;
            Point[] pointArray2 = Clipping.getClipped(n3, n2, n13, n7, n13 - n16 / 2, n13 + n16 / 2, n7 - n15 / 2, n7 + n15 / 2);
            if (pointArray2[0].x == n13 && pointArray2[0].y == n7) {
                n5 = pointArray2[1].x;
                n4 = pointArray2[1].y;
            } else {
                n5 = pointArray2[0].x;
                n4 = pointArray2[0].y;
            }
            n = (int)Math.sqrt((n5 - n3) * (n5 - n3) + (n4 - n2) * (n4 - n2));
            int n24 = (this.getLabelWidth(((LinkArc)object).getPropertyLabel()) + n) * 25 / n;
            if (n24 < 50) {
                n24 = 100 - n24;
            }
            String string4 = "viewID='view:P" + this.propertyList.indexOf(((LinkArc)object).rdf_property) + "' onclick='view3_click(evt)'";
            this.println("\t\t<path id='p" + this.path_counter + "' d='M" + n5 + " " + n4 + " L" + n3 + " " + n2 + "'");
            this.println("\t\t\t style='marker-end:url(#marker:Triangle-royalblue);fill:none;stroke:royalblue;stroke-width:2'/>");
            this.println("\t\t<text style='text-anchor:middle;fill:royalblue;font-size:12;font-family:Arial'>");
            this.println("\t\t\t<textPath xlink:href='#p" + this.path_counter + "' startOffset='" + n24 + "%' " + string4 + ">");
            this.println("\t\t\t" + ((LinkArc)object).getPropertyLabel() + "");
            this.println("\t\t\t</textPath>");
            this.println("\t\t</text>");
            ++this.path_counter;
            n6 += n21;
            n21 = n21 > 0 ? -(n21 + 35) : -n21 + 35;
        }
        this.println("\t</svg>");
    }

    private class SizeComparator2
    implements Comparator {
        private SizeComparator2() {
        }

        public int compare(Object object, Object object2) {
            int n;
            int n2 = SVGGenerator.this.getLabelWidth(((LinkArc)object).getResourceLabel());
            return n2 < (n = SVGGenerator.this.getLabelWidth(((LinkArc)object2).getResourceLabel())) ? -1 : 1;
        }

        public boolean equals(Object object) {
            return false;
        }
    }

    private class LinkArc {
        public RDF_Resource rdf_resource;
        public RDF_Property rdf_property;

        public LinkArc(RDF_Resource rDF_Resource, RDF_Property rDF_Property) {
            this.rdf_resource = rDF_Resource;
            this.rdf_property = rDF_Property;
        }

        public String getPropertyLabel() {
            return SVGGenerator.this.broker.getLabelFor(this.rdf_property);
        }

        public String getResourceLabel() {
            return SVGGenerator.this.broker.getLabelFor(this.rdf_resource);
        }

        public String getResourceVizID() {
            return "R" + SVGGenerator.this.resourceList.indexOf(this.rdf_resource);
        }
    }

    private class SizeComparator
    implements Comparator {
        private SizeComparator() {
        }

        public int compare(Object object, Object object2) {
            int n;
            int n2 = SVGGenerator.this.getLabelWidth(((PropertyArc)object).getClassLabel());
            return n2 < (n = SVGGenerator.this.getLabelWidth(((PropertyArc)object2).getClassLabel())) ? -1 : 1;
        }

        public boolean equals(Object object) {
            return false;
        }
    }

    private class PropertyArc {
        public RDF_Class rdf_class;
        public RDF_Property rdf_property;

        public PropertyArc(RDF_Class rDF_Class, RDF_Property rDF_Property) {
            this.rdf_class = rDF_Class;
            this.rdf_property = rDF_Property;
        }

        public String getPropertyLabel() {
            return SVGGenerator.this.broker.getLabelFor(this.rdf_property);
        }

        public String getClassLabel() {
            return SVGGenerator.this.broker.getLabelFor(this.rdf_class);
        }

        public String getAttributeLabel() {
            String string = this.getPropertyLabel() + " -> ";
            string = this.rdf_class != null ? string + SVGGenerator.this.broker.getLabelFor(this.rdf_class) : string + "no range constraint";
            return string;
        }

        public boolean isDefinedWithDomain(RDF_Class rDF_Class) {
            return this.rdf_property.getdomain().contains(rDF_Class);
        }

        public boolean isDefinedWithRange(RDF_Class rDF_Class) {
            return this.rdf_property.getrange().contains(rDF_Class);
        }
    }
}

